/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.domain.source.file.handler;

import com.kingdee.bos.qing.data.domain.source.file.FileResult;
import com.kingdee.bos.qing.data.domain.source.file.domain.IFileSourceDomain;
import com.kingdee.bos.qing.data.domain.source.file.handler.XlsSheetContentsHandler;
import com.kingdee.bos.qing.data.exception.file.hssf.ExcelReadEndException;
import com.kingdee.bos.qing.data.util.ThreadCache;
import com.kingdee.bos.qing.util.StringUtils;
import org.apache.poi.hssf.eventusermodel.HSSFUserException;

public class XlsSheetColumnHandlerImpl
implements XlsSheetContentsHandler {
    private IFileSourceDomain fileSourceDomain;
    private FileResult fileResult = new FileResult();
    private int col;
    private String cellValue;
    private boolean fetchColunmName;
    private static final String STRING = "java.lang.String";

    public boolean isFetchColunmName() {
        return this.fetchColunmName;
    }

    public FileResult getFileResult() {
        return this.fileResult;
    }

    public XlsSheetColumnHandlerImpl(IFileSourceDomain fileSourceDomain, int col, boolean fetchColunmName) {
        this.fileSourceDomain = fileSourceDomain;
        this.col = col;
        this.fetchColunmName = fetchColunmName;
    }

    @Override
    public void endRow(int thisRow) throws HSSFUserException {
        if (thisRow == 0 && this.fetchColunmName) {
            throw new ExcelReadEndException();
        }
        if (thisRow > 0) {
            String type = this.fileSourceDomain.calculateType2(this.cellValue);
            if (!StringUtils.isBlank((CharSequence)type)) {
                ThreadCache.getDataTypeSet().add(type);
            }
            if (ThreadCache.getDataTypeSet().contains(STRING)) {
                throw new ExcelReadEndException();
            }
        }
    }

    @Override
    public void cell(int thisRow, int thisColumn, String content) {
        if (thisColumn == this.col && !this.fetchColunmName && thisRow > 0) {
            this.cellValue = content;
        }
        if (thisRow == 0 && this.fetchColunmName) {
            this.fileResult.getColIndexAndNameMap().put(thisColumn, content);
        }
    }
}

