/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.domain.source.file.parser;

import com.kingdee.bos.qing.common.i18n.Messages;
import com.kingdee.bos.qing.data.domain.source.file.parser.CSVParserExt;
import com.kingdee.bos.qing.util.LogUtil;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;

public class CSVReaderExt
implements Closeable {
    private BufferedReader br;
    private boolean hasNext = true;
    private CSVParserExt parser;
    private int skipLines;
    private boolean linesSkiped;
    public static final int DEFAULT_SKIP_LINES = 0;
    private String nextLine;

    public boolean isHasNext() {
        return this.hasNext;
    }

    public CSVReaderExt(Reader reader) {
        this(reader, ',', '\"', '\\');
    }

    public CSVReaderExt(Reader reader, char separator) {
        this(reader, separator, '\"', '\\');
    }

    public CSVReaderExt(Reader reader, char separator, char quotechar) {
        this(reader, separator, quotechar, '\\', 0, false);
    }

    public CSVReaderExt(Reader reader, char separator, char quotechar, boolean strictQuotes) {
        this(reader, separator, quotechar, '\\', 0, strictQuotes);
    }

    public CSVReaderExt(Reader reader, char separator, char quotechar, char escape) {
        this(reader, separator, quotechar, escape, 0, false);
    }

    public CSVReaderExt(Reader reader, char separator, char quotechar, int line) {
        this(reader, separator, quotechar, '\\', line, false);
    }

    public CSVReaderExt(Reader reader, char separator, char quotechar, char escape, int line) {
        this(reader, separator, quotechar, escape, line, false);
    }

    public CSVReaderExt(Reader reader, char separator, char quotechar, char escape, int line, boolean strictQuotes) {
        this(reader, separator, quotechar, escape, line, strictQuotes, true);
    }

    public CSVReaderExt(Reader reader, char separator, char quotechar, char escape, int line, boolean strictQuotes, boolean ignoreLeadingWhiteSpace) {
        this.br = new BufferedReader(reader);
        this.parser = new CSVParserExt(separator, quotechar, escape, strictQuotes, ignoreLeadingWhiteSpace);
        this.skipLines = line;
    }

    public List<String[]> readAll() throws IOException {
        ArrayList<String[]> allElements = new ArrayList<String[]>();
        while (this.hasNext) {
            String[] nextLineAsTokens = this.readNext();
            if (nextLineAsTokens == null) continue;
            allElements.add(nextLineAsTokens);
        }
        return allElements;
    }

    public String[] readNext() throws IOException {
        String[] result = null;
        do {
            String nextLine = this.getNextLine();
            if (!this.hasNext) {
                return result;
            }
            String[] r = this.parser.parseLineMulti(nextLine);
            if (r.length <= 0) continue;
            if (result == null) {
                result = r;
                continue;
            }
            String[] t = new String[result.length + r.length];
            System.arraycopy(result, 0, t, 0, result.length);
            System.arraycopy(r, 0, t, result.length, r.length);
            result = t;
        } while (this.parser.isPending());
        return result;
    }

    public long count() throws IOException {
        long result = 1L;
        do {
            this.getNextLine();
            if (this.hasNext) continue;
            return 0L;
        } while (this.parser.isPending());
        return result;
    }

    public boolean hasNext() {
        try {
            this.nextLine = null;
            this.nextLine = this.br.readLine();
            if (this.nextLine == null) {
                this.hasNext = false;
            }
        }
        catch (IOException e) {
            LogUtil.error((String)"\u5224\u65ad\u6587\u672c\u6587\u4ef6\u662f\u5426\u5b58\u5728\u4e0b\u4e00\u884c\u5f02\u5e38", (Throwable)e);
        }
        return this.hasNext;
    }

    public String[] readLine() throws IOException {
        String[] result = null;
        do {
            if (!this.hasNext) {
                return result;
            }
            String[] r = this.parser.parseLineMulti(this.nextLine);
            if (r.length <= 0) continue;
            if (result == null) {
                result = r;
                continue;
            }
            String[] t = new String[result.length + r.length];
            System.arraycopy(result, 0, t, 0, result.length);
            System.arraycopy(r, 0, t, result.length, r.length);
            result = t;
        } while (this.parser.isPending());
        return result;
    }

    private String getNextLine() throws IOException {
        String nextLine;
        if (!this.linesSkiped) {
            for (int i = 0; i < this.skipLines; ++i) {
                nextLine = this.br.readLine();
            }
            this.linesSkiped = true;
        }
        if ((nextLine = this.br.readLine()) == null) {
            this.hasNext = false;
        }
        if (null != nextLine && nextLine.contains("\ufffd")) {
            throw new IOException(Messages.getMLS((String)"codeErrorInfo", (String)"\u7f16\u7801\u4e0d\u6b63\u786e\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6587\u4ef6\u7f16\u7801\u3002", (Messages.ProjectName)Messages.ProjectName.QING_DATA));
        }
        return this.hasNext ? nextLine : null;
    }

    @Override
    public void close() throws IOException {
        this.br.close();
    }
}

