/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.domain.source.file.parser;

import com.kingdee.bos.qing.data.domain.source.file.parser.FileSourceNsICharsetDetectionObserver;
import com.kingdee.bos.qing.data.exception.AbstractFileSourceException;
import com.kingdee.bos.qing.data.exception.file.FileSourceEncodingParseException;
import com.kingdee.bos.qing.data.exception.file.FileSourceFileAccessException;
import com.kingdee.bos.qing.data.exception.file.FileSourceFileNotFoundException;
import com.kingdee.bos.qing.data.util.jchardet.nsDetector;
import com.kingdee.bos.qing.filesystem.manager.FileFactory;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFileVisitor;
import com.kingdee.bos.qing.filesystem.manager.model.AbstractQingFileType;
import com.kingdee.bos.qing.filesystem.manager.model.QingPersistentFileType;
import com.kingdee.bos.qing.filesystem.manager.model.QingTempFileType;
import com.kingdee.bos.qing.filesystem.stream.QingInputStream;
import com.kingdee.bos.qing.util.CloseUtil;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;

public class FileEncodingParser {
    protected static final String DOUBLE = "java.lang.Double";
    protected static final String LONG = "java.lang.Long";
    protected static final String STRING = "java.lang.String";
    protected static final String BOOLEAN = "java.lang.Boolean";
    protected static final String TIME = "java.sql.Time";
    protected static final String DATE = "java.util.Date";
    protected static final String UTF8 = "UTF-8";
    protected static final String GB2312 = "gb2312";
    protected static final String GBK = "GBK";
    protected static final String Unicode = "Unicode";
    protected static final String UTF16BE = "UTF-16BE";
    protected static final String TXT = ".txt";
    protected static final String CSV = ".csv";

    public static String guessFileEncoding(String fileName) throws AbstractFileSourceException {
        IQingFileVisitor fileVisitor = FileFactory.newFileVisitor((AbstractQingFileType)QingPersistentFileType.DATAMODELING_DS, (String)fileName);
        if (!fileVisitor.exists()) {
            fileVisitor = FileFactory.newFileVisitor((AbstractQingFileType)QingTempFileType.UPLOAD, (String)fileName);
        }
        QingInputStream inputStream = null;
        try {
            inputStream = fileVisitor.getInputStream();
        }
        catch (FileNotFoundException e) {
            throw new FileSourceFileNotFoundException(e);
        }
        catch (IOException e) {
            throw new FileSourceFileAccessException(e);
        }
        FileSourceNsICharsetDetectionObserver charsetDetectionObserver = new FileSourceNsICharsetDetectionObserver();
        nsDetector det = new nsDetector();
        det.Init(charsetDetectionObserver);
        byte[] buf = new byte[1024];
        boolean done = false;
        boolean isAscii = false;
        try {
            int len;
            while ((len = inputStream.read(buf, 0, buf.length)) != -1 && !(isAscii = det.isAscii(buf, len)) && !(done = det.DoIt(buf, len, false))) {
            }
        }
        catch (IOException e) {
            try {
                throw new FileSourceEncodingParseException(e);
            }
            catch (Throwable throwable) {
                CloseUtil.close((Closeable[])new Closeable[]{inputStream});
                throw throwable;
            }
        }
        CloseUtil.close((Closeable[])new Closeable[]{inputStream});
        det.DataEnd();
        boolean found = charsetDetectionObserver.isFound();
        String encoding = charsetDetectionObserver.getEncoding();
        if (isAscii) {
            encoding = GBK;
            found = true;
        }
        if (!found) {
            String[] prob = det.getProbableCharsets();
            if (prob.length > 0) {
                return prob[0];
            }
            return GBK;
        }
        return encoding;
    }
}

