/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.domain.visitor;

import com.kingdee.bos.qing.data.domain.source.AbstractDataSourceDomain;
import com.kingdee.bos.qing.data.domain.source.SourceDomainFactory;
import com.kingdee.bos.qing.data.domain.source.db.DataTypeToDesigningDataType;
import com.kingdee.bos.qing.data.model.designtime.AbstractDMViewItem;
import com.kingdee.bos.qing.data.model.designtime.AbstractEntity;
import com.kingdee.bos.qing.data.model.designtime.AbstractSource;
import com.kingdee.bos.qing.data.model.designtime.Box;
import com.kingdee.bos.qing.data.model.designtime.DMGroupItemView;
import com.kingdee.bos.qing.data.model.designtime.DMGroupView;
import com.kingdee.bos.qing.data.model.designtime.Entity;
import com.kingdee.bos.qing.data.model.designtime.EntitySubView;
import com.kingdee.bos.qing.data.model.designtime.Parild;
import com.kingdee.bos.qing.data.model.designtime.Property;
import com.kingdee.bos.qing.data.model.designtime.Relation;
import com.kingdee.bos.qing.data.model.designtime.UnionEntity;
import com.kingdee.bos.qing.data.model.designtime.UnionEntityType;
import com.kingdee.bos.qing.datasource.exception.AbstractDataSourceException;
import com.kingdee.bos.qing.datasource.meta.DSDimensionNecessary;
import com.kingdee.bos.qing.datasource.meta.DSMetaEntity;
import com.kingdee.bos.qing.datasource.meta.DSMetaProperty;
import com.kingdee.bos.qing.datasource.meta.DSMetaRelation;
import com.kingdee.bos.qing.datasource.meta.DSParentChildDimension;
import com.kingdee.bos.qing.datasource.meta.DataType;
import com.kingdee.bos.qing.datasource.meta.view.AbstractDSViewItem;
import com.kingdee.bos.qing.datasource.meta.view.DSMetaEntitySubView;
import com.kingdee.bos.qing.datasource.meta.view.DSMetaFieldGroup;
import com.kingdee.bos.qing.datasource.meta.view.DSMetaFieldItem;
import com.kingdee.bos.qing.datasource.model.MultiDataSourceWrap;
import com.kingdee.bos.qing.datasource.spec.AbstractSingleDataSourceVisitor;
import com.kingdee.bos.qing.datasource.spec.mult.MultiDataSourceVisitor;
import com.kingdee.bos.qing.util.LogUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DSModelBuilder {
    private Box box;
    private Map<Set<String>, AbstractSingleDataSourceVisitor> dataFileVisitorMaps;
    private Map<String, AbstractSource> sourceMap;
    private Map<String, AbstractEntity> entityMap;
    private List<DSMetaEntity> erEntities;
    private Map<String, DSMetaEntity> erEntityMap;
    private Map<String, Map<String, DSMetaProperty>> erEntitiyPropertyMap = new HashMap<String, Map<String, DSMetaProperty>>();
    private List<DSMetaRelation> erRelations;

    public DSModelBuilder(Box box, Map<Set<String>, AbstractSingleDataSourceVisitor> dataFileVisitorMaps) throws AbstractDataSourceException {
        this.box = box;
        this.dataFileVisitorMaps = dataFileVisitorMaps;
        this.buildSources();
        this.buildDsMetaEntities();
        this.buildDSMetaRelations();
    }

    public List<DSMetaEntity> getErEntities() {
        return this.erEntities;
    }

    public List<DSMetaRelation> getErRelations() {
        return this.erRelations;
    }

    public Map<String, DSMetaEntity> getErEntityMap() {
        return this.erEntityMap;
    }

    public Map<String, AbstractEntity> getEntityMap() {
        return this.entityMap;
    }

    public Map<String, AbstractSource> getSourceMap() {
        return this.sourceMap;
    }

    public MultiDataSourceVisitor createDataSourceVistor(MultiDataSourceWrap dataSourceWrap) {
        return new MultiDataSourceVisitor(dataSourceWrap, this.erEntities, this.erRelations);
    }

    private void buildSources() {
        List<AbstractSource> sources = this.box.getSources();
        if (sources != null) {
            this.sourceMap = new HashMap<String, AbstractSource>(sources.size(), 1.0f);
            for (AbstractSource source : sources) {
                this.sourceMap.put(source.getName(), source);
            }
        }
    }

    private void buildDsMetaEntities() throws AbstractDataSourceException {
        List<AbstractEntity> entities = this.box.getEntities();
        this.erEntities = new ArrayList<DSMetaEntity>(entities.size());
        this.entityMap = new HashMap<String, AbstractEntity>(entities.size());
        this.erEntityMap = new HashMap<String, DSMetaEntity>(entities.size());
        for (int index = 0; index < entities.size(); ++index) {
            AbstractEntity abstractEntity = entities.get(index);
            DSMetaEntity dsMetaEntity = this.buildDSMetaEntity(abstractEntity);
            this.erEntityMap.put(dsMetaEntity.getName(), dsMetaEntity);
            this.entityMap.put(abstractEntity.getName(), abstractEntity);
            this.erEntities.add(dsMetaEntity);
        }
    }

    private DSMetaEntity buildDSMetaEntity(AbstractEntity modelEntity) throws AbstractDataSourceException {
        DSMetaEntity dsMetaEntity = new DSMetaEntity(modelEntity.getName(), modelEntity.getAlias());
        dsMetaEntity.setParentName(modelEntity.getParentName());
        HashMap<String, DSMetaProperty> erPropertyMap = new HashMap<String, DSMetaProperty>();
        this.erEntitiyPropertyMap.put(dsMetaEntity.getName(), erPropertyMap);
        this.createProperty(modelEntity, dsMetaEntity, erPropertyMap);
        DSModelBuilder.createParild(modelEntity, dsMetaEntity, erPropertyMap);
        DSModelBuilder.createEntitySubView(modelEntity, dsMetaEntity, erPropertyMap);
        DSModelBuilder.createViewItem(modelEntity, dsMetaEntity, erPropertyMap);
        this.fixDsMetaEntity(modelEntity, dsMetaEntity);
        return dsMetaEntity;
    }

    private void fixDsMetaEntity(AbstractEntity absEntity, DSMetaEntity dsMetaEntity) {
        String sourceName;
        AbstractDataSourceDomain sourceDomain = null;
        if (absEntity instanceof UnionEntity) {
            UnionEntity unionEntity = (UnionEntity)absEntity;
            if (unionEntity.getUnionType() == UnionEntityType.BIZ && (sourceName = unionEntity.getChildren().get(0).getSource()) != null) {
                AbstractSource source = this.sourceMap.get(sourceName);
                sourceDomain = SourceDomainFactory.getSourceDomainSilence(source);
            }
        } else {
            Entity entity = (Entity)absEntity;
            sourceName = entity.getSource();
            if (entity.hasExtractModel() && sourceName != null) {
                AbstractSource source = this.sourceMap.get(sourceName);
                sourceDomain = SourceDomainFactory.getSourceDomainSilence(source);
            }
        }
        if (null != sourceDomain) {
            HashSet<String> entityName = new HashSet<String>();
            entityName.add(absEntity.getName());
            AbstractSingleDataSourceVisitor singleDataSourceVisitor = this.dataFileVisitorMaps.get(entityName);
            if (null == singleDataSourceVisitor) {
                LogUtil.warn((String)("fixDsMetaEntity error,data source visitor not found,entityName:" + entityName));
                return;
            }
            sourceDomain.fixRuntimeExtractModeDSMetaEntity(absEntity, dsMetaEntity, singleDataSourceVisitor.getMetaInfo());
        }
    }

    private void createProperty(AbstractEntity modelEntity, DSMetaEntity dsMetaEntity, Map<String, DSMetaProperty> erPropertyMap) {
        for (Property dmProperty : modelEntity.getProperties()) {
            DSMetaProperty dsMetaProperty = DSModelBuilder.createProperty(dmProperty);
            erPropertyMap.put(dsMetaProperty.getName(), dsMetaProperty);
            dsMetaEntity.getProperties().add(dsMetaProperty);
        }
    }

    public static DSMetaProperty createProperty(Property property) {
        DataType outputDataType = DataTypeToDesigningDataType.designtimeToRuntime(property.getOutputDataType());
        String propertyName = property.getName();
        DSMetaProperty dsMetaProperty = new DSMetaProperty(propertyName, property.getAlias(), outputDataType, property.getFormatString(), Boolean.valueOf(property.isHide()));
        dsMetaProperty.setGroup(property.getGroup());
        return dsMetaProperty;
    }

    private static void createParild(AbstractEntity modelEntity, DSMetaEntity dsMetaEntity, Map<String, DSMetaProperty> erPropertyMap) {
        List<Parild> parilds = modelEntity.getParilds();
        if (parilds == null || parilds.isEmpty()) {
            return;
        }
        for (Parild parild : modelEntity.getParilds()) {
            DSParentChildDimension dsParentChildDimension = new DSParentChildDimension();
            dsParentChildDimension.setName(parild.getName());
            dsParentChildDimension.setAlias(parild.getAlias());
            Parild.Necessary necessary = parild.getNecessary();
            if (Parild.Necessary.Indispensable == necessary) {
                dsParentChildDimension.setNecessary(DSDimensionNecessary.Indispensable);
            } else {
                dsParentChildDimension.setNecessary(DSDimensionNecessary.RootRepresented);
            }
            DSMetaProperty dsMetaProperty = erPropertyMap.get(parild.getIdField());
            if (dsMetaProperty == null) continue;
            dsMetaProperty.setGroup(parild.getName());
            dsParentChildDimension.setIdFieldName(parild.getIdField());
            dsMetaProperty = erPropertyMap.get(parild.getParentIdField());
            if (dsMetaProperty == null) continue;
            dsMetaProperty.setGroup(parild.getName());
            dsParentChildDimension.setParentIdFieldName(parild.getParentIdField());
            dsMetaProperty = erPropertyMap.get(parild.getDefaultDisplayField());
            if (dsMetaProperty == null) {
                dsParentChildDimension.setDisplayFieldName(parild.getIdField());
            } else {
                dsParentChildDimension.setDisplayFieldName(parild.getDefaultDisplayField());
                dsMetaProperty.setGroup(parild.getName());
            }
            dsMetaProperty = erPropertyMap.get(parild.getSortAccordingField());
            if (dsMetaProperty == null) {
                dsParentChildDimension.setSortAccordingFieldName(dsParentChildDimension.getDisplayFieldName());
            } else {
                dsParentChildDimension.setSortAccordingFieldName(parild.getSortAccordingField());
                dsMetaProperty.setGroup(parild.getName());
            }
            if (dsMetaEntity.getParentChildDimensions() == null) {
                dsMetaEntity.setParentChildDimensions(new ArrayList());
            }
            dsMetaEntity.getParentChildDimensions().add(dsParentChildDimension);
        }
    }

    private static void createEntitySubView(AbstractEntity modelEntity, DSMetaEntity dsMetaEntity, Map<String, DSMetaProperty> erPropertyMap) {
        List<EntitySubView> entitySubViews = modelEntity.getSubViews();
        if (entitySubViews != null) {
            String entityAlias = modelEntity.getAlias();
            for (EntitySubView entitySubView2 : entitySubViews) {
                DSMetaEntitySubView subView2 = DSModelBuilder.createEntitySubView(entityAlias, entitySubView2, erPropertyMap);
                dsMetaEntity.getSubViews().add(subView2);
            }
        }
    }

    private static void createViewItem(AbstractEntity modelEntity, DSMetaEntity dsMetaEntity, Map<String, DSMetaProperty> erPropertyMap) {
        List<AbstractDMViewItem> viewItems = modelEntity.getViewItems();
        if (viewItems != null) {
            for (AbstractDMViewItem viewItem : viewItems) {
                AbstractDSViewItem viewItem2 = DSModelBuilder.createViewItem(viewItem, erPropertyMap);
                dsMetaEntity.getViewItems().add(viewItem2);
            }
        }
    }

    private static DSMetaEntitySubView createEntitySubView(String parentEntityAlias, EntitySubView entitySubView, Map<String, DSMetaProperty> erPropertyMap) {
        List<AbstractDMViewItem> viewItems;
        String entitySubViewAlias = entitySubView.getAlias();
        DSMetaEntitySubView subView = new DSMetaEntitySubView(entitySubView.getName(), entitySubViewAlias, entitySubView.getDSSubViewType());
        List<EntitySubView> entitySubViews = entitySubView.getSubViews();
        if (entitySubViews != null) {
            for (EntitySubView entitySubView2 : entitySubViews) {
                DSMetaEntitySubView subView2 = DSModelBuilder.createEntitySubView(entitySubViewAlias, entitySubView2, erPropertyMap);
                subView.addSubView(subView2);
            }
        }
        if ((viewItems = entitySubView.getViewItems()) != null) {
            for (AbstractDMViewItem viewItem : viewItems) {
                AbstractDSViewItem viewItem2 = DSModelBuilder.createViewItem(viewItem, erPropertyMap);
                if (viewItem2 == null) continue;
                subView.addViewItem(viewItem2);
            }
        }
        return subView;
    }

    private static AbstractDSViewItem createViewItem(AbstractDMViewItem viewItem, Map<String, DSMetaProperty> erPropertyMap) {
        if (viewItem instanceof DMGroupView) {
            DMGroupView dmGroupView = (DMGroupView)viewItem;
            DSMetaFieldGroup dsMetaFieldGroup = new DSMetaFieldGroup(dmGroupView.getName(), dmGroupView.getAlias());
            List<DMGroupItemView> itemViews = dmGroupView.getItems();
            if (itemViews != null) {
                for (DMGroupItemView dmGroupItemView : itemViews) {
                    DSMetaFieldItem dsMetaFieldItem = new DSMetaFieldItem(dmGroupItemView.getName());
                    dsMetaFieldGroup.addField(dsMetaFieldItem);
                }
            }
            return dsMetaFieldGroup;
        }
        DMGroupItemView dmGroupItemView = (DMGroupItemView)viewItem;
        DSMetaProperty dsMetaProperty = erPropertyMap.get(viewItem.getName());
        if (dsMetaProperty == null) {
            return null;
        }
        DSMetaFieldItem dsMetaFieldItem = new DSMetaFieldItem(dmGroupItemView.getName());
        return dsMetaFieldItem;
    }

    private void buildDSMetaRelations() {
        List<Relation> relations = this.box.getRelations();
        this.erRelations = new ArrayList<DSMetaRelation>(relations.size());
        for (int index = 0; index < relations.size(); ++index) {
            Relation modelRelation = relations.get(index);
            this.erRelations.add(this.buildDSMetaRelation(index, modelRelation));
        }
    }

    private DSMetaRelation buildDSMetaRelation(int index, Relation modelRelation) {
        String fromEntityName = modelRelation.getFromEntity();
        String toEntityName = modelRelation.getToEntity();
        String fromPropertyName = modelRelation.getFromProperty();
        String toPropertyName = modelRelation.getToProperty();
        DSMetaEntity fromEntity = this.erEntityMap.get(fromEntityName);
        DSMetaEntity toEntity = this.erEntityMap.get(toEntityName);
        DSMetaProperty frmoProperty = this.erEntitiyPropertyMap.get(fromEntityName).get(fromPropertyName);
        DSMetaProperty toProperty = this.erEntitiyPropertyMap.get(toEntityName).get(toPropertyName);
        return new DSMetaRelation(fromEntity, toEntity, frmoProperty, toProperty, DSModelBuilder.selectRelationType(modelRelation), DSModelBuilder.selectJoinType(modelRelation), index);
    }

    private static DSMetaRelation.DSMetaJoinType selectJoinType(Relation modelRelation) {
        DSMetaRelation.DSMetaJoinType joinType = null;
        joinType = modelRelation.isFromPointKeepFifthWheel() && modelRelation.isToPointKeepFifthWheel() ? DSMetaRelation.DSMetaJoinType.FullJoin : (modelRelation.isFromPointKeepFifthWheel() && !modelRelation.isToPointKeepFifthWheel() ? DSMetaRelation.DSMetaJoinType.LeftJoin : (!modelRelation.isFromPointKeepFifthWheel() && modelRelation.isToPointKeepFifthWheel() ? DSMetaRelation.DSMetaJoinType.RightJoin : DSMetaRelation.DSMetaJoinType.InnerJoin));
        return joinType;
    }

    private static DSMetaRelation.DSMetaRelationType selectRelationType(Relation modelRelation) {
        switch (modelRelation.getRelated()) {
            case From1To1: {
                return DSMetaRelation.DSMetaRelationType.oneToOne;
            }
            case From1ToN: {
                return DSMetaRelation.DSMetaRelationType.oneToN;
            }
            case FromNTo1: {
                return DSMetaRelation.DSMetaRelationType.nToOne;
            }
        }
        return null;
    }
}

