/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.model.designtime;

import com.kingdee.bos.qing.data.domain.source.api.constant.OpenAPIConstant;
import com.kingdee.bos.qing.data.domain.source.api.http.RESTfulHttp;
import com.kingdee.bos.qing.data.domain.source.api.utils.OpenAPIUtil;
import com.kingdee.bos.qing.data.exception.api.OpenAPIAuthException;
import com.kingdee.bos.qing.data.exception.api.OpenAPIException;
import com.kingdee.bos.qing.data.model.designtime.AbstractSource;
import com.kingdee.bos.qing.data.model.designtime.source.OpenAPISource;
import com.kingdee.bos.qing.data.model.designtime.source.authmodel.AbstractAuthModel;
import com.kingdee.bos.qing.data.model.runtime.RuntimeEntity;
import com.kingdee.bos.qing.util.StringUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RESTfulURLModel {
    private String rootPath;
    private String resourcePath;
    public static final String DATA = "/data";
    private String queryOptions;
    private Integer pageSize;
    private static final String REGEX = "^(https?:\\/\\/.*\\.QData\\b)\\/?([\\w]*)\\/?(data)?(\\?.+|$)";
    private static final Pattern PATTERN = Pattern.compile("^(https?:\\/\\/.*\\.QData\\b)\\/?([\\w]*)\\/?(data)?(\\?.+|$)");
    private static final String PAGESIZE_REGEX = "(\\?|&){1}#{0,1}pageSize=[a-zA-Z0-9]*(&{1})";
    private static final Pattern PAGESIZE_PATTERN = Pattern.compile("(\\?|&){1}#{0,1}pageSize=[a-zA-Z0-9]*(&{1})");

    public String getRootPath() {
        return this.rootPath;
    }

    public void setRootPath(String rootPath) {
        this.rootPath = rootPath;
    }

    public String getResourcePath() {
        return this.resourcePath;
    }

    public void setResourcePath(String resourcePath) {
        this.resourcePath = resourcePath;
    }

    public String getQueryOptions() {
        return this.queryOptions == null ? "" : this.queryOptions;
    }

    public void setQueryOptions(String queryOptions) {
        this.queryOptions = queryOptions;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public static RESTfulURLModel newInstance() {
        return new RESTfulURLModel();
    }

    public void checkValidity(AbstractSource source) throws OpenAPIException {
        AbstractAuthModel authModel;
        OpenAPISource openAPISource = (OpenAPISource)source;
        String url = OpenAPIUtil.decodeUrl(openAPISource.getUrl());
        Matcher matcher = PATTERN.matcher(url);
        String paramsStr = null;
        if (!matcher.find()) {
            throw new OpenAPIException(2061100);
        }
        this.setRootPath(matcher.group(1));
        this.setResourcePath(matcher.group(2));
        paramsStr = matcher.group(4);
        if (paramsStr != null) {
            if (paramsStr.contains("pageNo") || paramsStr.contains("selectedFields")) {
                throw new OpenAPIException(2061104);
            }
            if (paramsStr.contains("pageSize")) {
                String pageSizeStr = RESTfulURLModel.getPageSizeValueByParamStr(url);
                if (pageSizeStr != null) {
                    Integer pageSize = Integer.parseInt(pageSizeStr);
                    if (pageSize < OpenAPIConstant.MIN_PAGESIZE || pageSize > OpenAPIConstant.MAX_PAGESIZE) {
                        throw new OpenAPIException(2061103);
                    }
                    this.setPageSize(pageSize);
                }
                paramsStr = RESTfulURLModel.removeParams(paramsStr, new String[]{"pageSize"});
            }
            this.setQueryOptions(paramsStr);
        }
        if ((authModel = openAPISource.getAuthModel()) != null && authModel.isErrorParam()) {
            throw new OpenAPIAuthException(2061302);
        }
    }

    public void checkConnectable(AbstractSource source) throws OpenAPIException {
        String errorStr;
        OpenAPISource openAPISource = (OpenAPISource)source;
        String url = OpenAPIUtil.decodeUrl(openAPISource.getUrl());
        Map<String, Object> systemParams = RESTfulURLModel.getSystemParams(null, 1, 1L);
        Map headsMap = null;
        AbstractAuthModel authModel = openAPISource.getAuthModel();
        if (authModel != null) {
            headsMap = authModel.createRequestHeads(url);
        }
        if (StringUtils.isNotBlank((CharSequence)(errorStr = RESTfulHttp.checkConnectable(url, headsMap, systemParams)))) {
            if ("401".equals(errorStr)) {
                throw new OpenAPIException(2061301);
            }
            throw new OpenAPIException(2061201, errorStr);
        }
    }

    public String getUsableEntitiesURL() throws OpenAPIException {
        return this.getRootPath() + "/";
    }

    public String getDesigntimeDataObjectURL(String associateName) {
        return this.getRootPath() + "/" + associateName + "/";
    }

    public String getRowCountURL(RuntimeEntity runtimeEntity) throws OpenAPIException {
        return this.getRootPath() + "/" + runtimeEntity.getAssociateName() + "/row_count" + this.getQueryOptions();
    }

    public String getPreviewDataUrl(RuntimeEntity runtimeEntity) throws OpenAPIException {
        return this.getRootPath() + "/" + runtimeEntity.getAssociateName() + DATA + this.getQueryOptions();
    }

    public String getExtractDataUrl(RuntimeEntity runtimeEntity) throws OpenAPIException {
        return this.getRootPath() + "/" + runtimeEntity.getAssociateName() + DATA + this.getQueryOptions();
    }

    public static Map<String, Object> getSystemParams(String selectedFields, Integer pageNo, long pageSize) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("pageNo", pageNo);
        map.put("pageSize", pageSize);
        map.put("selectedFields", selectedFields);
        return map;
    }

    public static String getPageSizeValueByParamStr(String url) {
        Matcher m = PAGESIZE_PATTERN.matcher(url = url + "&");
        if (m.find()) {
            return m.group(0).split("=")[1].replace("&", "");
        }
        return null;
    }

    public static String removeParams(String url, String[] params) {
        StringBuilder ps = new StringBuilder();
        ps.append("(?<=[\\?&])");
        ps.append('(');
        for (int i = 0; i < params.length; ++i) {
            ps.append(params[i]).append('|');
        }
        ps.deleteCharAt(ps.length() - 1);
        ps.append(')');
        ps.append("=[^&]*&?");
        url = url.replaceAll(ps.toString(), "");
        url = url.replaceAll("(\\?|&+)$", "");
        return url;
    }
}

