/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.model.designtime;

import com.kingdee.bos.qing.data.exception.ModelParseException;
import com.kingdee.bos.qing.data.model.designtime.AbstractEntity;
import com.kingdee.bos.qing.data.model.designtime.ColumnToRowProperty;
import com.kingdee.bos.qing.data.model.designtime.Entity;
import com.kingdee.bos.qing.data.model.designtime.EntityType;
import com.kingdee.bos.qing.data.model.designtime.FilterItem;
import com.kingdee.bos.qing.data.model.designtime.Property;
import com.kingdee.bos.qing.data.model.designtime.UnionEntityType;
import com.kingdee.bos.qing.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom2.Content;
import org.jdom2.Element;

public class UnionEntity
extends AbstractEntity {
    private List<Entity> children = new ArrayList<Entity>();
    private UnionEntityType unionType = UnionEntityType.NOT_BIZ;

    public List<Entity> getChildren() {
        return this.children;
    }

    public void setChildren(List<Entity> children) {
        this.children = children;
    }

    public Map<String, Set<Entity>> getSameSourceDirectModelEntityMap() {
        HashMap<String, Set<Entity>> sameSourceDirectModelEntityMap = new HashMap<String, Set<Entity>>();
        for (Entity entity : this.children) {
            if (!entity.hasDirectModel()) continue;
            String sourceName = entity.getSource();
            Set<Entity> entitySet = null;
            if (sameSourceDirectModelEntityMap.containsKey(sourceName)) {
                entitySet = (Set)sameSourceDirectModelEntityMap.get(sourceName);
            } else {
                entitySet = new HashSet();
                sameSourceDirectModelEntityMap.put(sourceName, entitySet);
            }
            entitySet.add(entity);
        }
        return sameSourceDirectModelEntityMap;
    }

    @Override
    public boolean isUnion() {
        return true;
    }

    public UnionEntity createNewUnionEntity(Set<Entity> entitySet) throws ModelParseException {
        ArrayList<Entity> oldChildren = new ArrayList<Entity>();
        oldChildren.addAll(this.children);
        this.children.clear();
        this.children.addAll(entitySet);
        UnionEntity unionEntity = new UnionEntity();
        unionEntity.fromXml(this.toXml(), new HashSet<String>());
        this.children.clear();
        this.children.addAll(oldChildren);
        return unionEntity;
    }

    @Override
    public boolean hasExtractModel() {
        for (Entity entity : this.children) {
            if (!entity.hasDirectModel()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean hasDirectModel() {
        for (Entity entity : this.children) {
            if (entity.hasDirectModel()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void setDirectModel(boolean directModel) {
    }

    @Override
    public boolean isUnionUnitEntity() {
        return false;
    }

    @Override
    public boolean isRealDataEntity() {
        return false;
    }

    @Override
    protected void attrFromRootElement(Element rootNode) {
        String unionTypeValue = rootNode.getAttributeValue("unionType");
        this.unionType = StringUtils.isEmpty((CharSequence)unionTypeValue) ? UnionEntityType.NOT_BIZ : UnionEntityType.valueOf(unionTypeValue);
    }

    public UnionEntityType getUnionType() {
        return this.unionType;
    }

    public void setUnionType(UnionEntityType unionType) {
        this.unionType = unionType;
    }

    @Override
    public Element toXml() {
        Element node = new Element("UnionEntity");
        node.setAttribute("name", this.getName());
        node.setAttribute("alias", this.getAlias());
        node.setAttribute("unionType", this.unionType.name());
        String parentName = this.getParentName();
        if (this.unionType == UnionEntityType.BIZ && null != parentName) {
            node.setAttribute("parentName", parentName);
        }
        if (this.getDesign() != null) {
            Element nodeDesign = this.getDesign().toXml();
            nodeDesign.setName("Design");
            node.addContent((Content)nodeDesign);
        }
        Element nodeProperties = new Element("Properties");
        for (Property property : this.getProperties()) {
            nodeProperties.addContent((Content)property.toXml());
        }
        node.addContent((Content)nodeProperties);
        if (this.getFilters() != null && this.getFilters().size() > 0) {
            Element nodeFilters = new Element("Filters");
            for (FilterItem filter : this.getFilters()) {
                nodeFilters.addContent((Content)filter.toXml());
            }
            node.addContent((Content)nodeFilters);
        }
        if (this.getColumnToRowProperties() != null && this.getColumnToRowProperties().size() > 0) {
            Element nodeColumnToRowProperties = new Element("ColumnToRowProperties");
            for (ColumnToRowProperty columnToRowProperty : this.getColumnToRowProperties()) {
                nodeColumnToRowProperties.addContent((Content)columnToRowProperty.toXml());
            }
            node.addContent((Content)nodeColumnToRowProperties);
        }
        for (Entity entity : this.children) {
            node.addContent((Content)entity.toXml());
        }
        return node;
    }

    @Override
    public boolean isInvalid() {
        return null == this.children || this.children.isEmpty() || !this.isPropertyExist() || this.existNullAttributeValue(new String[]{this.getName(), this.getAlias()});
    }

    @Override
    protected void subToXml(Element node) {
    }

    @Override
    protected void subFromXml(Element node, Set<String> unknownSourceNames) throws ModelParseException {
        List nodeChildren = node.getChildren("Entity");
        for (Element nodeChild : nodeChildren) {
            Entity child = new Entity();
            child.fromXml(nodeChild, unknownSourceNames);
            if (unknownSourceNames.contains(child.getSource())) continue;
            this.children.add(child);
        }
    }

    @Override
    public EntityType getEntityType() {
        return this.getUnionType() == UnionEntityType.BIZ ? EntityType.BIZ_UNION : EntityType.COMMON_UNION;
    }
}

