/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.model.designtime.formula;

import com.kingdee.bos.qing.common.grammar.AbstractExecuteContext;
import com.kingdee.bos.qing.common.grammar.IExecuteContext;
import com.kingdee.bos.qing.common.grammar.exception.ExecuteException;
import com.kingdee.bos.qing.common.grammar.expr.IExpr;
import com.kingdee.bos.qing.common.grammar.expr.RefExpr;
import com.kingdee.bos.qing.data.model.runtime.RuntimeProperty;
import com.kingdee.bos.qing.data.util.AbstractConverter;
import com.kingdee.bos.qing.data.util.OutputDataTypeUtils;
import com.kingdee.bos.qing.datasource.meta.DataType;
import java.util.Map;

public class FormulaExecuteContext
extends AbstractExecuteContext {
    private Map<String, RuntimeProperty> _calculatePropertiesMap;
    private Map<String, RuntimeProperty> _priPropertiesMap;
    private Map<String, RuntimeProperty> _allPropertiesMap;
    private Map<String, Object> _rowData;

    public void setCalculatePropertiesMap(Map<String, RuntimeProperty> calculatePropertiesMap) {
        this._calculatePropertiesMap = calculatePropertiesMap;
    }

    public void setPriPropertiesMap(Map<String, RuntimeProperty> priPropertiesMap) {
        this._priPropertiesMap = priPropertiesMap;
    }

    public Map<String, RuntimeProperty> getAllPropertiesMap() {
        return this._allPropertiesMap;
    }

    public void setAllPropertiesMap(Map<String, RuntimeProperty> allPropertiesMap) {
        this._allPropertiesMap = allPropertiesMap;
    }

    public void bindData(Map<String, Object> rowData) {
        this._rowData = rowData;
    }

    public Object getValue(IExpr expr) throws ExecuteException {
        if (expr instanceof RefExpr) {
            String fieldName = ((RefExpr)expr).getName();
            RuntimeProperty property = this.getRuntimeProperty(fieldName);
            if (property == null) {
                throw new ExecuteException(11, expr);
            }
            Object value = this._rowData.get(fieldName);
            if (value == null && property.isCalculation()) {
                if (property.isValidCalculation()) {
                    IExpr refExpr = property.getExpr();
                    value = refExpr.execute((IExecuteContext)this);
                    DataType inputdataType = property.getInputDataType();
                    DataType outputDataType = property.getOutputDataType();
                    value = AbstractConverter.convert((DataType)inputdataType, (DataType)outputDataType, (Object)value);
                }
                this._rowData.put(property.getName(), value);
            }
            return OutputDataTypeUtils.handle(property.getOutputDataType(), value);
        }
        throw new RuntimeException("Unsupported");
    }

    private RuntimeProperty getRuntimeProperty(String fieldName) {
        RuntimeProperty property = this._calculatePropertiesMap.get(fieldName);
        if (property == null) {
            property = this._priPropertiesMap.get(fieldName);
        }
        if (null == property) {
            property = this._allPropertiesMap.get(fieldName);
        }
        return property;
    }
}

