/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.model.runtime;

import com.kingdee.bos.qing.data.model.designtime.FilterItem;
import com.kingdee.bos.qing.data.model.runtime.CompareFilter;
import com.kingdee.bos.qing.data.model.runtime.IRuntimeFilter;
import com.kingdee.bos.qing.data.model.runtime.LogicalFilter;
import java.util.List;
import java.util.Stack;

public class RuntimeFilterUtil {
    public static void createPushNode(Stack<ParsingNode> stack, ParsingNode right, Class<? extends LogicalFilter> logicalFilterClass) {
        if (stack.isEmpty() || stack.peek() == ParsingNode.LeftBracket) {
            stack.push(right);
        } else if (stack.peek().isLogical()) {
            ParsingNode op = stack.pop();
            ParsingNode left = stack.pop();
            ParsingNode node = RuntimeFilterUtil.createLogicalFilterNode(left, op, right, logicalFilterClass);
            stack.push(node);
        } else {
            throw new RuntimeException("Impossible");
        }
    }

    public static IRuntimeFilter parseFilter(List<FilterItem> items, Class<? extends CompareFilter> compareFilterClass, Class<? extends LogicalFilter> logicalFilterClass, Prediction prediction) {
        if (items == null || items.isEmpty()) {
            return null;
        }
        Stack<ParsingNode> stack = new Stack<ParsingNode>();
        for (int k = 0; k < items.size(); ++k) {
            FilterItem item = items.get(k);
            CompareFilter compareFilter = RuntimeFilterUtil.createCompareFilter(compareFilterClass);
            compareFilter.init(item);
            if (k > 0) {
                FilterItem previousItem = items.get(k - 1);
                stack.push(previousItem.getLogicOp() == FilterItem.LogicOp.OR ? ParsingNode.Or : ParsingNode.And);
            }
            int c = item.getLeftBracketCount();
            for (int i = 0; i < c; ++i) {
                stack.push(ParsingNode.LeftBracket);
            }
            ParsingNode right = new ParsingNode(compareFilter, item.predict());
            RuntimeFilterUtil.createPushNode(stack, right, logicalFilterClass);
            int c2 = item.getRightBracketCount();
            for (int i = 0; i < c2; ++i) {
                ParsingNode last2nd;
                ParsingNode last = stack.pop();
                ParsingNode parsingNode = last2nd = stack.isEmpty() ? null : stack.pop();
                if (last2nd == null || last2nd == ParsingNode.LeftBracket) {
                    RuntimeFilterUtil.createPushNode(stack, last, logicalFilterClass);
                    continue;
                }
                if (last2nd.isLogical()) {
                    ParsingNode last3rd = stack.pop();
                    ParsingNode node = RuntimeFilterUtil.createLogicalFilterNode(last3rd, last2nd, last, logicalFilterClass);
                    stack.push(node);
                    continue;
                }
                throw new RuntimeException("Impossible");
            }
        }
        if (stack.size() > 1) {
            Stack<ParsingNode> stack2 = new Stack<ParsingNode>();
            while (!stack.isEmpty()) {
                ParsingNode node = (ParsingNode)stack.pop();
                if (node == ParsingNode.LeftBracket) continue;
                stack2.push(node);
            }
            while (stack2.size() > 1) {
                ParsingNode rightNode;
                ParsingNode leftNode = (ParsingNode)stack2.pop();
                ParsingNode logicNode = stack2.isEmpty() ? null : (ParsingNode)stack2.pop();
                ParsingNode parsingNode = rightNode = stack2.isEmpty() ? null : (ParsingNode)stack2.pop();
                if (rightNode != null) {
                    ParsingNode node = RuntimeFilterUtil.createLogicalFilterNode(leftNode, logicNode, rightNode, logicalFilterClass);
                    stack2.push(node);
                    continue;
                }
                stack.push(leftNode);
            }
            stack.push((ParsingNode)stack2.pop());
        }
        ParsingNode lastOnlyOne = (ParsingNode)stack.pop();
        if (prediction != null) {
            prediction.setValue(lastOnlyOne.predict());
        }
        IRuntimeFilter result = lastOnlyOne.getRuntimeFilter();
        return result;
    }

    private static ParsingNode createLogicalFilterNode(ParsingNode leftNode, ParsingNode logicNode, ParsingNode rightNode, Class<? extends LogicalFilter> logicalFilterClass) {
        Boolean leftPrediction = leftNode.predict();
        Boolean rightPrediction = rightNode.predict();
        if (logicNode == ParsingNode.Or) {
            if (Boolean.TRUE.equals(leftPrediction) || Boolean.TRUE.equals(rightPrediction)) {
                return ParsingNode.AlwaysTrue;
            }
            if (Boolean.FALSE.equals(leftPrediction) && Boolean.FALSE.equals(rightPrediction)) {
                return ParsingNode.AlwaysFalse;
            }
            if (Boolean.FALSE.equals(leftPrediction)) {
                return rightNode;
            }
            if (Boolean.FALSE.equals(rightPrediction)) {
                return leftNode;
            }
        } else if (logicNode == ParsingNode.And) {
            if (Boolean.TRUE.equals(leftPrediction) && Boolean.TRUE.equals(rightPrediction)) {
                return ParsingNode.AlwaysTrue;
            }
            if (Boolean.FALSE.equals(leftPrediction) || Boolean.FALSE.equals(rightPrediction)) {
                return ParsingNode.AlwaysFalse;
            }
            if (Boolean.TRUE.equals(leftPrediction)) {
                return rightNode;
            }
            if (Boolean.TRUE.equals(rightPrediction)) {
                return leftNode;
            }
        }
        IRuntimeFilter left = leftNode.getRuntimeFilter();
        IRuntimeFilter right = rightNode.getRuntimeFilter();
        if (left == null || right == null) {
            throw new RuntimeException("Impossible");
        }
        FilterItem.LogicOp op = logicNode == ParsingNode.Or ? FilterItem.LogicOp.OR : FilterItem.LogicOp.AND;
        LogicalFilter logicalFilter = RuntimeFilterUtil.createLogicalFilter(logicalFilterClass);
        logicalFilter.init(left, op, right);
        return new ParsingNode(logicalFilter, null);
    }

    public static CompareFilter createCompareFilter(Class<? extends CompareFilter> compareFilterClass) {
        try {
            return compareFilterClass.newInstance();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static LogicalFilter createLogicalFilter(Class<? extends LogicalFilter> logicalFilterClass) {
        try {
            return logicalFilterClass.newInstance();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private static class ParsingNode {
        public static final ParsingNode LeftBracket = new ParsingNode(false, null);
        public static final ParsingNode Or = new ParsingNode(true, null);
        public static final ParsingNode And = new ParsingNode(true, null);
        public static final ParsingNode AlwaysTrue = new ParsingNode(false, Boolean.TRUE);
        public static final ParsingNode AlwaysFalse = new ParsingNode(false, Boolean.FALSE);
        private boolean _isLogical;
        private IRuntimeFilter _runtimeFilter;
        private Boolean _prediction;

        private ParsingNode(boolean isLogical, Boolean prediction) {
            this._isLogical = isLogical;
            this._runtimeFilter = null;
            this._prediction = prediction;
        }

        private ParsingNode(IRuntimeFilter runtimeFilter, Boolean prediction) {
            this._isLogical = false;
            this._runtimeFilter = runtimeFilter;
            this._prediction = prediction;
        }

        public Boolean predict() {
            return this._prediction;
        }

        public IRuntimeFilter getRuntimeFilter() {
            return this._runtimeFilter;
        }

        public boolean isLogical() {
            return this._isLogical;
        }
    }

    public static class Prediction {
        private Boolean _value;

        private void setValue(Boolean value) {
            this._value = value;
        }

        public boolean isAlwaysTrue() {
            return Boolean.TRUE.equals(this._value);
        }

        public boolean isAlwaysFalse() {
            return Boolean.FALSE.equals(this._value);
        }
    }
}

