/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.model.runtime.compare.supplier;

import com.kingdee.bos.qing.data.model.runtime.CompareFilter;
import com.kingdee.bos.qing.data.model.runtime.IComparator;
import com.kingdee.bos.qing.data.model.runtime.compare.entityfilter.EntityFilterPair;
import com.kingdee.bos.qing.data.model.runtime.compare.entityfilter.IEntityFilter;
import com.kingdee.bos.qing.data.model.runtime.compare.entityfilter.SimpleEntityFilter;
import com.kingdee.bos.qing.data.model.runtime.compare.sqlcondition.NotInSqlConditionBuilder;
import com.kingdee.bos.qing.data.model.runtime.compare.sqlcondition.SqlConditionBuilder;
import com.kingdee.bos.qing.data.model.runtime.compare.sqlcondition.UnsupportSqlCondtionBuilder;
import com.kingdee.bos.qing.data.model.runtime.compare.supplier.AbstractComparatorRuntimeApiSupplier;
import com.kingdee.bos.qing.data.util.valueconvert.IValueHandler;
import com.kingdee.bos.qing.data.util.valueconvert.PrimaryDataValueHandlerDelegate;
import com.kingdee.bos.qing.data.util.valueconvert.SetValueHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class NotInComparaApiSupplier
extends AbstractComparatorRuntimeApiSupplier {
    @Override
    public IComparator getComparator() {
        return new IComparator.NotInComparator();
    }

    @Override
    public void collectDbFilterValue(List<Object> filterParams) {
        Set runtimeValue = (Set)this.getCompareFilter().getRuntimeComparedValue();
        if (null == runtimeValue) {
            return;
        }
        filterParams.addAll(runtimeValue);
    }

    @Override
    public IValueHandler getValueHandler() {
        return new SetValueHandler(this.getCompareFilter().getPrimaryDataValueHandler());
    }

    @Override
    public SqlConditionBuilder getSqlCondition() {
        Object runtimeCompareValue = this.getCompareFilter().getRuntimeComparedValue();
        Set listValue = (Set)runtimeCompareValue;
        if (!listValue.isEmpty()) {
            return new NotInSqlConditionBuilder(listValue.size());
        }
        return new UnsupportSqlCondtionBuilder(false);
    }

    @Override
    public IEntityFilter getFilterConstructor() {
        return NotInComparaApiSupplier.getNotInFilterConstructor(this.getCompareFilter());
    }

    public static IEntityFilter getNotInFilterConstructor(CompareFilter compareFilter) {
        Collection valueCollections = (Collection)compareFilter.getRuntimeComparedValue();
        if (valueCollections.isEmpty()) {
            return new SimpleEntityFilter("1", "!=", 1);
        }
        PrimaryDataValueHandlerDelegate primaryDataValueHandler = compareFilter.getPrimaryDataValueHandler();
        List<IEntityFilter> entityFilters = NotInComparaApiSupplier.createEntityFilterList(compareFilter, valueCollections, primaryDataValueHandler);
        IEntityFilter entityFilter = NotInComparaApiSupplier.mergeFilters(entityFilters);
        SimpleEntityFilter nullFilter = new SimpleEntityFilter(compareFilter.getFilterName(), compareFilter.supportEmptyOrNotExistFilter() ? "empty or not exist" : "is null", null);
        return new EntityFilterPair(entityFilter, "or", nullFilter);
    }

    private static IEntityFilter mergeFilters(List<IEntityFilter> entityFilters) {
        if (entityFilters.size() == 1) {
            return entityFilters.get(0);
        }
        List<IEntityFilter> mergedResult = NotInComparaApiSupplier.doBinaryMerge(entityFilters);
        return NotInComparaApiSupplier.mergeFilters(mergedResult);
    }

    private static List<IEntityFilter> doBinaryMerge(List<IEntityFilter> entityFilters) {
        Iterator<IEntityFilter> iterator = entityFilters.iterator();
        ArrayList<IEntityFilter> mergedResult = new ArrayList<IEntityFilter>();
        while (iterator.hasNext()) {
            IEntityFilter filter1 = iterator.next();
            if (iterator.hasNext()) {
                IEntityFilter filter2 = iterator.next();
                EntityFilterPair pair = new EntityFilterPair(filter1, "AND", filter2);
                mergedResult.add(pair);
                continue;
            }
            mergedResult.add(filter1);
        }
        return mergedResult;
    }

    private static List<IEntityFilter> createEntityFilterList(CompareFilter compareFilter, Collection<?> valueCollections, PrimaryDataValueHandlerDelegate primaryDataValueHandler) {
        ArrayList<IEntityFilter> entityFilters = new ArrayList<IEntityFilter>();
        HashSet<Object> groupFilterValues = new HashSet<Object>(valueCollections.size());
        int count = 0;
        for (Object value : valueCollections) {
            Object entityFilterValue = primaryDataValueHandler.toCloudEntityFilterValue(value);
            groupFilterValues.add(entityFilterValue);
            if (++count % 256 == 0) {
                entityFilters.add(NotInComparaApiSupplier.createEntityFilter(compareFilter, groupFilterValues));
                groupFilterValues = new HashSet();
                continue;
            }
            if (count != valueCollections.size()) continue;
            entityFilters.add(NotInComparaApiSupplier.createEntityFilter(compareFilter, groupFilterValues));
        }
        return entityFilters;
    }

    private static IEntityFilter createEntityFilter(CompareFilter compareFilter, Set<Object> groupFilterValues) {
        if (compareFilter.needConvertFilterValueToString()) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(" ( ");
            for (Object value : groupFilterValues) {
                stringBuilder.append(String.valueOf(value)).append(',');
            }
            stringBuilder.setLength(stringBuilder.length() - 1);
            stringBuilder.append(" ) ");
            return new SimpleEntityFilter(compareFilter.getFilterName(), "not in", stringBuilder.toString());
        }
        return new SimpleEntityFilter(compareFilter.getFilterName(), "not in", groupFilterValues);
    }
}

