/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.model.runtime.compare.valueconvert;

import com.kingdee.bos.qing.common.daterange.RelativeDateRange;
import com.kingdee.bos.qing.common.daterange.RuntimeRelativeDateRange;
import com.kingdee.bos.qing.data.model.designtime.Property;
import com.kingdee.bos.qing.data.util.valueconvert.ValueHandlerAdapter;
import com.kingdee.bos.qing.datasource.meta.DataType;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Calendar;

public class KylinRelativeDateValueHandler
extends ValueHandlerAdapter {
    private DataType dataType;
    private Property filterProperty;

    public KylinRelativeDateValueHandler(DataType dataType, Property filterProperty) {
        this.dataType = dataType;
        this.filterProperty = filterProperty;
    }

    public Object toRuntimeValue(Object originalValue) {
        RelativeDateRange relativeDateRange = (RelativeDateRange)originalValue;
        switch (this.dataType) {
            case DATETIME: {
                RuntimeRelativeDateRange r = new RuntimeRelativeDateRange(relativeDateRange, true);
                r.parseRange();
                return r;
            }
            case DATE: {
                RuntimeRelativeDateRange r = new RuntimeRelativeDateRange(relativeDateRange);
                r.parseRange();
                return r;
            }
        }
        return originalValue;
    }

    public Object toDbFilterValue(Object runtimeValue) {
        String className = (String)this.filterProperty.getExtensionProps().get("COLUMN_CLASS_NAME");
        RuntimeRelativeDateRange r = (RuntimeRelativeDateRange)runtimeValue;
        if ("java.sql.Time".equals(className) || "java.sql.Timestamp".equals(className)) {
            ArrayList<Calendar> paramValues = new ArrayList<Calendar>();
            paramValues.add(r.getCalendarStart());
            paramValues.add(r.getCalendarEnd());
            return paramValues;
        }
        if ("java.util.Date".equals(className) || "java.sql.Date".equals(className)) {
            ArrayList<Date> paramValues = new ArrayList<Date>();
            paramValues.add(new Date(r.getDateStart()));
            paramValues.add(new Date(r.getDateEnd()));
            return paramValues;
        }
        return runtimeValue;
    }
}

