/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.model.runtime.mdd;

import com.kingdee.bos.qing.data.model.designtime.AbstractDMViewItem;
import com.kingdee.bos.qing.data.model.designtime.DMGroupItemView;
import com.kingdee.bos.qing.data.model.designtime.Entity;
import com.kingdee.bos.qing.data.model.designtime.EntitySubView;
import com.kingdee.bos.qing.data.model.designtime.Property;
import com.kingdee.bos.qing.data.model.runtime.mdd.Dimension;
import com.kingdee.bos.qing.data.model.runtime.mdd.Measure;
import com.kingdee.bos.qing.util.NameUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class Cube {
    private final String name;
    private final String displayName;
    private List<Dimension> dimensions = new ArrayList<Dimension>();
    private List<Measure> measures = new ArrayList<Measure>();

    public Cube(String name, String displayName) {
        this.name = name;
        this.displayName = displayName;
    }

    public String getName() {
        return this.name;
    }

    public final String getDisplayName() {
        return this.displayName;
    }

    public final List<Dimension> getDimensions() {
        return Collections.unmodifiableList(this.dimensions);
    }

    public final void addDimension(Dimension dimension) {
        this.dimensions.add(dimension);
    }

    public final void addAllDimension(List<Dimension> dimensions) {
        this.dimensions.addAll(dimensions);
    }

    public final List<Measure> getMeasures() {
        return Collections.unmodifiableList(this.measures);
    }

    public final void addMeasure(Measure measure) {
        this.measures.add(measure);
    }

    public final void addAllMeasure(List<Measure> measures) {
        this.measures.addAll(measures);
    }

    public String getDimensionNameByHierarchyName(String hierarchyName) {
        for (Dimension dimension : this.dimensions) {
            if (!dimension.hasHierarchy(hierarchyName)) continue;
            return dimension.getName();
        }
        return null;
    }

    public Entity toDM() {
        Entity entity = new Entity();
        entity.setDirectModel(true);
        entity.setName(NameUtil.getPureName((String)this.getName(), new HashMap()));
        entity.setAssociateName(this.getName());
        entity.setAlias(this.getDisplayName());
        List<Property> properties = entity.getProperties();
        if (!this.dimensions.isEmpty()) {
            for (Dimension dimension : this.dimensions) {
                dimension.toDM(entity);
            }
        }
        if (!this.measures.isEmpty()) {
            EntitySubView entitySubView = null;
            if (this.measures.size() > 1) {
                entitySubView = new EntitySubView();
                entitySubView.setName("measures");
                entitySubView.setAlias("Measures");
                entitySubView.setViewItems(new ArrayList<AbstractDMViewItem>());
                if (entity.getSubViews() == null) {
                    entity.setSubViews(new ArrayList<EntitySubView>());
                }
                entity.getSubViews().add(entitySubView);
            }
            for (Measure measure : this.measures) {
                Property property = measure.toDM();
                properties.add(property);
                if (entitySubView != null) {
                    entitySubView.getViewItems().add(new DMGroupItemView(property.getName()));
                    continue;
                }
                if (entity.getViewItems() == null) {
                    entity.setViewItems(new ArrayList<AbstractDMViewItem>());
                }
                entity.getViewItems().add(new DMGroupItemView(property.getName()));
            }
        }
        return entity;
    }
}

