/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.model.runtime.mdd;

import com.kingdee.bos.qing.data.model.designtime.DesigningDataType;
import com.kingdee.bos.qing.data.model.designtime.Property;
import com.kingdee.bos.qing.data.model.runtime.mdd.Datatype;
import com.kingdee.bos.qing.data.model.runtime.mdd.Member;
import com.kingdee.bos.qing.util.NameUtil;
import java.util.HashMap;

public class Measure
extends Member {
    private final String name;
    private final String displayName;
    private final Datatype datatype;
    private final Aggregator aggregator;
    private final boolean visible;

    public Measure(String name, String displayName, String formatString, String parentUniqueName, Datatype datatype, Aggregator aggregator, boolean visible, int ordinal) {
        super(name, displayName, parentUniqueName, aggregator == Aggregator.CALCULATED ? Member.Type.FORMULA : Member.Type.MEASURE, ordinal);
        this.name = name;
        this.displayName = displayName;
        this.datatype = datatype;
        this.aggregator = aggregator;
        this.visible = visible;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Datatype getDatatype() {
        return this.datatype;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public Aggregator getAggregator() {
        return this.aggregator;
    }

    public Property toDM() {
        Property property = new Property();
        property.setName(NameUtil.getPureName((String)this.getName(), new HashMap()));
        property.setAssociateName(this.getName());
        property.setAlias(this.getDisplayName());
        DesigningDataType dataType = this.getDatatype().getDesigningDataType();
        property.setDataType(dataType);
        property.setAppointedDataType(dataType);
        return property;
    }

    public static enum Aggregator {
        SUM(1),
        COUNT(2),
        MIN(3),
        MAX(4),
        AVG(5),
        VAR(6),
        STD(7),
        CALCULATED(127),
        UNKNOWN(0);

        private final int xmlaOrdinal;

        private Aggregator(int xmlaOrdinal) {
            this.xmlaOrdinal = xmlaOrdinal;
        }

        public String xmlaName() {
            return "MDMEASURE_AGGR_" + this.name();
        }

        public String getDescription() {
            return "";
        }

        public int xmlaOrdinal() {
            return this.xmlaOrdinal;
        }
    }
}

