/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.model.runtime.process;

import com.kingdee.bos.qing.data.model.designtime.ColumnToRowProperty;
import com.kingdee.bos.qing.data.model.designtime.Entity;
import com.kingdee.bos.qing.data.model.designtime.FilterItem;
import com.kingdee.bos.qing.data.model.designtime.Property;
import com.kingdee.bos.qing.data.model.designtime.UnionEntity;
import com.kingdee.bos.qing.data.model.runtime.process.BoxFixScene;
import com.kingdee.bos.qing.data.util.PropertyNameKeySelector;
import com.kingdee.bos.qing.data.util.PropertyRelatedBaseKeySelector;
import com.kingdee.bos.qing.util.MapUtils;
import com.kingdee.bos.qing.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FixUnionEntityChildRuntimeProcess {
    private BoxFixScene fixScene;

    public FixUnionEntityChildRuntimeProcess(BoxFixScene fixScene) {
        this.fixScene = fixScene;
    }

    private void processNotBizUnion(UnionEntity unionEntity) {
        List<Property> unionEntityProperties = unionEntity.getProperties();
        List<Entity> unionEntityChildren = unionEntity.getChildren();
        Map<String, Property> unionEntityColToRowPropertyMap = this.collectUnionEntityColumnToRowProperty(unionEntity);
        Map<String, Property> unionEntityColToRowUsedPropertyMap = this.collectUnionEntityColumnToRowUsedProperties(unionEntity);
        for (Entity unionEntityChild : unionEntityChildren) {
            ArrayList<Property> newUnionEntityChildProperties = new ArrayList<Property>();
            HashMap<String, Property> unionEntityChildPropertyMap = new HashMap<String, Property>();
            Map unionEntityChildRelatedBasePropertyMap = MapUtils.collectionToMap(unionEntityChild.getProperties(), (MapUtils.IMapKeySelector)new PropertyRelatedBaseKeySelector());
            ArrayList<Property> childEntityColToRowUsedPropertyList = new ArrayList<Property>(16);
            ArrayList<Property> childEntityColToRowPropertyList = new ArrayList<Property>(16);
            this.collectChildEntityColumnToRowUsedProperty(unionEntityChild, childEntityColToRowUsedPropertyList, childEntityColToRowPropertyList);
            Map childEntityColToRowPropertyMap = MapUtils.collectionToMap(childEntityColToRowPropertyList, (MapUtils.IMapKeySelector)new PropertyNameKeySelector());
            boolean isAlreadyAddColumnToRowProperty = false;
            for (Property unionEntityProperty : unionEntityProperties) {
                Object relatedBaseProp;
                if (unionEntityProperty.isCalculation()) {
                    Property newProperty = unionEntityProperty.createCopy();
                    unionEntityChildPropertyMap.put(newProperty.getName(), newProperty);
                    newUnionEntityChildProperties.add(newProperty);
                    continue;
                }
                String unionEntityPropertyName = unionEntityProperty.getName();
                Property unionEntityChildProperty = (Property)unionEntityChildRelatedBasePropertyMap.get(unionEntityPropertyName);
                if (unionEntityChildProperty != null) {
                    if (unionEntityColToRowUsedPropertyMap.get(unionEntityPropertyName) != null) {
                        this.setUnionEntityChildProperty(true, unionEntityProperty, unionEntityChildProperty, unionEntityPropertyName, newUnionEntityChildProperties, unionEntityChildPropertyMap);
                    } else {
                        this.setUnionEntityChildProperty(false, unionEntityProperty, unionEntityChildProperty, unionEntityPropertyName, newUnionEntityChildProperties, unionEntityChildPropertyMap);
                    }
                    if (!StringUtils.isNotBlank((CharSequence)(relatedBaseProp = unionEntityChildProperty.getRelatedBaseProperty())) || isAlreadyAddColumnToRowProperty) continue;
                    for (Property childColumnToRowProperty : childEntityColToRowUsedPropertyList) {
                        childColumnToRowProperty.setHide(true);
                        this.setUnionEntityChildProperty(true, unionEntityProperty, childColumnToRowProperty, childColumnToRowProperty.getName(), newUnionEntityChildProperties, unionEntityChildPropertyMap);
                    }
                    isAlreadyAddColumnToRowProperty = true;
                    continue;
                }
                unionEntityChildProperty = (Property)childEntityColToRowPropertyMap.get(unionEntityPropertyName);
                if (unionEntityChildProperty != null) {
                    this.setUnionEntityChildProperty(true, unionEntityProperty, unionEntityChildProperty, unionEntityPropertyName, newUnionEntityChildProperties, unionEntityChildPropertyMap);
                    if (isAlreadyAddColumnToRowProperty) continue;
                    relatedBaseProp = childEntityColToRowUsedPropertyList.iterator();
                    while (relatedBaseProp.hasNext()) {
                        Property childColumnToRowProperty = (Property)relatedBaseProp.next();
                        this.setUnionEntityChildProperty(true, unionEntityProperty, childColumnToRowProperty, childColumnToRowProperty.getName(), newUnionEntityChildProperties, unionEntityChildPropertyMap);
                    }
                    isAlreadyAddColumnToRowProperty = true;
                    continue;
                }
                unionEntityChildProperty = unionEntityColToRowPropertyMap.get(unionEntityPropertyName);
                if (unionEntityChildProperty != null) {
                    this.setUnionEntityChildProperty(true, unionEntityProperty, unionEntityChildProperty, unionEntityPropertyName, newUnionEntityChildProperties, unionEntityChildPropertyMap);
                    continue;
                }
                Property newProperty = unionEntityProperty.createCopy();
                String newPropertyName = newProperty.getName();
                newProperty.setInvalid4Union(true);
                newProperty.setRelatedBaseProperty(newPropertyName);
                newUnionEntityChildProperties.add(newProperty);
                unionEntityChildPropertyMap.put(newPropertyName, newProperty);
            }
            unionEntityChild.setProperties(newUnionEntityChildProperties);
            unionEntityChildPropertyMap.putAll(unionEntityColToRowPropertyMap);
            this.fixUnionEntityChildFilterItems(unionEntity, unionEntityChild, unionEntityChildPropertyMap);
        }
    }

    public void process(UnionEntity unionEntity) {
        if (this.fixScene == BoxFixScene.datamodeling) {
            return;
        }
        switch (unionEntity.getEntityType()) {
            case COMMON_UNION: {
                this.processNotBizUnion(unionEntity);
                break;
            }
            case BIZ_UNION: {
                this.processBizUnion(unionEntity);
                break;
            }
        }
    }

    private void processBizUnion(UnionEntity unionEntity) {
        List<Property> unionEntityProperties = unionEntity.getProperties();
        List<Entity> unionEntityChildren = unionEntity.getChildren();
        for (Entity unionEntityChild : unionEntityChildren) {
            ArrayList<Property> newUnionEntityChildProperties = new ArrayList<Property>();
            HashMap<String, Property> unionEntityChildPropertyMap = new HashMap<String, Property>();
            Map unionEntityChildRelatedBasePropertyMap = MapUtils.collectionToMap(unionEntityChild.getProperties(), (MapUtils.IMapKeySelector)new PropertyRelatedBaseKeySelector());
            for (Property unionEntityProperty : unionEntityProperties) {
                if (unionEntityProperty.isCalculation()) {
                    Property newProperty = unionEntityProperty.createCopy();
                    unionEntityChildPropertyMap.put(newProperty.getName(), newProperty);
                    newUnionEntityChildProperties.add(newProperty);
                    continue;
                }
                String unionEntityPropertyName = unionEntityProperty.getName();
                Property unionEntityChildProperty = (Property)unionEntityChildRelatedBasePropertyMap.get(unionEntityPropertyName);
                if (unionEntityChildProperty != null) {
                    unionEntityChildProperty.setName(unionEntityPropertyName);
                    unionEntityChildProperty.setAppointedDataType(unionEntityProperty.getAppointedDataType());
                    newUnionEntityChildProperties.add(unionEntityChildProperty);
                    unionEntityChildPropertyMap.put(unionEntityPropertyName, unionEntityChildProperty);
                    continue;
                }
                Property newProperty = unionEntityProperty.createCopy();
                String newPropertyName = newProperty.getName();
                newProperty.setInvalid4Union(true);
                newProperty.setRelatedBaseProperty(newPropertyName);
                newUnionEntityChildProperties.add(newProperty);
                unionEntityChildPropertyMap.put(newPropertyName, newProperty);
            }
            unionEntityChild.setProperties(newUnionEntityChildProperties);
            this.fixUnionEntityChildFilterItems(unionEntity, unionEntityChild, unionEntityChildPropertyMap);
        }
    }

    private void setUnionEntityChildProperty(boolean isNeedUpdateProOutputStatus, Property unionEntityProperty, Property unionEntityChildProperty, String unionEntityPropertyName, List<Property> newUnionEntityChildProperties, Map<String, Property> unionEntityChildPropertyMap) {
        if (isNeedUpdateProOutputStatus && unionEntityProperty.isHide()) {
            unionEntityChildProperty.addExtensionData("isInputProp", true);
            unionEntityChildProperty.addExtensionData("isOutPutProp", false);
        }
        unionEntityChildProperty.setName(unionEntityPropertyName);
        unionEntityChildProperty.setAppointedDataType(unionEntityProperty.getAppointedDataType());
        newUnionEntityChildProperties.add(unionEntityChildProperty);
        unionEntityChildPropertyMap.put(unionEntityPropertyName, unionEntityChildProperty);
    }

    private Map<String, Property> collectUnionEntityColumnToRowProperty(UnionEntity unionEntity) {
        HashMap<String, Property> unionEntityColToRowPropertyMap = new HashMap<String, Property>();
        List<ColumnToRowProperty> columnToRowProperties = unionEntity.getColumnToRowProperties();
        if (columnToRowProperties != null && columnToRowProperties.size() > 0) {
            int len = columnToRowProperties.size();
            for (int i = 0; i < len; ++i) {
                ColumnToRowProperty columnToRowProperty = columnToRowProperties.get(i);
                Property fieldNameProperty = columnToRowProperty.getFieldNameProperty();
                unionEntityColToRowPropertyMap.put(fieldNameProperty.getName(), fieldNameProperty);
                List<Property> fieldValueProperties = columnToRowProperty.getFieldValueProperties();
                int size = fieldValueProperties.size();
                for (int j = 0; j < size; ++j) {
                    Property fieldValueProperty = fieldValueProperties.get(j);
                    unionEntityColToRowPropertyMap.put(fieldValueProperty.getName(), fieldValueProperty);
                }
            }
        }
        return unionEntityColToRowPropertyMap;
    }

    private Map<String, Property> collectUnionEntityColumnToRowUsedProperties(UnionEntity unionEntity) {
        HashMap<String, Property> unionEntityColToRowUsedPropertyMap = new HashMap<String, Property>();
        List<ColumnToRowProperty> columnToRowProperties = unionEntity.getColumnToRowProperties();
        if (columnToRowProperties != null && columnToRowProperties.size() > 0) {
            int len = columnToRowProperties.size();
            for (int i = 0; i < len; ++i) {
                List<Property> unionProperties = unionEntity.getProperties();
                Map unionEntityPropertyMap = MapUtils.collectionToMap(unionProperties, (MapUtils.IMapKeySelector)new PropertyNameKeySelector());
                ColumnToRowProperty columnToRowProperty = columnToRowProperties.get(i);
                List<String> columnToRowUsedPropertyNames = columnToRowProperty.getUsedColumnToRowPropertyNames();
                if (columnToRowUsedPropertyNames == null || columnToRowUsedPropertyNames.size() <= 0) continue;
                for (String colToRowUsedPropertyName : columnToRowUsedPropertyNames) {
                    unionEntityColToRowUsedPropertyMap.put(colToRowUsedPropertyName, (Property)unionEntityPropertyMap.get(colToRowUsedPropertyName));
                }
            }
        }
        return unionEntityColToRowUsedPropertyMap;
    }

    private void collectChildEntityColumnToRowUsedProperty(Entity childEntity, List<Property> childEntityColToRowUsedPropertyList, List<Property> childEntityColToRowPropertyList) {
        Map childEntityAllPropertyMap = MapUtils.collectionToMap(childEntity.getProperties(), (MapUtils.IMapKeySelector)new PropertyNameKeySelector());
        List<ColumnToRowProperty> columnToRowProperties = childEntity.getColumnToRowProperties();
        if (columnToRowProperties != null && columnToRowProperties.size() > 0) {
            int len = columnToRowProperties.size();
            for (int i = 0; i < len; ++i) {
                ColumnToRowProperty columnToRowProperty = columnToRowProperties.get(i);
                childEntityColToRowPropertyList.add(columnToRowProperty.getFieldNameProperty());
                childEntityColToRowPropertyList.addAll(columnToRowProperty.getFieldValueProperties());
                List<String> usedColumnToRowPropertyNames = columnToRowProperty.getUsedColumnToRowPropertyNames();
                int size = usedColumnToRowPropertyNames.size();
                for (int j = 0; j < size; ++j) {
                    String propertyName = usedColumnToRowPropertyNames.get(j);
                    Property property = (Property)childEntityAllPropertyMap.get(propertyName);
                    if (property == null) continue;
                    property.setHide(true);
                    property.addExtensionData("isInputProp", true);
                    property.addExtensionData("isOutPutProp", false);
                    childEntityColToRowUsedPropertyList.add(property);
                }
            }
        }
    }

    public void fixUnionEntityChildFilterItems(UnionEntity unionEntity, Entity unionEntityChild, Map<String, Property> unionEntityChildPropertyMap) {
        List<FilterItem> unionEntityFilterItems = unionEntity.getFilters();
        if (unionEntityFilterItems == null || unionEntityFilterItems.isEmpty()) {
            return;
        }
        ArrayList<FilterItem> unionEntityChildFilterItems = new ArrayList<FilterItem>();
        for (FilterItem unionEntityFilterItem : unionEntityFilterItems) {
            FilterItem unionEntityChildFilterItem = unionEntityFilterItem.createCopy();
            String unionEntityFilterItemPropertyName = unionEntityFilterItem.getProprety();
            Property unionEntityChileFilterItemProperty = unionEntityChildPropertyMap.get(unionEntityFilterItemPropertyName);
            if (unionEntityChileFilterItemProperty == null || unionEntityChileFilterItemProperty.isInvalid4Union()) {
                Boolean prediction = Boolean.FALSE;
                switch (unionEntityFilterItem.getCompareOp()) {
                    case NULL: 
                    case NOT_EQUAL: 
                    case NOT_INCLUDE: 
                    case NOT_IN: {
                        prediction = Boolean.TRUE;
                        break;
                    }
                }
                unionEntityChildFilterItem.setPrediction(prediction);
                unionEntityChildFilterItems.add(unionEntityChildFilterItem);
            } else {
                unionEntityChildFilterItems.add(unionEntityChildFilterItem);
            }
            unionEntityChild.setFilters(unionEntityChildFilterItems);
        }
    }
}

