/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.service;

import com.kingdee.bos.qing.behavior.BehaviorAssociate;
import com.kingdee.bos.qing.behavior.impl.BehaviorService;
import com.kingdee.bos.qing.common.context.IQingContextable;
import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.exception.AbstractQingException;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.common.framework.server.annotation.longtime.LongTimeServiceMethodAnnotation;
import com.kingdee.bos.qing.common.framework.server.task.ServerRequestInvokeContext;
import com.kingdee.bos.qing.common.i18n.Messages;
import com.kingdee.bos.qing.common.session.IGlobalQingSession;
import com.kingdee.bos.qing.common.session.QingSessionUtil;
import com.kingdee.bos.qing.common.strategy.CustomStrategyRegistrar;
import com.kingdee.bos.qing.common.systemvar.SystemVarType;
import com.kingdee.bos.qing.data.domain.formula.DesigntimeFormulaDomain;
import com.kingdee.bos.qing.data.domain.source.AbstractDataSourceDomain;
import com.kingdee.bos.qing.data.domain.source.IGetCatlogable;
import com.kingdee.bos.qing.data.domain.source.SourceDomainFactory;
import com.kingdee.bos.qing.data.domain.source.api.AbstractOpenAPISourceDomain;
import com.kingdee.bos.qing.data.domain.source.db.AbstractDBSourceDomain;
import com.kingdee.bos.qing.data.domain.source.db.IDBConnectionSupporter;
import com.kingdee.bos.qing.data.domain.source.db.IStoredProcedure;
import com.kingdee.bos.qing.data.domain.source.db.util.SQLHelper;
import com.kingdee.bos.qing.data.domain.source.file.domain.AbstractFileSourceDomain;
import com.kingdee.bos.qing.data.exception.AbstractDBSourceException;
import com.kingdee.bos.qing.data.exception.AbstractFileSourceException;
import com.kingdee.bos.qing.data.exception.AbstractSourceException;
import com.kingdee.bos.qing.data.exception.CronExpressionParseException;
import com.kingdee.bos.qing.data.exception.SubjectDataModelingException;
import com.kingdee.bos.qing.data.exception.UnSupportDataSourceException;
import com.kingdee.bos.qing.data.exception.api.OpenAPIException;
import com.kingdee.bos.qing.data.exception.db.AbstractDBConnectException;
import com.kingdee.bos.qing.data.exception.file.qs.QSFileNotFoundException;
import com.kingdee.bos.qing.data.model.designtime.AbstractEntity;
import com.kingdee.bos.qing.data.model.designtime.AbstractSource;
import com.kingdee.bos.qing.data.model.designtime.Entity;
import com.kingdee.bos.qing.data.model.designtime.ModelDecoder;
import com.kingdee.bos.qing.data.model.designtime.UnionEntity;
import com.kingdee.bos.qing.data.model.designtime.source.DBSource;
import com.kingdee.bos.qing.data.model.runtime.process.FixEntityColumnToRowProcess;
import com.kingdee.bos.qing.data.model.vo.AbstractNode;
import com.kingdee.bos.qing.data.model.vo.DesigntimeDataObject;
import com.kingdee.bos.qing.data.model.vo.Entites;
import com.kingdee.bos.qing.data.model.vo.PreviewDataModel;
import com.kingdee.bos.qing.data.model.vo.Sources;
import com.kingdee.bos.qing.data.service.EntityDataServiceFactory;
import com.kingdee.bos.qing.data.service.IDesigntimeService;
import com.kingdee.bos.qing.data.service.IEntityDataService;
import com.kingdee.bos.qing.filesystem.manager.CopyWriteCall;
import com.kingdee.bos.qing.filesystem.manager.FileFactory;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFile;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFileVisitor;
import com.kingdee.bos.qing.filesystem.manager.api.IWriteCall;
import com.kingdee.bos.qing.filesystem.manager.model.AbstractQingFileType;
import com.kingdee.bos.qing.filesystem.manager.model.QingTempFileType;
import com.kingdee.bos.qing.response.AbstractResponseWrap;
import com.kingdee.bos.qing.response.IResponseStrategy;
import com.kingdee.bos.qing.response.IResponseWrap;
import com.kingdee.bos.qing.response.ResponseErrorWrap;
import com.kingdee.bos.qing.response.ResponseSuccessWrap;
import com.kingdee.bos.qing.response.ResponseUtil;
import com.kingdee.bos.qing.schedule.AbstractScheduleEngine;
import com.kingdee.bos.qing.util.JsonUtil;
import com.kingdee.bos.qing.util.LogUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import oadd.org.apache.commons.lang.StringUtils;
import org.apache.commons.codec.digest.DigestUtils;

public abstract class AbstractDesigntimeServiceImpl
extends BehaviorService
implements IDesigntimeService,
IQingContextable {
    protected QingContext qingContext;

    public void setQingContext(QingContext qingContext) {
        this.qingContext = qingContext;
    }

    @Override
    public byte[] getCatlog(Map<String, String> params) {
        try {
            String jsonSource = params.get("source");
            AbstractSource source = ModelDecoder.decode(jsonSource, AbstractSource.class);
            AbstractDataSourceDomain sourceDomain = SourceDomainFactory.getSourceDomain(source);
            List<Object> result = Collections.emptyList();
            if (sourceDomain instanceof IGetCatlogable) {
                IGetCatlogable catlogableSourceDomain = (IGetCatlogable)((Object)sourceDomain);
                result = catlogableSourceDomain.getCatlog(source);
            }
            ResponseSuccessWrap wrap = new ResponseSuccessWrap(result);
            this.interestInBehavior((AbstractResponseWrap)wrap, 0L, source.getType().toString());
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (AbstractSourceException e) {
            return this.exceptionHandler((AbstractQingException)e);
        }
    }

    @Override
    @BehaviorAssociate(behavior=true)
    public byte[] checkConnection(Map<String, String> params) {
        try {
            String jsonSource = params.get("source");
            AbstractSource source = ModelDecoder.decode(jsonSource, AbstractSource.class);
            AbstractDataSourceDomain sourceDomain = SourceDomainFactory.getSourceDomain(source);
            boolean result = true;
            if (sourceDomain instanceof IDBConnectionSupporter) {
                IDBConnectionSupporter connectionSupport = (IDBConnectionSupporter)sourceDomain;
                result = connectionSupport.checkConnection(this.qingContext, source);
            }
            ResponseSuccessWrap wrap = new ResponseSuccessWrap((Object)result);
            this.interestInBehavior((AbstractResponseWrap)wrap, 0L, source.getType().toString());
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (UnSupportDataSourceException e) {
            return this.exceptionHandler((AbstractQingException)e);
        }
        catch (AbstractDBConnectException e) {
            return this.exceptionHandler((AbstractQingException)e);
        }
    }

    @Override
    @BehaviorAssociate(behavior=true)
    public byte[] getDatabaseNameList(Map<String, String> params) {
        try {
            String jsonSource = params.get("source");
            AbstractSource source = ModelDecoder.decode(jsonSource, AbstractSource.class);
            AbstractDBSourceDomain dbSourceDomain = (AbstractDBSourceDomain)SourceDomainFactory.getSourceDomain(source);
            List<String> result = dbSourceDomain.getDatabaseNameList(source);
            ResponseSuccessWrap wrap = new ResponseSuccessWrap(result);
            this.interestInBehavior((AbstractResponseWrap)wrap, 0L, ((DBSource)source).getDbType().toString());
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (UnSupportDataSourceException e) {
            return this.exceptionHandler((AbstractQingException)e);
        }
        catch (AbstractDBSourceException e) {
            return this.exceptionHandler((AbstractQingException)e);
        }
    }

    @LongTimeServiceMethodAnnotation
    public byte[] scanAllEntity(Map<String, String> params) {
        String jsonSource = params.get("source");
        AbstractSource source = ModelDecoder.decode(jsonSource, AbstractSource.class);
        try {
            AbstractDataSourceDomain sourceDomain = SourceDomainFactory.getSourceDomain(source);
            String exportUuid = sourceDomain.scanAllEntity(this.qingContext, source);
            ResponseSuccessWrap wrap = new ResponseSuccessWrap((Object)exportUuid);
            this.interestInBehavior((AbstractResponseWrap)wrap, 0L, source.getType().toString());
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (SubjectDataModelingException e) {
            return this.exceptionHandler((AbstractQingException)e);
        }
        catch (AbstractQingIntegratedException e) {
            return this.exceptionHandler((AbstractQingException)e);
        }
    }

    @Override
    @BehaviorAssociate(behavior=true)
    public byte[] getUsableEntities(Map<String, String> params) {
        try {
            String jsonSource = params.get("source");
            AbstractSource source = ModelDecoder.decode(jsonSource, AbstractSource.class);
            AbstractDataSourceDomain sourceDomain = SourceDomainFactory.getSourceDomain(source);
            AbstractNode root = sourceDomain.getUsableEntities(this.qingContext, source);
            ResponseSuccessWrap wrap = new ResponseSuccessWrap((Object)root);
            this.interestInBehavior((AbstractResponseWrap)wrap, 0L, source.getType().toString());
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (AbstractSourceException e) {
            return this.exceptionHandler((AbstractQingException)e);
        }
        catch (AbstractQingIntegratedException e) {
            return this.exceptionHandler((AbstractQingException)e);
        }
    }

    private List<DesigntimeDataObject> getBizUnionDesigntimeDataObjs(List<Entity> headEntities, Sources sources) {
        ArrayList<DesigntimeDataObject> designtimeDataObjects = new ArrayList<DesigntimeDataObject>();
        HashSet<String> associateNameSet = new HashSet<String>(headEntities.size());
        for (Entity entity : headEntities) {
            String associateName = entity.getAssociateName();
            if (associateNameSet.contains(associateName)) continue;
            associateNameSet.add(associateName);
            AbstractSource source = sources.getSource(entity.getSource());
            try {
                AbstractDataSourceDomain sourceDomain = SourceDomainFactory.getSourceDomain(source);
                DesigntimeDataObject entityDataObject = sourceDomain.getDesigntimeDataObject(this.qingContext, source, entity.getAssociateName());
                designtimeDataObjects.add(entityDataObject);
            }
            catch (UnSupportDataSourceException e) {
                LogUtil.error((String)("source not supported,source type:" + source.getType()), (Throwable)e);
            }
            catch (Exception e) {
                LogUtil.error((String)("get design data object failed, entity alias:" + entity.getAlias()), (Throwable)e);
            }
        }
        return designtimeDataObjects;
    }

    @Override
    public byte[] getUnionDesigntimeDataObject(Map<String, String> params) {
        String arrjsonEntity = params.get("entities");
        String jsonSources = params.get("sources");
        boolean isBizUnion = Boolean.parseBoolean(params.get("isBizUnion"));
        Entites entities = ModelDecoder.decode(arrjsonEntity, Entites.class);
        Sources sources = ModelDecoder.decode(jsonSources, Sources.class);
        UnionEntity unionEntity = (UnionEntity)entities.getEntities().get(0);
        List<Entity> children = unionEntity.getChildren();
        if (isBizUnion) {
            List<DesigntimeDataObject> designtimeDataObjects = this.getBizUnionDesigntimeDataObjs(children, sources);
            ResponseSuccessWrap wrap = new ResponseSuccessWrap(designtimeDataObjects);
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        DesigntimeDataObject result = new DesigntimeDataObject();
        try {
            for (Entity entity : children) {
                try {
                    AbstractSource source = sources.getSource(entity.getSource());
                    if (source != null) {
                        AbstractDataSourceDomain sourceDomain = SourceDomainFactory.getSourceDomain(source);
                        DesigntimeDataObject entityDataObject = sourceDomain.getDesigntimeDataObject(this.qingContext, source, entity.getAssociateName());
                        Entity realEntity = entityDataObject.getEntityByAssosiateName(entity.getAssociateName());
                        if (null == realEntity) continue;
                        if (entity.getColumnToRowProperties() != null) {
                            realEntity.setColumnToRowProperties(entity.getColumnToRowProperties());
                            FixEntityColumnToRowProcess.processProperties(realEntity.getColumnToRowProperties(), realEntity.getProperties());
                        }
                        realEntity.setName(entity.getName());
                        realEntity.setAlias(entity.getAlias());
                        sourceDomain.checkSupportQingAnalysis(this.qingContext, realEntity);
                        sourceDomain.checkEntityPermission(this.qingContext, realEntity);
                        result.addEntity(realEntity);
                        continue;
                    }
                    LogUtil.warn((String)("not found sources: " + entity.getSource()));
                }
                catch (AbstractSourceException e) {
                    LogUtil.error((String)e.getMessage(), (Throwable)e);
                }
            }
            ResponseSuccessWrap wrap = new ResponseSuccessWrap((Object)result);
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (AbstractQingIntegratedException e) {
            return this.exceptionHandler((AbstractQingException)e);
        }
    }

    @Override
    @BehaviorAssociate(behavior=true)
    public byte[] getDesigntimeDataObject(Map<String, String> params) {
        try {
            String jsonSource = params.get("source");
            String associateName = params.get("associateName");
            AbstractSource source = ModelDecoder.decode(jsonSource, AbstractSource.class);
            AbstractDataSourceDomain sourceDomain = SourceDomainFactory.getSourceDomain(source);
            DesigntimeDataObject result = sourceDomain.getDesigntimeDataObject(this.qingContext, source, associateName);
            ResponseSuccessWrap wrap = new ResponseSuccessWrap((Object)result);
            this.interestInBehavior((AbstractResponseWrap)wrap, 0L, source.getType().toString());
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (UnSupportDataSourceException e) {
            return this.exceptionHandler((AbstractQingException)e);
        }
        catch (AbstractSourceException e) {
            return this.exceptionHandler((AbstractQingException)e);
        }
        catch (AbstractQingIntegratedException e) {
            return this.exceptionHandler((AbstractQingException)e);
        }
    }

    @Override
    public byte[] checkFormula(Map<String, String> params) {
        String jsonRequest = params.get("checking");
        DesigntimeFormulaDomain.CheckingRequest checkingRequest = (DesigntimeFormulaDomain.CheckingRequest)JsonUtil.decodeFromString((String)jsonRequest, DesigntimeFormulaDomain.CheckingRequest.class);
        DesigntimeFormulaDomain domain = new DesigntimeFormulaDomain();
        domain.setI18nContext(this.qingContext.getIi18nContext());
        DesigntimeFormulaDomain.CheckingResponse checkingResponse = domain.checkFormula(checkingRequest);
        return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap((Object)checkingResponse));
    }

    @Override
    public byte[] checkAllFormula(Map<String, String> params) {
        String jsonRequest = params.get("checking");
        DesigntimeFormulaDomain.CheckingRequest checkingRequest = (DesigntimeFormulaDomain.CheckingRequest)JsonUtil.decodeFromString((String)jsonRequest, DesigntimeFormulaDomain.CheckingRequest.class);
        DesigntimeFormulaDomain domain = new DesigntimeFormulaDomain();
        domain.setI18nContext(this.qingContext.getIi18nContext());
        DesigntimeFormulaDomain.CheckingAllResponse checkingResponse = domain.checkAllFormula(checkingRequest);
        return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap((Object)checkingResponse));
    }

    @Override
    @BehaviorAssociate(behavior=true)
    public byte[] isDataFieldUnique(Map<String, String> params) {
        ResponseSuccessWrap wrap = new ResponseSuccessWrap((Object)Boolean.TRUE);
        return ResponseUtil.output((IResponseWrap)wrap);
    }

    private Map<String, Entity> buildEntityNameMap(Entites entities) {
        HashMap<String, Entity> entityMap = new HashMap<String, Entity>();
        for (AbstractEntity entity : entities.getEntities()) {
            if (!(entity instanceof Entity)) continue;
            entityMap.put(entity.getName(), (Entity)entity);
        }
        return entityMap;
    }

    private Map<String, AbstractSource> buildSourceMap(Sources sources) {
        HashMap<String, AbstractSource> sourceMap = new HashMap<String, AbstractSource>(sources.getSources().size());
        for (AbstractSource source : sources.getSources()) {
            sourceMap.put(source.getName(), source);
        }
        return sourceMap;
    }

    @Override
    public byte[] cronExpression(Map<String, String> params) {
        String cronExpression = params.get("cron");
        try {
            List result = AbstractScheduleEngine.cronExpression((String)cronExpression);
            ResponseSuccessWrap wrap = new ResponseSuccessWrap((Object)result);
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (ParseException e) {
            CronExpressionParseException exception = new CronExpressionParseException(e);
            return ResponseUtil.output((Exception)((Object)exception));
        }
    }

    @BehaviorAssociate(behavior=true)
    public byte[] getStoredProcedures(Map<String, String> params) {
        try {
            String jsonSource = params.get("source");
            AbstractSource source = ModelDecoder.decode(jsonSource, AbstractSource.class);
            IStoredProcedure sourceDomain = (IStoredProcedure)SourceDomainFactory.getSourceDomain(source);
            AbstractNode root = sourceDomain.getStoredProcedures(this.qingContext, source);
            ResponseSuccessWrap wrap = new ResponseSuccessWrap((Object)root);
            this.interestInBehavior((AbstractResponseWrap)wrap, 0L, source.getType().toString());
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (AbstractSourceException e) {
            return this.exceptionHandler((AbstractQingException)e);
        }
    }

    @BehaviorAssociate(behavior=true)
    public byte[] getStoredProcedureParameters(Map<String, String> params) {
        try {
            String jsonSource = params.get("source");
            String storedProcedureName = params.get("storedProcedureName");
            AbstractSource source = ModelDecoder.decode(jsonSource, AbstractSource.class);
            IStoredProcedure sourceDomain = (IStoredProcedure)SourceDomainFactory.getSourceDomain(source);
            List result = sourceDomain.getStoredProcedureParameters(this.qingContext, source, storedProcedureName);
            ResponseSuccessWrap wrap = new ResponseSuccessWrap((Object)result);
            this.interestInBehavior((AbstractResponseWrap)wrap, 0L, source.getType().toString());
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (AbstractSourceException e) {
            return this.exceptionHandler((AbstractQingException)e);
        }
    }

    @Override
    @LongTimeServiceMethodAnnotation
    public byte[] guessFileEncoding(Map<String, String> params) {
        String filePath = params.get("filePath");
        try {
            String fileEncoding = AbstractFileSourceDomain.guessFileEncoding(filePath);
            ResponseSuccessWrap wrap = new ResponseSuccessWrap((Object)fileEncoding);
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (AbstractFileSourceException e) {
            return this.exceptionHandler((AbstractQingException)e);
        }
    }

    @Override
    @BehaviorAssociate(behavior=true)
    public byte[] openAPIInitialCheck(Map<String, String> params) {
        AbstractOpenAPISourceDomain sourceDomain = null;
        try {
            String jsonSource = params.get("source");
            AbstractSource source = ModelDecoder.decode(jsonSource, AbstractSource.class);
            sourceDomain = AbstractOpenAPISourceDomain.newInstance(source);
            String result = sourceDomain.openAPIInitialCheck(this.qingContext, source);
            ResponseSuccessWrap wrap = new ResponseSuccessWrap((Object)result);
            this.interestInBehavior((AbstractResponseWrap)wrap, 0L, source.getType().toString());
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (UnSupportDataSourceException e) {
            return this.exceptionHandler((AbstractQingException)e);
        }
        catch (OpenAPIException e) {
            return this.exceptionHandler((AbstractQingException)e);
        }
    }

    protected byte[] exceptionHandler(AbstractQingException e) {
        String errorCodeStr = String.valueOf(e.getErrorCode());
        if (errorCodeStr.startsWith("20612") || errorCodeStr.startsWith("20622")) {
            String errorMessage = Messages.getMLS((QingContext)this.qingContext, (String)errorCodeStr, (String)"\u670d\u52a1\u5668\u51fa\u73b0\u5f02\u5e38", (Messages.ProjectName)Messages.ProjectName.QING_DATA);
            return ResponseUtil.output((IResponseWrap)new ResponseErrorWrap(e.getErrorCode(), errorMessage, (Throwable)e));
        }
        IResponseStrategy responseStrategy = (IResponseStrategy)CustomStrategyRegistrar.getStrategy(IResponseStrategy.class);
        if (responseStrategy != null && !responseStrategy.isShowStackTrace()) {
            return ResponseUtil.output((IResponseWrap)new ResponseErrorWrap(e.getErrorCode(), "An Exception occured.", (Throwable)e));
        }
        return ResponseUtil.output((Exception)e);
    }

    @Override
    @BehaviorAssociate(behavior=true)
    public byte[] getPreviewDataSysVars(Map<String, String> params) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>(16);
        Set systemVarTypes = this.qingContext.getSupportedSystemVarTypes();
        String systemValue = null;
        for (SystemVarType systemVarType : systemVarTypes) {
            systemValue = this.qingContext.getSystemVarStringValue(systemVarType);
            systemValue = StringUtils.isNotBlank((String)systemValue) ? "'" + systemValue + "'" : Messages.getMLS((QingContext)this.qingContext, (String)"emptyData", (String)"\u6682\u65e0\u6570\u636e", (Messages.ProjectName)Messages.ProjectName.QING_DATA);
            result.put(systemVarType.name(), systemValue);
        }
        ResponseSuccessWrap wrap = new ResponseSuccessWrap(result);
        return ResponseUtil.output((IResponseWrap)wrap);
    }

    @Override
    @BehaviorAssociate(behavior=true)
    @LongTimeServiceMethodAnnotation
    public byte[] getPreviewData(Map<String, String> params) {
        String arrjsonEntity = params.get("entities");
        String jsonSources = params.get("sources");
        int jsonRows = Integer.parseInt(params.get("topRows"));
        Entites entities = ModelDecoder.decode(arrjsonEntity, Entites.class);
        Sources sources = ModelDecoder.decode(jsonSources, Sources.class);
        AbstractEntity abstractEntity = entities.getEntities().get(0);
        IEntityDataService dataExtractor = EntityDataServiceFactory.newDataService(abstractEntity);
        try {
            PreviewDataModel result;
            String cacheKey = this.getCacheKey(params, CacheType.PREVIEW);
            IGlobalQingSession session = QingSessionUtil.getGlobalQingSessionImpl();
            String previewFileName = session.hGet(cacheKey, DigestUtils.md5Hex((String)(arrjsonEntity + jsonSources)));
            String previewDataInCache = this.getPreviewDataInCache(previewFileName);
            if (StringUtils.isNotBlank((String)previewDataInCache)) {
                result = (PreviewDataModel)JsonUtil.decodeFromString((String)previewDataInCache, PreviewDataModel.class);
            } else {
                result = dataExtractor.getPreviewData(this.qingContext, jsonRows, entities, sources, this.getQingFileVisitorMap(abstractEntity, sources));
                String fileName = this.writePreviewDataToCache(JsonUtil.encodeToString((Object)result));
                List keys = session.hKeys(cacheKey);
                for (String key : keys) {
                    session.hRemove(cacheKey, key);
                }
                session.hSet(cacheKey, DigestUtils.md5Hex((String)(arrjsonEntity + jsonSources)), fileName);
            }
            session.expireAfter(cacheKey, 2, TimeUnit.HOURS);
            ResponseSuccessWrap wrap = new ResponseSuccessWrap((Object)result);
            String sourceType = "UNKOWN_SOURCE";
            if (abstractEntity instanceof Entity) {
                Entity entity = (Entity)abstractEntity;
                sourceType = sources.getSourceType(entity.getSource(), "UNKOWN_SOURCE");
            } else {
                sourceType = "MixedSource";
            }
            this.interestInBehavior((AbstractResponseWrap)wrap, 0L, sourceType);
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (AbstractSourceException e) {
            return this.exceptionHandler((AbstractQingException)e);
        }
        catch (AbstractQingIntegratedException e) {
            return this.exceptionHandler((AbstractQingException)e);
        }
    }

    @Override
    @LongTimeServiceMethodAnnotation
    public byte[] getDataCount(Map<String, String> params) {
        String arrjsonEntity = params.get("entities");
        String jsonSources = params.get("sources");
        Entites entities = ModelDecoder.decode(arrjsonEntity, Entites.class);
        Sources sources = ModelDecoder.decode(jsonSources, Sources.class);
        try {
            Long result;
            String cacheKey = this.getCacheKey(params, CacheType.COUNT);
            IGlobalQingSession session = QingSessionUtil.getGlobalQingSessionImpl();
            String cacheCount = session.hGet(cacheKey, DigestUtils.md5Hex((String)(arrjsonEntity + jsonSources)));
            if (StringUtils.isBlank((String)cacheCount)) {
                AbstractEntity entity = entities.getEntities().get(0);
                IEntityDataService dataService = EntityDataServiceFactory.newDataService(entity);
                result = dataService.getDataCount(this.qingContext, entities, sources, this.getQingFileVisitorMap(entity, sources));
                List keys = session.hKeys(cacheKey);
                for (String key : keys) {
                    session.hRemove(cacheKey, key);
                }
                session.hSet(cacheKey, DigestUtils.md5Hex((String)(arrjsonEntity + jsonSources)), result.toString());
            } else {
                result = Long.valueOf(cacheCount);
            }
            session.expireAfter(cacheKey, 2, TimeUnit.HOURS);
            return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap((Object)result));
        }
        catch (AbstractSourceException e) {
            return this.exceptionHandler((AbstractQingException)e);
        }
        catch (AbstractQingIntegratedException e) {
            return this.exceptionHandler((AbstractQingException)e);
        }
    }

    @BehaviorAssociate(behavior=true)
    @LongTimeServiceMethodAnnotation
    public byte[] delCache(Map<String, String> params) {
        IGlobalQingSession session = QingSessionUtil.getGlobalQingSessionImpl();
        String previewCacheKey = this.getCacheKey(params, CacheType.PREVIEW);
        List hkeys = session.hKeys(previewCacheKey);
        for (String hkey : hkeys) {
            FileFactory.clearTempFile((QingTempFileType)QingTempFileType.DS_CACHE, (String)session.hGet(previewCacheKey, hkey));
        }
        session.remove(previewCacheKey);
        session.remove(this.getCacheKey(params, CacheType.COUNT));
        return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap((Object)"ok"));
    }

    private String getCacheKey(Map<String, String> params, CacheType cacheType) {
        Entites entities = ModelDecoder.decode(params.get("entities"), Entites.class);
        String entityName = entities.getEntities().get(0).getName();
        return ServerRequestInvokeContext.staticGetClientID() + entityName + cacheType.name();
    }

    private String getPreviewDataInCache(String previewFileName) {
        if (StringUtils.isNotBlank((String)previewFileName) && FileFactory.newFileVisitor((AbstractQingFileType)QingTempFileType.DS_CACHE, (String)previewFileName).exists()) {
            try {
                byte[] fileContent = FileFactory.getFileContent((AbstractQingFileType)QingTempFileType.DS_CACHE, (String)previewFileName);
                return new String(fileContent);
            }
            catch (IOException e) {
                LogUtil.error((String)"getPreviewDataInCache error ", (Throwable)e);
                return "";
            }
        }
        return "";
    }

    private String writePreviewDataToCache(String previewData) {
        IQingFile qingFile = FileFactory.newTempFile((QingTempFileType)QingTempFileType.DS_CACHE);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(previewData.getBytes());
        try {
            qingFile.write((IWriteCall)new CopyWriteCall((InputStream)inputStream, true), true);
            return qingFile.getName();
        }
        catch (IOException e) {
            LogUtil.error((String)"writePreviewDataToCache error ", (Throwable)e);
            return "";
        }
    }

    protected Map<Entity, IQingFileVisitor> getQingFileVisitorMap(AbstractEntity abstractEntity, Sources sources) throws QSFileNotFoundException {
        return new HashMap<Entity, IQingFileVisitor>();
    }

    public byte[] previewRuntimeUserSQL(Map<String, String> params) {
        String sql = params.get("sql");
        try {
            sql = SQLHelper.previewUserSQL((String)sql, (QingContext)this.qingContext);
            return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap((Object)sql));
        }
        catch (AbstractSourceException e) {
            return this.exceptionHandler((AbstractQingException)e);
        }
    }

    static enum CacheType {
        PREVIEW,
        COUNT;

    }
}

