/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.util;

import com.kingdee.bos.qing.common.i18n.Messages;
import com.kingdee.bos.qing.data.domain.source.file.excel07.cell.CellDataType;
import com.kingdee.bos.qing.data.domain.source.file.excel07.cell.CellInfo;
import java.util.HashSet;
import java.util.Set;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.DateUtil;

public class ExcelDataUtil {
    private static final Set<Integer> POI_UNSUPPORT_DATE_ID_SETS = new HashSet<Integer>();
    private static final Set<Integer> POI_UNSUPPORT_TIME_ID_SETS = new HashSet<Integer>();
    private static final Set<String> POI_UNSUPPORT_TIME_FORMATE_SETS = new HashSet<String>();
    protected static final DataFormatter formatter = new DataFormatter();

    public static boolean isDateCell(CellInfo cellInfo) {
        if (cellInfo.getCellDataType() != CellDataType.NUMBER) {
            return false;
        }
        if (DateUtil.isADateFormat((int)cellInfo.getNumFmtIndex(), (String)cellInfo.getNumFmtString())) {
            return true;
        }
        int numFmtIndex = cellInfo.getNumFmtIndex();
        if (POI_UNSUPPORT_TIME_ID_SETS.contains(numFmtIndex) || POI_UNSUPPORT_DATE_ID_SETS.contains(numFmtIndex)) {
            return true;
        }
        return POI_UNSUPPORT_TIME_FORMATE_SETS.contains(cellInfo.getNumFmtString());
    }

    public static String getNumberFormateString(double value, int numFmtIndex, String numFmtString) {
        try {
            return formatter.formatRawCellContents(value, numFmtIndex, numFmtString, true);
        }
        catch (NumberFormatException e) {
            return String.valueOf(value);
        }
    }

    static {
        String i18nHour = Messages.getMLS((String)"hour", (String)"\u65f6", (Messages.ProjectName)Messages.ProjectName.QING_DATA);
        String i18nMinute = Messages.getMLS((String)"minute", (String)"\u5206", (Messages.ProjectName)Messages.ProjectName.QING_DATA);
        String i18nSecond = Messages.getMLS((String)"second", (String)"\u79d2", (Messages.ProjectName)Messages.ProjectName.QING_DATA);
        String i18nMorning = Messages.getMLS((String)"morning", (String)"\u4e0a\u5348", (Messages.ProjectName)Messages.ProjectName.QING_DATA);
        String i18nAfternoon = Messages.getMLS((String)"afternoon", (String)"\u4e0b\u5348", (Messages.ProjectName)Messages.ProjectName.QING_DATA);
        POI_UNSUPPORT_TIME_FORMATE_SETS.add("h\"" + i18nHour + "\"mm\"" + i18nMinute + "\";@");
        POI_UNSUPPORT_TIME_FORMATE_SETS.add("h\"" + i18nHour + "\"mm\"" + i18nMinute + "\"ss\"" + i18nSecond + "\";@");
        POI_UNSUPPORT_TIME_FORMATE_SETS.add("" + i18nMorning + "/" + i18nAfternoon + "h\"" + i18nHour + "\"mm\"" + i18nMinute + "\";@");
        POI_UNSUPPORT_TIME_FORMATE_SETS.add("" + i18nMorning + "/" + i18nAfternoon + "h\"" + i18nHour + "\"mm\"" + i18nMinute + "\"ss\"" + i18nSecond + "\";@");
        POI_UNSUPPORT_TIME_FORMATE_SETS.add("[DBNum1][$-804]h\"" + i18nHour + "\"mm\"" + i18nMinute + "\";@");
        POI_UNSUPPORT_TIME_FORMATE_SETS.add("[DBNum1][$-804]" + i18nMorning + "/" + i18nAfternoon + "h\"" + i18nHour + "\"mm\"" + i18nMinute + "\";@");
        POI_UNSUPPORT_TIME_ID_SETS.add(32);
        POI_UNSUPPORT_TIME_ID_SETS.add(33);
        POI_UNSUPPORT_TIME_ID_SETS.add(34);
        POI_UNSUPPORT_TIME_ID_SETS.add(35);
        POI_UNSUPPORT_TIME_ID_SETS.add(55);
        POI_UNSUPPORT_TIME_ID_SETS.add(56);
        POI_UNSUPPORT_DATE_ID_SETS.add(27);
        POI_UNSUPPORT_DATE_ID_SETS.add(28);
        POI_UNSUPPORT_DATE_ID_SETS.add(29);
        POI_UNSUPPORT_DATE_ID_SETS.add(30);
        POI_UNSUPPORT_DATE_ID_SETS.add(31);
        POI_UNSUPPORT_DATE_ID_SETS.add(36);
        POI_UNSUPPORT_DATE_ID_SETS.add(50);
        POI_UNSUPPORT_DATE_ID_SETS.add(51);
        POI_UNSUPPORT_DATE_ID_SETS.add(52);
        POI_UNSUPPORT_DATE_ID_SETS.add(53);
        POI_UNSUPPORT_DATE_ID_SETS.add(54);
        POI_UNSUPPORT_DATE_ID_SETS.add(57);
        POI_UNSUPPORT_DATE_ID_SETS.add(58);
    }
}

