/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.bill.model;

import com.kingdee.bos.qing.bill.model.BillEntity;
import com.kingdee.bos.qing.bill.model.BillField;
import com.kingdee.bos.qing.bill.model.QueryField;
import com.kingdee.bos.qing.preparedata.handler.controller.model.EntryEntity;
import com.kingdee.bos.qing.preparedata.handler.controller.model.Field;
import com.kingdee.bos.qing.preparedata.handler.controller.model.QingMeta;
import com.kingdee.bos.qing.util.NameUtil;
import java.util.HashMap;
import java.util.List;

public class BillMeta {
    private List<BillField> columns;
    private List<BillEntity> entryEntities;
    private List<QueryField> qingModels;

    public List<BillField> getColumns() {
        return this.columns;
    }

    public void setColumns(List<BillField> columns) {
        this.columns = columns;
    }

    public List<BillEntity> getEntryEntities() {
        return this.entryEntities;
    }

    public void setEntryEntities(List<BillEntity> entryEntities) {
        this.entryEntities = entryEntities;
    }

    public List<QueryField> getQingModels() {
        return this.qingModels;
    }

    public void setQingModels(List<QueryField> qingModels) {
        this.qingModels = qingModels;
    }

    public QingMeta toQingMeta() {
        HashMap repeatedNameIndexes = new HashMap(10);
        QingMeta qingMeta = new QingMeta();
        HashMap<String, BillEntity> entityMap = new HashMap<String, BillEntity>();
        for (BillEntity billEntity : this.entryEntities) {
            entityMap.put(billEntity.getKey(), billEntity);
        }
        for (BillEntity billEntity : this.entryEntities) {
            BillEntity parent;
            EntryEntity entry = billEntity.toEntryEntity();
            String parentKey = billEntity.getParentKey();
            if (null != parentKey && null != (parent = (BillEntity)entityMap.get(parentKey))) {
                entry.setParentName(parent.getName());
            }
            qingMeta.addEntryEntity(entry);
        }
        for (BillField billField : this.columns) {
            Field field = billField.toField();
            BillEntity entity = (BillEntity)entityMap.get(billField.getEntity());
            field.setEntity(entity.getName());
            HashMap repeatedNameIndex = (HashMap)repeatedNameIndexes.get(entity.getName());
            if (repeatedNameIndex == null) {
                repeatedNameIndex = new HashMap();
                repeatedNameIndexes.put(entity.getName(), repeatedNameIndex);
            }
            String pureKey = NameUtil.getPureName((String)field.getName(), repeatedNameIndex);
            field.setName(pureKey);
            qingMeta.getEntryEntity(entity.getName()).addField(field);
            qingMeta.addColumn(field);
        }
        List<EntryEntity> entryEntities = qingMeta.getEntryEntities();
        for (EntryEntity entryEntity : entryEntities) {
            String parentName = entryEntity.getParentName();
            if (parentName == null) continue;
            qingMeta.getEntryEntity(parentName).addChildEntry(entryEntity);
        }
        return qingMeta;
    }
}

