/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.dashboard.util;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.common.exception.AbstractQingException;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.common.ref.model.RefTypeEnum;
import com.kingdee.bos.qing.common.session.QingSessionUtil;
import com.kingdee.bos.qing.dashboard.exception.DashboardException;
import com.kingdee.bos.qing.dashboard.exception.UnsupportedDsbRefSourceException;
import com.kingdee.bos.qing.dashboard.model.ReferenceMap;
import com.kingdee.bos.qing.dashboard.reference.impl.RefHandlerFactory;
import com.kingdee.bos.qing.preparedata.cache.ProgressModel;
import com.kingdee.bos.qing.preparedata.handler.dsbref.DsbRefPrepareDataContext;
import com.kingdee.bos.qing.preparedata.preparedatacontext.AbstractPrepareDataContext;
import com.kingdee.bos.qing.preparedata.task.DataExtractTask;
import com.kingdee.bos.qing.preparedata.task.FromType;
import com.kingdee.bos.qing.publish.dao.PublishPermissionDao;
import com.kingdee.bos.qing.publish.domain.CommonPublishDomain;
import com.kingdee.bos.qing.publish.exception.PublishNoPermissionException;
import com.kingdee.bos.qing.publish.model.PermissionInfo;
import com.kingdee.bos.qing.publish.model.PublishPO;
import com.kingdee.bos.qing.util.IntegratedHelper;
import com.kingdee.bos.qing.util.JsonUtil;
import com.kingdee.bos.qing.util.StringUtils;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public class RefreshDataUtil {
    public static ProgressModel refreshDesignTimeData(Map<String, String> params, QingContext qingContext, ITransactionManagement tx, IDBExcuter dbExcuter, boolean isPublished) throws AbstractQingException {
        try {
            tx.beginRequired();
            String lastRequestCookies = params.get("lastRequestCookies");
            if (StringUtils.isNotBlank((CharSequence)lastRequestCookies)) {
                QingSessionUtil.set((String)"lastRequestCookies", (String)lastRequestCookies);
            }
            String jsonRef = params.get("ref");
            boolean loafingMode = "true".equals(params.get("loafingMode"));
            ReferenceMap referenceMap = (ReferenceMap)JsonUtil.decodeFromString((String)jsonRef, ReferenceMap.class);
            String refType = referenceMap.getRefType();
            String refToId = referenceMap.getRefToId();
            RefTypeEnum refTypeEnum = RefTypeEnum.valueOf((String)refType);
            if (!RefHandlerFactory.isSupport((RefTypeEnum)refTypeEnum)) {
                throw new UnsupportedDsbRefSourceException();
            }
            String dashboardUniqueId = params.get("dashboardUniqueId");
            String tag = params.get("tag");
            if (tag == null) {
                tag = UUID.randomUUID().toString();
            }
            if (refToId != null) {
                RefreshDataUtil.checkDesignTimeDsbPermission(refToId, qingContext, tx, dbExcuter);
            }
            DsbRefPrepareDataContext dsbRefPrepareDataContext = new DsbRefPrepareDataContext();
            dsbRefPrepareDataContext.setQingContext(qingContext);
            dsbRefPrepareDataContext.setDbExcuter(dbExcuter);
            dsbRefPrepareDataContext.setTx(tx);
            dsbRefPrepareDataContext.setTag(tag);
            dsbRefPrepareDataContext.setFromType(FromType.dsbRef);
            dsbRefPrepareDataContext.setDealProgresss(false);
            dsbRefPrepareDataContext.setStartBySchedule(false);
            dsbRefPrepareDataContext.setFirstFromCache(loafingMode);
            dsbRefPrepareDataContext.setPublished(isPublished);
            dsbRefPrepareDataContext.setDashboardUniqueId(dashboardUniqueId);
            dsbRefPrepareDataContext.setReferenceMap(referenceMap);
            DataExtractTask task = new DataExtractTask((AbstractPrepareDataContext)dsbRefPrepareDataContext);
            ProgressModel progressModel = task.call();
            return progressModel;
        }
        catch (AbstractQingException e) {
            throw e;
        }
        finally {
            tx.end();
        }
    }

    public static ProgressModel refreshRuntimeData(Map<String, String> params, QingContext qingContext, ITransactionManagement tx, IDBExcuter dbExcuter) throws AbstractQingException {
        String jsonRef = params.get("ref");
        String lastRequestCookies = params.get("lastRequestCookies");
        if (StringUtils.isNotBlank((CharSequence)lastRequestCookies)) {
            QingSessionUtil.set((String)"lastRequestCookies", (String)lastRequestCookies);
        }
        ReferenceMap referenceMap = (ReferenceMap)JsonUtil.decodeFromString((String)jsonRef, ReferenceMap.class);
        String refType = referenceMap.getRefType();
        String refToId = referenceMap.getRefToId();
        RefTypeEnum refTypeEnum = RefTypeEnum.valueOf((String)refType);
        if (!RefHandlerFactory.isSupport((RefTypeEnum)refTypeEnum)) {
            throw new UnsupportedDsbRefSourceException();
        }
        String dashboardUniqueId = params.get("dashboardUniqueId");
        boolean dealProgresss = "true".equals(params.get("dealProgresss"));
        boolean isFirstFromCache = "true".equals(params.get("isFirstFromCache"));
        String tag = params.get("tag");
        if (tag == null) {
            tag = UUID.randomUUID().toString();
        }
        if (refToId != null) {
            RefreshDataUtil.checkPublishDsbPermission(dashboardUniqueId, refToId, qingContext, tx, dbExcuter);
        }
        DsbRefPrepareDataContext dsbRefPrepareDataContext = new DsbRefPrepareDataContext();
        dsbRefPrepareDataContext.setQingContext(qingContext);
        dsbRefPrepareDataContext.setDbExcuter(dbExcuter);
        dsbRefPrepareDataContext.setTx(tx);
        dsbRefPrepareDataContext.setTag(tag);
        dsbRefPrepareDataContext.setFromType(FromType.dsbRef);
        dsbRefPrepareDataContext.setDealProgresss(dealProgresss);
        dsbRefPrepareDataContext.setStartBySchedule(false);
        dsbRefPrepareDataContext.setFirstFromCache(isFirstFromCache);
        String timeStamp = params.get("timeStamp");
        if (StringUtils.isNotBlank((CharSequence)timeStamp)) {
            dsbRefPrepareDataContext.setTimeStamp(Long.parseLong(timeStamp));
        }
        dsbRefPrepareDataContext.setPublished(true);
        dsbRefPrepareDataContext.setDashboardUniqueId(dashboardUniqueId);
        dsbRefPrepareDataContext.setReferenceMap(referenceMap);
        DataExtractTask task = new DataExtractTask((AbstractPrepareDataContext)dsbRefPrepareDataContext);
        return task.call();
    }

    private static void checkDesignTimeDsbPermission(String refToId, QingContext qingContext, ITransactionManagement tx, IDBExcuter dbExcuter) throws AbstractQingException {
        String userId = qingContext.getUserId();
        try {
            RefreshDataUtil.checkPermission(userId, refToId, qingContext, tx, dbExcuter);
        }
        catch (SQLException e) {
            throw new DashboardException((Throwable)e);
        }
    }

    private static void checkPublishDsbPermission(String publishId, String refToId, QingContext qingContext, ITransactionManagement tx, IDBExcuter dbExcuter) throws AbstractQingException {
        try {
            CommonPublishDomain publishDomain = new CommonPublishDomain(qingContext, tx, dbExcuter);
            PublishPO publishInfo = publishDomain.loadPublishInfo(publishId);
            if (publishInfo != null) {
                String string = publishInfo.getCreatorId();
            }
        }
        catch (SQLException e) {
            throw new DashboardException((Throwable)e);
        }
    }

    private static void checkPermission(String ownerId, String refToId, QingContext qingContext, ITransactionManagement tx, IDBExcuter dbExcuter) throws SQLException, AbstractQingIntegratedException, PublishNoPermissionException {
        PublishPO refPublishInfo = new CommonPublishDomain(qingContext, tx, dbExcuter).loadPublishInfo(refToId);
        if (refPublishInfo == null || IntegratedHelper.isCurrentUserInQingAdminRole((QingContext)qingContext, (IDBExcuter)dbExcuter) && refPublishInfo.isPreset()) {
            return;
        }
        boolean flag = false;
        if (ownerId.equals(refPublishInfo.getCreatorId())) {
            flag = true;
        } else {
            PublishPermissionDao publishPermissionDao = new PublishPermissionDao(dbExcuter);
            List permissionInfos = publishPermissionDao.loadPublishPermissionInfo(refPublishInfo.getId());
            Set userRoles = IntegratedHelper.getUserRoleIds((QingContext)qingContext, (IDBExcuter)dbExcuter, (String)ownerId);
            for (PermissionInfo permissionInfo : permissionInfos) {
                if (permissionInfo.getType() == 2) {
                    flag = true;
                    break;
                }
                if (permissionInfo.getType() == 0 && permissionInfo.getViewerId().equals(ownerId)) {
                    flag = IntegratedHelper.isNormalUser((QingContext)qingContext, (IDBExcuter)dbExcuter, (String)refPublishInfo.getCreatorId());
                    break;
                }
                if ((permissionInfo.getType() != 3 || refPublishInfo.getCreatorId() == null || "-1".equals(refPublishInfo.getCreatorId())) && (permissionInfo.getType() != 1 || !userRoles.contains(permissionInfo.getViewerId()))) continue;
                flag = true;
                break;
            }
        }
        if (!flag) {
            String userName = IntegratedHelper.getUserName((QingContext)qingContext, (IDBExcuter)dbExcuter, (String)refPublishInfo.getCreatorId());
            throw new PublishNoPermissionException(userName);
        }
    }
}

