/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.domain;

import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.qing.data.domain.BizMetaUtil;
import com.kingdee.bos.qing.data.model.EasForeignKeyInfo;
import com.kingdee.bos.qing.data.model.designtime.AbstractSource;
import com.kingdee.bos.qing.data.model.designtime.DesigningDataType;
import com.kingdee.bos.qing.data.model.designtime.Entity;
import com.kingdee.bos.qing.data.model.designtime.IEntityExtensionProvider;
import com.kingdee.bos.qing.data.model.designtime.Property;
import com.kingdee.bos.qing.data.model.designtime.Relation;
import com.kingdee.bos.qing.data.model.designtime.TreeProperty;
import com.kingdee.bos.qing.data.model.runtime.EasEntityExtension;
import com.kingdee.bos.qing.data.model.runtime.EasEntityExtensionProvider;
import com.kingdee.bos.qing.data.model.vo.DesigntimeDataObject;
import com.kingdee.bos.qing.preparedata.handler.controller.model.ComplexField;
import com.kingdee.bos.qing.preparedata.handler.controller.model.EntryEntity;
import com.kingdee.bos.qing.preparedata.handler.controller.model.Field;
import com.kingdee.bos.qing.preparedata.handler.controller.model.QingMeta;
import com.kingdee.bos.qing.preparedata.util.FieldTypeUtil;
import com.kingdee.bos.qing.util.NameUtil;
import com.kingdee.bos.qing.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class DesignObjectBuilder {
    private Map<String, Map<String, Integer>> repeatedNameIndexs = new HashMap<String, Map<String, Integer>>(10);
    private Map<String, String> fieldKeyToPureKeyMap = new HashMap<String, String>(10);
    private DesigntimeDataObject designtimeDataObject = new DesigntimeDataObject();
    private Map<String, String> entityPkFieldMap = new HashMap<String, String>(10);
    private Map<String, String> entityParentPkFieldMap = new HashMap<String, String>(10);
    private Map<String, Field> fieldMap = new HashMap<String, Field>(10);
    private Map<String, Entity> entityMap = new HashMap<String, Entity>(10);
    private Map<String, EntryEntity> entryEntityMap = new LinkedHashMap<String, EntryEntity>();
    private Map<String, EntryEntity> entryEntityAssociateMap = new HashMap<String, EntryEntity>();

    public DesigntimeDataObject buildFromQingMeta(QingMeta qingMeta, AbstractSource source) {
        this.prepareFieldPureName(qingMeta.getColumns());
        List<EntryEntity> entryEntities = qingMeta.getEntryEntities();
        this.prepareEntityPkField(entryEntities);
        this.prepareEntity(entryEntities, source);
        this.prepareRelation(entryEntities);
        this.prepareEntityProperty();
        this.prepareEntityExtension(entryEntities);
        return this.designtimeDataObject;
    }

    private void prepareFieldPureName(List<Field> fields) {
        for (Field field : fields) {
            String fieldEntityName = field.getEntity();
            Map<String, Integer> repeatedNameIndex = this.repeatedNameIndexs.get(fieldEntityName);
            if (repeatedNameIndex == null) {
                repeatedNameIndex = new HashMap<String, Integer>();
                this.repeatedNameIndexs.put(fieldEntityName, repeatedNameIndex);
            }
            String fieldName = field.getName();
            String fieldWithEnityName = fieldEntityName + "." + fieldName;
            String pureKey = NameUtil.getPureName((String)fieldName, repeatedNameIndex);
            this.fieldKeyToPureKeyMap.put(fieldWithEnityName, pureKey);
            if (field instanceof ComplexField) {
                ComplexField complexField = (ComplexField)field;
                for (Field child : complexField.getInnerFields()) {
                    String childFieldName = complexField.getEntity() + "." + child.getName();
                    String childPureName = NameUtil.getPureName((String)childFieldName, repeatedNameIndex);
                    this.fieldKeyToPureKeyMap.put(childFieldName, childPureName);
                }
            }
            this.fieldMap.put(fieldWithEnityName, field);
        }
    }

    private void prepareEntityPkField(List<EntryEntity> entryEntities) {
        for (EntryEntity entryEntity : entryEntities) {
            String pkFieldName = entryEntity.getPkFieldName();
            this.entityPkFieldMap.put(entryEntity.getName(), pkFieldName);
            this.entityParentPkFieldMap.put(entryEntity.getName(), entryEntity.getParentEntityPkField());
        }
    }

    private void prepareEntity(List<EntryEntity> entryEntities, AbstractSource source) {
        for (EntryEntity entryEntity : entryEntities) {
            Entity entity = new Entity();
            entity.setSource(source.getName());
            String entityName = entryEntity.getName();
            entity.setAlias(entryEntity.getAlias());
            entity.setName(entityName);
            String parentName = entryEntity.getParentName();
            entity.setParentName(parentName);
            entity.setAssociateName(entryEntity.getKey());
            entity.setCommentInfo(entityName);
            this.entryEntityMap.put(entityName, entryEntity);
            this.entryEntityAssociateMap.put(entryEntity.getKey(), entryEntity);
            this.entityMap.put(entityName, entity);
            this.designtimeDataObject.addEntity(entity);
        }
    }

    private void prepareRelation(List<EntryEntity> entryEntities) {
        for (EntryEntity entryEntity : entryEntities) {
            String parentEntityName = entryEntity.getParentName();
            String entityName = entryEntity.getName();
            if (null == parentEntityName) continue;
            Relation relation = new Relation();
            String parentPKKey = this.entityPkFieldMap.get(parentEntityName);
            String fromProperty = this.fieldKeyToPureKeyMap.get(parentEntityName + "." + parentPKKey);
            String toProperty = this.fieldKeyToPureKeyMap.get(entityName + "." + entryEntity.getParentEntityPkField());
            relation.setFromEntity(parentEntityName);
            relation.setFromPointKeepFifthWheel(true);
            relation.setFromProperty(fromProperty);
            relation.setToEntity(entityName);
            relation.setToProperty(toProperty);
            relation.setToPointKeepFifthWheel(false);
            relation.setRelated(Relation.Related.From1ToN);
            this.designtimeDataObject.addRelation(relation);
            this.fieldMap.get(parentEntityName + "." + parentPKKey).addCustomInfo("isWhiteField", true);
        }
    }

    private void prepareEntityProperty() {
        for (EntryEntity entryEntity : this.entryEntityMap.values()) {
            this.processEntryFields(entryEntity);
        }
    }

    private void processEntryFields(EntryEntity entryEntity) {
        String entityName = entryEntity.getName();
        Entity entity = this.entityMap.get(entityName);
        ArrayList<Property> properties = new ArrayList<Property>();
        entity.setProperties(properties);
        String parentLinkFieldName = BizMetaUtil.getFieldPrefix(entryEntity);
        HashMap aliasRepeatTimeMap = new HashMap();
        List<Field> fields = entryEntity.getFields();
        for (Field field : fields) {
            String entryEntityName = field.getEntity();
            Property property = new Property();
            property.addExtensionData("isOrmSupported", (Object)field.isSupportOrm());
            property.addExtensionData("isDataModelSupported", (Object)field.isSupportQingDataModel());
            property.addExtensionData("metaField", (Object)field);
            String associateName = field.getName();
            String fieldWithEntityName = entryEntityName + "." + associateName;
            String pureName = this.fieldKeyToPureKeyMap.get(fieldWithEntityName);
            if (field.isSupportQingDataModel()) {
                PropertyInfo pi = (PropertyInfo)field.getCustomInfo("parentPkField");
                if (null != pi) {
                    properties.add(1, property);
                } else {
                    properties.add(property);
                }
            }
            property.setName(pureName);
            property.setAssociateName(parentLinkFieldName + associateName);
            property.setCommentInfo(pureName);
            String alias = NameUtil.getPureName((String)field.getAlias(), aliasRepeatTimeMap);
            property.setAlias(alias);
            property.setDataType(FieldTypeUtil.getDesignDataType(field.getFieldType()));
            this.setEnumDataIfExist(field, property);
            field.addCustomInfo("qingProperty", property);
            this.setLinkToForeignProperty(field, parentLinkFieldName, property);
            if (!(field instanceof ComplexField)) continue;
            ComplexField complexField = (ComplexField)field;
            List<Field> innerFields = complexField.getInnerFields();
            ArrayList<Property> innerProps = new ArrayList<Property>();
            for (Field innerField : innerFields) {
                Property innerPropert = new Property();
                String innerFieldName = complexField.getEntity() + "." + innerField.getName();
                innerPropert.addExtensionData("isOrmSupported", (Object)false);
                innerPropert.setName(this.fieldKeyToPureKeyMap.get(innerFieldName));
                innerPropert.setAssociateName(innerField.getName());
                innerPropert.setHide(innerField.isHide());
                innerPropert.setAlias(innerField.getAlias());
                innerPropert.addExtensionData("metaField", (Object)innerField);
                innerPropert.setDataType(FieldTypeUtil.getDesignDataType(innerField.getFieldType()));
                innerProps.add(innerPropert);
                innerField.addCustomInfo("qingProperty", innerPropert);
            }
            property.addExtensionData("isFlexField", (Object)true);
            TreeProperty treeProperty = new TreeProperty(property, innerProps, 0);
            entity.getTreeNodeProperties().add(treeProperty);
        }
    }

    private void setLinkToForeignProperty(Field field, String parentlinkFieldName, Property property) {
        EasForeignKeyInfo foreignKey = (EasForeignKeyInfo)field.getCustomInfo("foreignKey");
        if (null != foreignKey) {
            String entityAssociateName = foreignKey.getEntityAssociateName();
            EntryEntity entryEntity = this.entryEntityAssociateMap.get(entityAssociateName);
            if (null != entryEntity) {
                String pkPropName = foreignKey.getPkPropertyName();
                String displayPropName = foreignKey.getDisplayPropertyName();
                Field refParentField = entryEntity.getField(pkPropName);
                Property refPkProperty = (Property)refParentField.getCustomInfo("qingProperty");
                property.addExtensionData("refProperty", (Object)refPkProperty);
                if (!StringUtils.isEmpty((CharSequence)displayPropName)) {
                    Field refDisplayField = entryEntity.getField(displayPropName);
                    Property refDisplayProperty = (Property)refDisplayField.getCustomInfo("qingProperty");
                    property.addExtensionData("refDisplayProperty", (Object)refDisplayProperty);
                }
            } else {
                PropertyInfo pkPropertyInfo = foreignKey.getPkProperty();
                Property refPkProperty = new Property();
                refPkProperty.setAssociateName(parentlinkFieldName + field.getName() + "." + pkPropertyInfo.getName());
                refPkProperty.setDataType(property.getDataType());
                refPkProperty.setName(property.getName());
                refPkProperty.addExtensionData("isOrmSupported", (Object)true);
                property.addExtensionData("refProperty", (Object)refPkProperty);
                PropertyInfo displayPropertyInfo = foreignKey.getDisplayProperty();
                if (null != displayPropertyInfo) {
                    Property displayProperty = new Property();
                    displayProperty.setName(property.getName() + "." + displayPropertyInfo.getName());
                    displayProperty.setAssociateName(parentlinkFieldName + field.getName() + "." + displayPropertyInfo.getName());
                    displayProperty.setDataType(property.getDataType());
                    displayProperty.addExtensionData("isDataModelSupported", (Object)false);
                    displayProperty.addExtensionData("isOrmSupported", (Object)true);
                    property.addExtensionData("refDisplayProperty", (Object)displayProperty);
                }
            }
        }
    }

    private void setEnumDataIfExist(Field field, Property property) {
        Map<String, String> enumItems = field.getEnumItems();
        property.setEnumValue(enumItems);
        if (enumItems != null && enumItems.size() > 0) {
            property.setDataType(DesigningDataType.STRING);
        }
    }

    private void prepareEntityExtension(List<EntryEntity> entryEntities) {
        for (EntryEntity entryEntity : entryEntities) {
            EasEntityExtension extension = new EasEntityExtension();
            String entityName = entryEntity.getName();
            Entity entity = this.entityMap.get(entityName);
            extension.setLocalPkProperty((Property)entity.getProperties().get(0));
            extension.setOriginalMetaFields(entryEntity.getFields());
            extension.setPermisionDataRule(entryEntity.getPermissionDataRule());
            extension.setBizOrgPropName(entryEntity.getBizOrgPropName());
            String parentFieldPrefix = BizMetaUtil.getFieldPrefix(entryEntity);
            if (!parentFieldPrefix.isEmpty()) {
                extension.setParentFullFieldName(parentFieldPrefix.substring(0, parentFieldPrefix.length() - 1));
            }
            extension.setLinkPropertyToParent(entryEntity.getLinkPropertyToParent());
            extension.setLinkPropertyInfoToEntry(entryEntity.getLinkPropertyToEntrys());
            EasEntityExtensionProvider provider = new EasEntityExtensionProvider(extension);
            entity.setExtensionProvider((IEntityExtensionProvider)provider);
        }
    }
}

