/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.datasource;

import com.kingdee.bos.qing.common.cache.AbstractDataSource;
import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.datasource.AbstractImpl;
import com.kingdee.bos.qing.datasource.MutilQingFileVisitor;
import com.kingdee.bos.qing.datasource.exception.AbstractDataSourceException;
import com.kingdee.bos.qing.datasource.meta.DSFieldKey;
import com.kingdee.bos.qing.datasource.model.filter.AbstractUnderDSFilter;
import com.kingdee.bos.qing.datasource.model.filter.UnderDSDiscreteFilter;
import com.kingdee.bos.qing.datasource.spec.IDataSourceVisitor;
import com.kingdee.bos.qing.datasource.spec.IMetaVisitor;
import com.kingdee.bos.qing.datasource.spec.qs.QSDataSourceVisitor;
import com.kingdee.bos.qing.filesystem.manager.FileFactory;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFileVisitor;
import com.kingdee.bos.qing.filesystem.manager.model.AbstractQingFileType;
import com.kingdee.bos.qing.preparedata.model.BudgetDataSource;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BudgetDataSourceCreator
extends AbstractImpl {
    private BudgetDataSource dataSource;

    public BudgetDataSourceCreator(QingContext qingContext, String tag, AbstractDataSource dataSource) {
        this.dataSource = (BudgetDataSource)dataSource;
    }

    public IMetaVisitor createMetaVisitor() throws AbstractDataSourceException {
        return this.createDataSourceVisitor();
    }

    public IDataSourceVisitor createDataSourceVisitor() throws AbstractDataSourceException {
        List<String> files = this.dataSource.getFiles();
        ArrayList<IQingFileVisitor> fileList = new ArrayList<IQingFileVisitor>();
        for (String file : files) {
            IQingFileVisitor dataFile = FileFactory.newFileVisitor((AbstractQingFileType)this.dataSource.getStoreFileType(), (String)file);
            fileList.add(dataFile);
        }
        MutilQingFileVisitor mutilQingFileVisitor = new MutilQingFileVisitor(fileList);
        QSDataSourceVisitor qsDataSourceVisitor = new QSDataSourceVisitor((IQingFileVisitor)mutilQingFileVisitor);
        Map<String, List<String>> filter = this.dataSource.getFilter();
        if (filter != null && !filter.isEmpty()) {
            qsDataSourceVisitor.setOuterFilter(this.parseMapToUnderDSDiscreteFilter(filter));
        }
        this.dataSource.updateMeta(qsDataSourceVisitor.getMeta());
        return qsDataSourceVisitor;
    }

    private Set<AbstractUnderDSFilter> parseMapToUnderDSDiscreteFilter(Map<String, List<String>> filter) {
        HashSet<AbstractUnderDSFilter> underDSDiscreteFilterSet = new HashSet<AbstractUnderDSFilter>();
        Iterator<String> iterator = filter.keySet().iterator();
        while (iterator.hasNext()) {
            String key;
            String propertyName = key = iterator.next();
            DSFieldKey field = new DSFieldKey(propertyName);
            UnderDSDiscreteFilter underDSDiscreteFilter = new UnderDSDiscreteFilter(field);
            underDSDiscreteFilter.setSelected(filter.get(key));
            underDSDiscreteFilterSet.add((AbstractUnderDSFilter)underDSDiscreteFilter);
        }
        if (underDSDiscreteFilterSet.size() != 0) {
            return underDSDiscreteFilterSet;
        }
        return null;
    }
}

