/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.license;

import com.kingdee.bos.Context;
import com.kingdee.bos.qing.license.exception.QingLicenseException;
import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.eas.base.license.ILicenseSrvAgent;
import com.kingdee.eas.base.license.LicenseException;
import com.kingdee.eas.base.license.LicenseUserInfo;
import com.kingdee.eas.base.license.ModuleLicenseInfo;
import com.kingdee.eas.base.license.agent.LicenseSrvAgent;
import com.kingdee.eas.base.license.client.LicenseSrvAgentFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.util.app.ContextUtil;
import java.util.Date;

public class QingAnalysisLicenseChecker {
    private static int _systemLicType = -1;
    private Context _ctx;
    private LicenseUserInfo _userInfo;

    public QingAnalysisLicenseChecker(Context ctx) {
        this._ctx = ctx;
        this._userInfo = this.getLicenseUserInfo();
    }

    public boolean checkLicense() throws QingLicenseException {
        int flag = 1;
        try {
            flag = this.getAgent().reqeustLicenseByModuleAndUIName(this._userInfo, "QING", "/easweb/bos/qing/theme-manage/index.do");
            switch (flag) {
                case 4: {
                    throw QingLicenseException.NotRegisteredUserException;
                }
                case 2: {
                    throw QingLicenseException.NoMoreConcurrentException;
                }
                case 1: {
                    return true;
                }
            }
        }
        catch (LicenseException e) {
            throw QingLicenseException.wrap((Exception)((Object)e), 3010001);
        }
        return false;
    }

    public boolean releaseLicense() throws QingLicenseException {
        try {
            this.getAgent().releaseLicenseByModuleAndUIName(this._ctx.getContextID(), "QING", "/easweb/bos/qing/theme-manage/index.do");
            LogUtil.info((String)("releaseQingLicense id:" + this._ctx.getContextID()));
            return true;
        }
        catch (LicenseException e) {
            throw QingLicenseException.wrap((Exception)((Object)e), 3010001);
        }
    }

    public int sysLicenseModuleType() throws QingLicenseException {
        if (_systemLicType == -1) {
            _systemLicType = this.retrieveSysLicenseModeleType();
        }
        return _systemLicType;
    }

    public int retrieveSysLicenseModeleType() throws QingLicenseException {
        int type = 0;
        try {
            ModuleLicenseInfo[] licenses = this.getAgent().getModuleLicenseInfo();
            if (licenses.length == 0) {
                return 1;
            }
            for (int i = 0; i < licenses.length; ++i) {
                if (!licenses[i].containModule("QING") && !licenses[i].getModuleName().equals("QING")) continue;
                type = 1;
                break;
            }
            return type;
        }
        catch (Exception e) {
            throw QingLicenseException.wrap(e, 3010001);
        }
    }

    private ILicenseSrvAgent getAgent() throws QingLicenseException {
        ILicenseSrvAgent agent;
        try {
            agent = this._ctx == null ? LicenseSrvAgentFactory.getRemoteInstance() : LicenseSrvAgent.getLocalInstance();
        }
        catch (LicenseException e) {
            throw QingLicenseException.wrap((Exception)((Object)e), 3010001);
        }
        return agent;
    }

    private LicenseUserInfo getLicenseUserInfo() {
        LicenseUserInfo info = new LicenseUserInfo();
        info.setSessionID(this._ctx.getContextID());
        info.setUserID(this._ctx.getCaller().toString());
        info.setUserIP(this._ctx.getClientHostIP());
        UserInfo userInfo = (UserInfo)this._ctx.get((Object)"UserInfo");
        if (userInfo != null) {
            info.setUserName(userInfo.getNumber());
        } else {
            info.setUserName(this._ctx.getUserName());
        }
        info.setUserLoginAis(this._ctx.getAIS());
        info.setUserName(this._ctx.getUserName());
        info.setUserLoginTime(new Date());
        OrgUnitInfo orgUnitInfo = ContextUtil.getCurrentOrgUnit((Context)this._ctx);
        if (orgUnitInfo != null) {
            info.setUserCompany(orgUnitInfo.getName());
        }
        return info;
    }
}

