/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.preparedata.handler;

import com.kingdee.bos.qing.datasource.meta.DSElimination;
import com.kingdee.bos.qing.datasource.meta.DSFieldKey;
import com.kingdee.bos.qing.datasource.meta.DSMetaEntity;
import com.kingdee.bos.qing.datasource.meta.DSMetaProperty;
import com.kingdee.bos.qing.datasource.meta.DataType;
import com.kingdee.bos.qing.preparedata.exception.BillFormException;
import com.kingdee.bos.qing.preparedata.handler.controller.model.EntryEntity;
import com.kingdee.bos.qing.preparedata.handler.controller.model.Field;
import com.kingdee.bos.qing.preparedata.handler.controller.model.QingMeta;
import com.kingdee.bos.qing.preparedata.util.FieldTypeUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class QingMetaToDSEliminations {
    private QingMeta qingMeta;
    private Map<String, EntityNode> allEntities;
    private Map<String, DSFieldKey> pkFieldKeys;
    private Map<String, DSMetaEntity> entityMap;

    public QingMetaToDSEliminations(QingMeta qingMeta) {
        this.qingMeta = qingMeta;
    }

    public List<DSElimination> getDSEliminations(Map<String, String> nameMap) throws BillFormException {
        List<EntryEntity> entryEntities = this.qingMeta.getEntryEntities();
        if (entryEntities == null || entryEntities.isEmpty()) {
            return null;
        }
        this.init(entryEntities, this.qingMeta.getColumns(), nameMap);
        ArrayList<DSElimination> eliminations = new ArrayList<DSElimination>();
        for (String entityName : this.entityMap.keySet()) {
            DSMetaEntity entity = this.entityMap.get(entityName);
            DSElimination el = this.parseElimination(entity);
            if (el == null || el.getAssociatedFields() == null || el.getAssociatedFields().isEmpty()) continue;
            eliminations.add(el);
        }
        return eliminations.isEmpty() ? null : eliminations;
    }

    private DSElimination parseElimination(DSMetaEntity entity) throws BillFormException {
        String entityName = entity.getName();
        if (entityName == null || entityName.isEmpty()) {
            return null;
        }
        DSElimination el = this.collectIdFields(this.allEntities.get(entityName));
        if (el == null) {
            return null;
        }
        List properties = entity.getProperties();
        for (DSMetaProperty p : properties) {
            if (!this.isAssociatedField(p, entityName)) continue;
            el.addAssociatedFields(p.getName());
        }
        return el;
    }

    private void init(List<EntryEntity> entryEntities, List<Field> columns, Map<String, String> nameMap) {
        this.entityMap = new HashMap<String, DSMetaEntity>();
        this.pkFieldKeys = new HashMap<String, DSFieldKey>();
        for (EntryEntity entity : entryEntities) {
            String pkField = entity.getPkFieldName();
            if (nameMap.containsKey(pkField)) {
                pkField = nameMap.get(pkField);
            }
            this.pkFieldKeys.put(entity.getName(), new DSFieldKey(entity.getName(), pkField));
            DSMetaEntity dSMetaEntity = new DSMetaEntity(entity.getName(), entity.getAlias());
            dSMetaEntity.setParentName(entity.getParentName());
            this.entityMap.put(entity.getName(), dSMetaEntity);
        }
        for (Field field : columns) {
            String fieldName;
            String entityName = field.getEntity();
            DSMetaEntity entity = this.entityMap.get(entityName);
            if (entity == null) continue;
            ArrayList<DSMetaProperty> properties = entity.getProperties();
            if (properties == null) {
                properties = new ArrayList<DSMetaProperty>();
                entity.setProperties(properties);
            }
            if (nameMap.containsKey(fieldName = field.getName())) {
                fieldName = nameMap.get(fieldName);
            }
            DSMetaProperty property = new DSMetaProperty(fieldName, field.getAlias(), FieldTypeUtil.changeQingFieldTypeToDataType(field.getFieldType()), null, Boolean.valueOf(field.isHide()));
            properties.add(property);
        }
        this.allEntities = new HashMap<String, EntityNode>();
        for (String entityName : this.entityMap.keySet()) {
            DSMetaEntity entity = this.entityMap.get(entityName);
            EntityNode node = new EntityNode();
            entityName = entity.getName();
            node.setKey(entityName);
            DSFieldKey pk = this.pkFieldKeys.get(entityName);
            if (pk != null) {
                node.setPkFieldName(pk.getPropertyName());
            }
            node.setParentKey(entity.getParentName());
            this.allEntities.put(entityName, node);
        }
        for (String nodeName : this.allEntities.keySet()) {
            EntityNode node = this.allEntities.get(nodeName);
            EntityNode parentNode = this.allEntities.get(node.getParentKey());
            if (parentNode == null) continue;
            parentNode.setHasChild(true);
            node.setParent(parentNode);
        }
    }

    private boolean isAssociatedField(DSMetaProperty property, String entityName) {
        if (!DataType.NUMBER.equals((Object)property.getDataType())) {
            return false;
        }
        String propertyName = property.getName();
        DSFieldKey pkField = this.pkFieldKeys.get(entityName);
        if (pkField == null) {
            return true;
        }
        return !propertyName.equals(pkField.getPropertyName());
    }

    private DSElimination collectIdFields(EntityNode node) throws BillFormException {
        if (node == null || !node.isHasChild()) {
            return null;
        }
        DSElimination el = new DSElimination();
        HashSet<String> visitedNode = new HashSet<String>();
        for (EntityNode currentNode = node; currentNode != null; currentNode = currentNode.getParent()) {
            if (visitedNode.contains(currentNode.getKey())) {
                throw new BillFormException("a circle in entity list was detected. entity lists is " + ((Object)visitedNode).toString());
            }
            el.setIdField(currentNode.getPkFieldName());
            visitedNode.add(currentNode.getKey());
        }
        return el;
    }

    private static class EntityNode {
        private String key;
        private String pkFieldName;
        private String parentKey;
        private EntityNode parent;
        private boolean hasChild = false;

        private EntityNode() {
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("{");
            sb.append("key=" + this.key);
            sb.append(",pkFieldName=" + this.pkFieldName);
            sb.append(",parentKey=" + this.parentKey);
            sb.append(",parent=" + this.parent);
            sb.append("}");
            return sb.toString();
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getPkFieldName() {
            return this.pkFieldName;
        }

        public void setPkFieldName(String pkFieldName) {
            this.pkFieldName = pkFieldName;
        }

        public String getParentKey() {
            return this.parentKey;
        }

        public void setParentKey(String parentKey) {
            this.parentKey = parentKey;
        }

        public EntityNode getParent() {
            return this.parent;
        }

        public void setParent(EntityNode parent) {
            this.parent = parent;
        }

        public boolean isHasChild() {
            return this.hasChild;
        }

        public void setHasChild(boolean hasChild) {
            this.hasChild = hasChild;
        }
    }
}

