/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.preparedata.model;

import com.kingdee.bos.qing.common.cache.AbstractDataSource;
import com.kingdee.bos.qing.datasource.meta.DSDimensionNecessary;
import com.kingdee.bos.qing.datasource.meta.DSMeta;
import com.kingdee.bos.qing.datasource.meta.DSMetaEntity;
import com.kingdee.bos.qing.datasource.meta.DSMetaProperty;
import com.kingdee.bos.qing.datasource.meta.DSParentChildDimension;
import com.kingdee.bos.qing.datasource.meta.DataType;
import com.kingdee.bos.qing.filesystem.manager.model.AbstractQingFileType;
import com.kingdee.bos.qing.preparedata.handler.controller.model.Field;
import com.kingdee.bos.qing.preparedata.handler.controller.model.ParentChildDimension;
import com.kingdee.bos.qing.preparedata.handler.controller.model.QingFieldType;
import com.kingdee.bos.qing.preparedata.handler.controller.model.QingMeta;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class BudgetDataSource
extends AbstractDataSource {
    private static final long serialVersionUID = 4087063616698484806L;
    private String bizTag;
    private List<String> files;
    private QingMeta qingMeta;
    private Map<String, List<String>> filter;
    private AbstractQingFileType storeFileType;

    public BudgetDataSource() {
    }

    public BudgetDataSource(String tag, AbstractQingFileType storeFileType) {
        super.setTag(tag);
        this.storeFileType = storeFileType;
    }

    public String getBizTag() {
        return this.bizTag;
    }

    public void setBizTag(String bizTag) {
        this.bizTag = bizTag;
    }

    public List<String> getFiles() {
        return this.files;
    }

    public void setFiles(List<String> files) {
        this.files = files;
    }

    public QingMeta getQingMeta() {
        return this.qingMeta;
    }

    public void setQingMeta(QingMeta qingMeta) {
        this.qingMeta = qingMeta;
    }

    public Map<String, List<String>> getFilter() {
        return this.filter;
    }

    public void setFilter(Map<String, List<String>> filter) {
        this.filter = filter;
    }

    public AbstractQingFileType getStoreFileType() {
        return this.storeFileType;
    }

    public void setStoreFileType(AbstractQingFileType storeFileType) {
        this.storeFileType = storeFileType;
    }

    public void updateMeta(DSMeta dsMeta) {
        if (this.qingMeta == null) {
            this.qingMeta = this.getQingMeta();
        }
        if (this.qingMeta.getParentChildDimensions().size() <= 0) {
            return;
        }
        ArrayList<DSMetaProperty> properties = new ArrayList<DSMetaProperty>();
        List<Field> fields = this.qingMeta.getColumns();
        if (fields != null && fields.size() > 0) {
            for (Field field : fields) {
                int fieldType = field.getFieldType();
                DataType dataType = null;
                dataType = QingFieldType.Number.toNumber() == fieldType ? DataType.NUMBER : (QingFieldType.Date.toNumber() == fieldType ? DataType.DATE : DataType.STRING);
                DSMetaProperty property = new DSMetaProperty(field.getName(), field.getAlias(), dataType, null, Boolean.valueOf(field.isHide()));
                properties.add(property);
            }
        }
        ArrayList<DSParentChildDimension> newParentChildDimensions = new ArrayList<DSParentChildDimension>();
        List<ParentChildDimension> parentChildDimensions = this.qingMeta.getParentChildDimensions();
        if (parentChildDimensions != null && parentChildDimensions.size() > 0) {
            for (ParentChildDimension parentChildDimension : parentChildDimensions) {
                DSParentChildDimension newParentChildDimension = new DSParentChildDimension();
                newParentChildDimension.setName(parentChildDimension.getName());
                newParentChildDimension.setAlias(parentChildDimension.getAlias());
                newParentChildDimension.setIdFieldName(parentChildDimension.getId().getName());
                newParentChildDimension.setParentIdFieldName(parentChildDimension.getParentId().getName());
                if (parentChildDimension.getDefaultDisplayName() != null) {
                    newParentChildDimension.setDisplayFieldName(parentChildDimension.getDefaultDisplayName().getName());
                }
                if (parentChildDimension.getSortAccording() != null) {
                    newParentChildDimension.setSortAccordingFieldName(parentChildDimension.getSortAccording().getName());
                }
                if (parentChildDimension.getNecessary() != null) {
                    DSDimensionNecessary dimensionNecessity = null;
                    ParentChildDimension.Necessary necessary = parentChildDimension.getNecessary();
                    if (ParentChildDimension.Necessary.Indispensable.equals((Object)necessary)) {
                        dimensionNecessity = DSDimensionNecessary.Indispensable;
                    } else if (ParentChildDimension.Necessary.RootRepresented.equals((Object)necessary)) {
                        dimensionNecessity = DSDimensionNecessary.RootRepresented;
                    }
                    newParentChildDimension.setNecessary(dimensionNecessity);
                }
                newParentChildDimensions.add(newParentChildDimension);
            }
        }
        ArrayList<DSMetaEntity> entities = new ArrayList<DSMetaEntity>();
        DSMetaEntity dsMetaEntity = DSMetaEntity.createInstanceForSingleMode(properties);
        dsMetaEntity.setParentChildDimensions(newParentChildDimensions);
        entities.add(dsMetaEntity);
        dsMeta.setEntities(entities);
    }

    public boolean supportPublishWithCarryData() {
        return false;
    }
}

