/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.preparedata.model;

import com.kingdee.bos.qing.common.cache.AbstractDataSource;
import com.kingdee.bos.qing.common.cache.SingleFileDataSource;
import com.kingdee.bos.qing.datasource.meta.DSDimensionNecessary;
import com.kingdee.bos.qing.datasource.meta.DSMeta;
import com.kingdee.bos.qing.datasource.meta.DSMetaEntity;
import com.kingdee.bos.qing.datasource.meta.DSMetaProperty;
import com.kingdee.bos.qing.datasource.meta.DSParentChildDimension;
import com.kingdee.bos.qing.datasource.meta.DataType;
import com.kingdee.bos.qing.filesystem.manager.model.AbstractQingFileType;
import com.kingdee.bos.qing.preparedata.handler.controller.model.Field;
import com.kingdee.bos.qing.preparedata.handler.controller.model.ParentChildDimension;
import com.kingdee.bos.qing.preparedata.handler.controller.model.QingFieldType;
import com.kingdee.bos.qing.preparedata.handler.controller.model.QingMeta;
import com.kingdee.bos.qing.preparedata.model.BudgetDataSource;
import com.kingdee.bos.qing.util.JsonUtil;
import java.util.ArrayList;
import java.util.List;

public class ControllerDataSource
extends SingleFileDataSource {
    private static final long serialVersionUID = -1450295059291786370L;
    private String bizTag;
    private QingMeta qingMeta;

    public ControllerDataSource() {
    }

    public ControllerDataSource(String tag, AbstractQingFileType storeFileType, String path, String bizTag) {
        super(path, storeFileType);
        super.setTag(tag);
        this.bizTag = bizTag;
    }

    public String getBizTag() {
        return this.bizTag;
    }

    public QingMeta getQingMeta() {
        return this.qingMeta;
    }

    public void setQingMeta(QingMeta qingMeta) {
        this.qingMeta = qingMeta;
    }

    public void updateMeta(DSMeta dsMeta) {
        if (this.qingMeta == null) {
            this.qingMeta = this.getQingMeta();
        }
        if (this.qingMeta.getParentChildDimensions().size() <= 0) {
            return;
        }
        ArrayList<DSMetaProperty> properties = new ArrayList<DSMetaProperty>();
        List<Field> fields = this.qingMeta.getColumns();
        if (fields != null && fields.size() > 0) {
            for (Field field : fields) {
                int fieldType = field.getFieldType();
                DataType dataType = null;
                dataType = QingFieldType.Number.toNumber() == fieldType ? DataType.NUMBER : (QingFieldType.Date.toNumber() == fieldType ? DataType.DATE : DataType.STRING);
                DSMetaProperty property = new DSMetaProperty(field.getName(), field.getAlias(), dataType, null, Boolean.valueOf(field.isHide()));
                properties.add(property);
            }
        }
        ArrayList<DSParentChildDimension> newParentChildDimensions = new ArrayList<DSParentChildDimension>();
        List<ParentChildDimension> parentChildDimensions = this.qingMeta.getParentChildDimensions();
        if (parentChildDimensions != null && parentChildDimensions.size() > 0) {
            for (ParentChildDimension parentChildDimension : parentChildDimensions) {
                DSParentChildDimension newParentChildDimension = new DSParentChildDimension();
                newParentChildDimension.setName(parentChildDimension.getName());
                newParentChildDimension.setAlias(parentChildDimension.getAlias());
                newParentChildDimension.setIdFieldName(parentChildDimension.getId().getName());
                newParentChildDimension.setParentIdFieldName(parentChildDimension.getParentId().getName());
                if (parentChildDimension.getDefaultDisplayName() != null) {
                    newParentChildDimension.setDisplayFieldName(parentChildDimension.getDefaultDisplayName().getName());
                }
                if (parentChildDimension.getSortAccording() != null) {
                    newParentChildDimension.setSortAccordingFieldName(parentChildDimension.getSortAccording().getName());
                }
                if (parentChildDimension.getNecessary() != null) {
                    DSDimensionNecessary dimensionNecessity = null;
                    ParentChildDimension.Necessary necessary = parentChildDimension.getNecessary();
                    if (ParentChildDimension.Necessary.Indispensable.equals((Object)necessary)) {
                        dimensionNecessity = DSDimensionNecessary.Indispensable;
                    } else if (ParentChildDimension.Necessary.RootRepresented.equals((Object)necessary)) {
                        dimensionNecessity = DSDimensionNecessary.RootRepresented;
                    }
                    newParentChildDimension.setNecessary(dimensionNecessity);
                }
                newParentChildDimensions.add(newParentChildDimension);
            }
        }
        ArrayList<DSMetaEntity> entities = new ArrayList<DSMetaEntity>();
        DSMetaEntity dsMetaEntity = DSMetaEntity.createInstanceForSingleMode(properties);
        dsMetaEntity.setParentChildDimensions(newParentChildDimensions);
        entities.add(dsMetaEntity);
        dsMeta.setEntities(entities);
    }

    public boolean supportPublishWithCarryData() {
        return false;
    }

    public static class ControllerDataSourceJsonDecoder
    extends AbstractDataSource.AbstractDataSourceJsonDecoder {
        protected AbstractDataSource doOtherDecode(JsonUtil.AbstractJsonDecoder.Json json) {
            if (json.hasAttr("files")) {
                return (AbstractDataSource)this.fromJson(json, BudgetDataSource.class);
            }
            return (AbstractDataSource)this.fromJson(json, ControllerDataSource.class);
        }
    }
}

