/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.programablecard;

import com.kingdee.bos.qing.common.context.IQingContextable;
import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBAccessable;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.programablecard.domain.ProgramableCardDomain;
import com.kingdee.bos.qing.response.IResponseWrap;
import com.kingdee.bos.qing.response.ResponseErrorWrap;
import com.kingdee.bos.qing.response.ResponseSuccessWrap;
import com.kingdee.bos.qing.response.ResponseUtil;
import java.sql.SQLException;
import java.util.Map;

public class ProgramableCardService
implements IQingContextable,
IDBAccessable {
    private ProgramableCardDomain cardDomain;
    private IDBExcuter dbExcuter;
    private QingContext qingContext;
    private ITransactionManagement tx;

    public void setQingContext(QingContext qingContext) {
        this.qingContext = qingContext;
    }

    public void setTx(ITransactionManagement tx) {
        this.tx = tx;
    }

    public void setDbExcuter(IDBExcuter dbExcuter) {
        this.dbExcuter = dbExcuter;
    }

    private ProgramableCardDomain getCardDomain() {
        if (this.cardDomain == null) {
            this.cardDomain = new ProgramableCardDomain(this.dbExcuter, this.tx, this.qingContext);
        }
        return this.cardDomain;
    }

    public byte[] getRefChartId(Map<String, String> params) {
        String dsbId = params.get("dsbId");
        String refUid = params.get("refUid");
        try {
            return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap((Object)this.getCardDomain().getRefChartId(dsbId, refUid)));
        }
        catch (AbstractQingIntegratedException e) {
            return ResponseUtil.output((IResponseWrap)new ResponseErrorWrap((Throwable)e));
        }
        catch (SQLException e) {
            return ResponseUtil.output((IResponseWrap)new ResponseErrorWrap(e.getErrorCode(), e.getMessage()));
        }
    }

    public byte[] getChartId(Map<String, String> params) {
        String themeId = params.get("themeId");
        try {
            String chartId = this.getCardDomain().getChartId(themeId);
            return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap((Object)chartId));
        }
        catch (AbstractQingIntegratedException e) {
            return ResponseUtil.output((IResponseWrap)new ResponseErrorWrap((Throwable)e));
        }
        catch (SQLException e) {
            return ResponseUtil.output((IResponseWrap)new ResponseErrorWrap(e.getErrorCode(), e.getMessage()));
        }
    }

    public byte[] getRuntimeChartId(Map<String, String> params) {
        String publishId = params.get("publishId");
        String refUid = params.get("refUid");
        String userId = this.qingContext.getUserId();
        try {
            return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap((Object)this.getCardDomain().getRuntimeChartId(publishId, refUid, userId)));
        }
        catch (AbstractQingIntegratedException e) {
            return ResponseUtil.output((IResponseWrap)new ResponseErrorWrap((Throwable)e));
        }
        catch (SQLException e) {
            return ResponseUtil.output((IResponseWrap)new ResponseErrorWrap(e.getErrorCode(), e.getMessage()));
        }
    }
}

