/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.programablecard.dao;

import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ResultHandler;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.programablecard.model.ProgramableCard;
import com.kingdee.bos.qing.programablecard.model.ProgramableCardPubRef;
import com.kingdee.bos.qing.programablecard.model.ProgramableCardRef;
import com.kingdee.util.Uuid;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class ProgramableCardDao {
    private IDBExcuter dbExcuter;

    public ProgramableCardDao(IDBExcuter dbExcuter) {
        this.dbExcuter = dbExcuter;
    }

    public void saveChartInfo(String themeId, String chartId) throws AbstractQingIntegratedException, SQLException {
        String uuid = Uuid.randomUUID().toString();
        String sql = "INSERT INTO T_QING_EXTCARD (FID, FTHEMEID, FCHARTID, FCREATETIME) VALUES (?,?,?,?)";
        Object[] params = new Object[4];
        int i = 0;
        Date date = new Date();
        params[i++] = uuid;
        params[i++] = themeId;
        params[i++] = chartId;
        params[i++] = date;
        this.dbExcuter.execute(sql, params);
    }

    public void saveChartRefInfo(String chartId, String refUid, String dsbId) throws AbstractQingIntegratedException, SQLException {
        String sql = "INSERT INTO T_QING_DSB_REF_EXTCARD (FID, FCHARTID, FREFUID, FDSBID) VALUES (?,?,?,?)";
        String uuid = Uuid.randomUUID().toString();
        Object[] params = new Object[4];
        int i = 0;
        params[i++] = uuid;
        params[i++] = chartId;
        params[i++] = refUid;
        params[i++] = dsbId;
        this.dbExcuter.execute(sql, params);
    }

    public void savePublishChartRefInfo(String chartId, String refUid, String publishId) throws AbstractQingIntegratedException, SQLException {
        String sql = "INSERT INTO T_QING_PUB_DSB_REF_EXTCARD (FID, FREFUID, FPUBLISHID, FCHARTID) VALUES (?,?,?,?)";
        String uuid = Uuid.randomUUID().toString();
        Object[] params = new Object[4];
        int i = 0;
        params[i++] = uuid;
        params[i++] = refUid;
        params[i++] = publishId;
        params[i++] = chartId;
        this.dbExcuter.execute(sql, params);
    }

    public void saveUserBindPubChartRefInfo(String chartId, String refUid, String publishId, String userId) throws AbstractQingIntegratedException, SQLException {
        String sql = "INSERT INTO T_QING_PUB_DSB_REF_EXTCARD_U (FID, FREFUID, FPUBLISHID, FCHARTID, FUSERID) VALUES (?,?,?,?,?)";
        String uuid = Uuid.randomUUID().toString();
        Object[] params = new Object[5];
        int i = 0;
        params[i++] = uuid;
        params[i++] = refUid;
        params[i++] = publishId;
        params[i++] = chartId;
        params[i++] = userId;
        this.dbExcuter.execute(sql, params);
    }

    public void deleteChartInfo(String chartId) throws AbstractQingIntegratedException, SQLException {
        String sql = "DELETE FROM T_QING_EXTCARD WHERE FCHARTID = ?";
        Object[] param = new Object[]{chartId};
        this.dbExcuter.execute(sql, param);
    }

    public void deleteChartRefInfo(String dsbId, String refUid) throws AbstractQingIntegratedException, SQLException {
        String sql = "DELETE FROM T_QING_DSB_REF_EXTCARD WHERE FDSBID=? AND FREFUID=?";
        Object[] params = new Object[]{dsbId, refUid};
        this.dbExcuter.execute(sql, params);
    }

    public void deletePublishChartRefInfo(String publishId) throws AbstractQingIntegratedException, SQLException {
        Object[] param = new Object[]{publishId};
        this.dbExcuter.execute("DELETE FROM T_QING_PUB_DSB_REF_EXTCARD WHERE FPUBLISHID=?", param);
        this.dbExcuter.execute("DELETE FROM T_QING_PUB_DSB_REF_EXTCARD_U WHERE FPUBLISHID=? ", param);
    }

    public ProgramableCard loadChartInfo(String themeId) throws AbstractQingIntegratedException, SQLException {
        String sql = "SELECT FCHARTID, FTHEMEID FROM T_QING_EXTCARD WHERE FTHEMEID=?";
        return (ProgramableCard)this.dbExcuter.query(sql, new Object[]{themeId}, (ResultHandler)new ResultHandler<ProgramableCard>(){

            public ProgramableCard handle(ResultSet rs) throws SQLException {
                if (rs.next()) {
                    ProgramableCard programCard = new ProgramableCard();
                    String chartId = rs.getString("FCHARTID");
                    programCard.setChartId(chartId);
                    programCard.setThemeId(rs.getString("FTHEMEID"));
                    return programCard;
                }
                return null;
            }
        });
    }

    public ProgramableCardRef loadChartRefInfo(String dsbId, String refUid) throws AbstractQingIntegratedException, SQLException {
        String sql = "SELECT FID, FCHARTID, FREFUID, FDSBID FROM T_QING_DSB_REF_EXTCARD WHERE FREFUID=? AND FDSBID=?";
        Object[] params = new Object[]{refUid, dsbId};
        return (ProgramableCardRef)this.dbExcuter.query(sql, params, (ResultHandler)new ResultHandler<ProgramableCardRef>(){

            public ProgramableCardRef handle(ResultSet rs) throws SQLException {
                ProgramableCardRef refModel = new ProgramableCardRef();
                if (rs.next()) {
                    refModel.setChartId(rs.getString("FCHARTID"));
                    refModel.setDsbId(rs.getString("FDSBID"));
                    refModel.setRefUid(rs.getString("FREFUID"));
                }
                return refModel;
            }
        });
    }

    public ProgramableCardPubRef loadPublishChartRefInfo(String publishId, String refUid) throws AbstractQingIntegratedException, SQLException {
        String sql = "SELECT FCHARTID, FREFUID, FPUBLISHID FROM T_QING_PUB_DSB_REF_EXTCARD WHERE FREFUID=? AND FPUBLISHID=?";
        Object[] params = new Object[]{refUid, publishId};
        return (ProgramableCardPubRef)this.dbExcuter.query(sql, params, (ResultHandler)new ResultHandler<ProgramableCardPubRef>(){

            public ProgramableCardPubRef handle(ResultSet rs) throws SQLException {
                ProgramableCardPubRef refModel = new ProgramableCardPubRef();
                if (rs.next()) {
                    refModel.setChartId(rs.getString("FCHARTID"));
                    refModel.setPublishId(rs.getString("FPUBLISHID"));
                    refModel.setRefUid(rs.getString("FREFUID"));
                }
                return refModel;
            }
        });
    }

    public ProgramableCardPubRef loadUserBindPubChartRefInfo(String publishId, String refUid, String userId) throws AbstractQingIntegratedException, SQLException {
        String sql = "SELECT FCHARTID, FREFUID, FPUBLISHID FROM T_QING_PUB_DSB_REF_EXTCARD_U WHERE FREFUID=? AND FPUBLISHID=? AND FUSERID=?";
        Object[] params = new Object[]{refUid, publishId, userId};
        return (ProgramableCardPubRef)this.dbExcuter.query(sql, params, (ResultHandler)new ResultHandler<ProgramableCardPubRef>(){

            public ProgramableCardPubRef handle(ResultSet rs) throws SQLException {
                if (rs.next()) {
                    ProgramableCardPubRef refModel = new ProgramableCardPubRef();
                    refModel.setChartId(rs.getString("FCHARTID"));
                    refModel.setPublishId(rs.getString("FPUBLISHID"));
                    refModel.setRefUid(rs.getString("FREFUID"));
                    return refModel;
                }
                return null;
            }
        });
    }

    public List<ProgramableCardPubRef> loadAllPubChartRefInfo(String publishId) throws AbstractQingIntegratedException, SQLException {
        Object[] param = new Object[]{publishId};
        String sql = "SELECT FCHARTID, FREFUID, FPUBLISHID FROM T_QING_PUB_DSB_REF_EXTCARD WHERE FPUBLISHID=?";
        List refInfos = (List)this.dbExcuter.query(sql, param, (ResultHandler)new ResultHandler<List<ProgramableCardPubRef>>(){

            public List<ProgramableCardPubRef> handle(ResultSet rs) throws SQLException {
                ArrayList<ProgramableCardPubRef> pubRefs = new ArrayList<ProgramableCardPubRef>();
                while (rs.next()) {
                    ProgramableCardPubRef refModel = new ProgramableCardPubRef();
                    refModel.setChartId(rs.getString("FCHARTID"));
                    refModel.setPublishId(rs.getString("FPUBLISHID"));
                    refModel.setRefUid(rs.getString("FREFUID"));
                    pubRefs.add(refModel);
                }
                return pubRefs;
            }
        });
        sql = "SELECT FCHARTID, FREFUID, FPUBLISHID FROM T_QING_PUB_DSB_REF_EXTCARD_U WHERE FPUBLISHID=?";
        List refInfos_u = (List)this.dbExcuter.query(sql, param, (ResultHandler)new ResultHandler<List<ProgramableCardPubRef>>(){

            public List<ProgramableCardPubRef> handle(ResultSet rs) throws SQLException {
                ArrayList<ProgramableCardPubRef> pubRefs = new ArrayList<ProgramableCardPubRef>();
                while (rs.next()) {
                    ProgramableCardPubRef refModel = new ProgramableCardPubRef();
                    refModel.setChartId(rs.getString("FCHARTID"));
                    refModel.setPublishId(rs.getString("FPUBLISHID"));
                    refModel.setRefUid(rs.getString("FREFUID"));
                    pubRefs.add(refModel);
                }
                return pubRefs;
            }
        });
        refInfos.addAll(refInfos_u);
        return refInfos;
    }
}

