/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.publish.appmenu.dao;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.context.QingIntegratedContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ResultHandler;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.common.exception.IntegratedRuntimeException;
import com.kingdee.bos.qing.publish.appmenu.portal.PortalFacade;
import com.kingdee.bos.qing.publish.integrated.model.TreeMenuFolderNode;
import com.kingdee.bos.qing.publish.integrated.model.TreeMenuLeafNode;
import com.kingdee.bos.qing.publish.model.PublishPO;
import com.kingdee.bos.qing.publish.model.PublishSourceEnum;
import com.kingdee.bos.qing.publish.model.PublishVO;
import com.kingdee.bos.qing.util.IntegratedHelper;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.portal.biz.common.context.PortalContext;
import com.kingdee.portal.biz.common.exception.PortalBizException;
import com.kingdee.portal.biz.common.util.PortalServiceLocator;
import com.kingdee.portal.biz.core.datacenter.DSObserver;
import com.kingdee.portal.biz.module.page.entity.Page;
import com.kingdee.portal.biz.module.page.service.PageService;
import com.kingdee.portal.biz.module.perm.entity.User;
import com.kingdee.util.LocaleUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AppMenuDao {
    public static final String PUBLISH_URL = "/easweb/bos/qing/publish/analysis.do";
    public static final String EAS_APP_CENTER_ROOT_UUID = "2b7f4215-aa17-4d89-952e-efc97833cee6";
    public static final String EAS_PORTAL_ROOT_UUID = "2f9ef722-255b-4e4b-8d07-5277e353a321";
    private QingContext qingContext;
    private IDBExcuter dbExcuter;
    private static Map<String, TreeMenuFolderNode> ROOTNODE_MAP = new HashMap<String, TreeMenuFolderNode>();

    public AppMenuDao(QingContext qingContext, IDBExcuter dbExcuter) {
        this.qingContext = qingContext;
        this.dbExcuter = dbExcuter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TreeMenuFolderNode getAppMenuTree(boolean isRefresh) throws SQLException {
        Map<String, TreeMenuFolderNode> map = ROOTNODE_MAP;
        synchronized (map) {
            if (!isRefresh && ROOTNODE_MAP.get(this.qingContext.getAccountId()) != null) {
                return ROOTNODE_MAP.get(this.qingContext.getAccountId());
            }
            QingIntegratedContext qingIntegratedContext = (QingIntegratedContext)this.qingContext;
            Context ctx = qingIntegratedContext.getBosContext();
            PageService pageService = (PageService)PortalServiceLocator.getBean((String)"pageService");
            PortalContext portalContext = new PortalContext();
            portalContext.setIp(ctx.getClientHostIP());
            portalContext.setLocale(ctx.getLocale());
            UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
            User loginUser = new User();
            loginUser.setId(userInfo.getId().toString());
            portalContext.setLoginUser(loginUser);
            portalContext.getMetaInfo().put("eas_context", ctx);
            HashMap<String, TreeMenuFolderNode> parentNodeMap = new HashMap<String, TreeMenuFolderNode>();
            TreeMenuFolderNode appCenterRootNode = new TreeMenuFolderNode();
            appCenterRootNode.setName(EAS_APP_CENTER_ROOT_UUID);
            appCenterRootNode.setDisplayName("\u95e8\u6237\u5e94\u7528\u4e2d\u5fc3");
            parentNodeMap.put(EAS_APP_CENTER_ROOT_UUID, appCenterRootNode);
            DSObserver.putDSName((String)ctx.getAIS());
            try {
                List pageList = pageService.findAppCenterList(portalContext, EAS_APP_CENTER_ROOT_UUID, null);
                this.buildMenuTree(pageList, ctx, parentNodeMap);
                ROOTNODE_MAP.put(this.qingContext.getAccountId(), appCenterRootNode);
            }
            catch (PortalBizException e) {
                throw new SQLException("load app center tree failed.", e);
            }
            return appCenterRootNode;
        }
    }

    private void buildMenuTree(List<Page> pageList, Context ctx, Map<String, TreeMenuFolderNode> parentNodeMap) {
        boolean isLeaf = false;
        String lang = ctx.getOriginLocale().toString();
        for (Page page : pageList) {
            String parentNodeId;
            TreeMenuFolderNode parentNode;
            JSONObject jo;
            String jsonString = page.getNodeExt();
            if (!StringUtil.isEmptyString((String)jsonString)) {
                JSONObject jo2 = JSONObject.parseObject((String)jsonString);
                isLeaf = jo2.containsKey((Object)"leaf") ? jo2.getBooleanValue("leaf") : true;
            }
            Boolean isHidden = page.getHidden();
            if (isLeaf || isHidden != null && isHidden.booleanValue() || page.getNodeLevel() > 4) continue;
            String displayName = page.getDisplayName();
            if (!StringUtil.isEmptyString((String)displayName) && StringUtil.isEmptyString((String)(displayName = (jo = JSONObject.parseObject((String)displayName)).getString(lang)))) {
                if (lang.startsWith(LocaleUtils.locale_en.toString() + "_")) {
                    displayName = jo.getString(LocaleUtils.locale_en.toString());
                }
                if (StringUtil.isEmptyString((String)displayName)) {
                    displayName = jo.getString("zh_CN".toString());
                }
            }
            if ((parentNode = parentNodeMap.get(parentNodeId = page.getParentNodeId())) == null) {
                parentNode = new TreeMenuFolderNode();
                parentNode.setName(parentNodeId);
                parentNodeMap.put(parentNodeId, parentNode);
            }
            if (page.getNodeLevel() == 4) {
                TreeMenuLeafNode TreeMenuLeafNode2 = new TreeMenuLeafNode();
                TreeMenuLeafNode2.setName(page.getId());
                TreeMenuLeafNode2.setDisplayName(displayName);
                TreeMenuLeafNode2.setType("leaf");
                parentNode.addChild(TreeMenuLeafNode2);
                continue;
            }
            TreeMenuFolderNode fNode = new TreeMenuFolderNode();
            fNode.setName(page.getId());
            fNode.setDisplayName(displayName);
            parentNode.addChild(fNode);
            parentNodeMap.put(page.getId(), fNode);
        }
    }

    public void saveAppMenu(String publishId, String publishName, String publishPath) throws SQLException, AbstractQingIntegratedException {
        JSONObject jo = new JSONObject();
        JSONObject displayName = new JSONObject();
        displayName.put("zh_TW", (Object)publishName);
        displayName.put("zh_CN", (Object)publishName);
        displayName.put("en", (Object)publishName);
        jo.put("displayName", (Object)displayName.toString());
        String menuEntranceUrl = PUBLISH_URL;
        jo.put("url", (Object)(menuEntranceUrl + "?publishId=" + publishId));
        String[] paths = publishPath.split("/");
        String appCenterParentId = paths[paths.length - 1];
        String appCenterId = null;
        String menuItemId = null;
        try {
            QingIntegratedContext qingIntegratedContext = (QingIntegratedContext)this.qingContext;
            Context easCtx = qingIntegratedContext.getBosContext();
            String pageJson = PortalFacade.savePageToPortal(easCtx, jo.toString(), appCenterParentId);
            jo = JSONObject.parseObject((String)pageJson);
            if (!jo.getBooleanValue("success")) {
                throw new SQLException("save portal page failed.");
            }
            JSONObject deployPage = jo.getJSONArray("result").getJSONObject(0);
            appCenterId = deployPage.getString("id");
            menuItemId = deployPage.getJSONObject("nodeExt").getString("externalId");
        }
        catch (Throwable e) {
            if (e instanceof SQLException) {
                throw (SQLException)e;
            }
            throw new SQLException("save portal page failed.", e);
        }
        this.dbExcuter.execute("INSERT INTO T_QING_PUBLISH_APPMENU(FPUBLISHID,FAPPCENTERID, FMENUITEMID) VALUES (?,?,?)", new Object[]{publishId, appCenterId, menuItemId});
        this.dbExcuter.execute("UPDATE T_PM_MAINMENUITEM SET FUICLASSNAME=? WHERE FID=?", new Object[]{menuEntranceUrl, menuItemId});
    }

    public void deleteAppMenu(String publishId) throws SQLException, AbstractQingIntegratedException {
        String[] appMenuInfo = this.getAppMenuInfo(publishId);
        if (appMenuInfo != null) {
            String sqlDelMenuItem = "DELETE T_PM_MAINMENUITEM WHERE FID=?";
            this.dbExcuter.execute(sqlDelMenuItem, new Object[]{appMenuInfo[1]});
            QingIntegratedContext qingIntegratedContext = (QingIntegratedContext)this.qingContext;
            Context easCtx = qingIntegratedContext.getBosContext();
            try {
                PortalFacade.deletePageFromPortal(easCtx, appMenuInfo[0]);
            }
            catch (PortalBizException e) {
                throw new SQLException("delete portal page failed.");
            }
            String sqlDelAppMenuItem = "DELETE T_QING_PUBLISH_APPMENU WHERE FPUBLISHID=?";
            this.dbExcuter.execute(sqlDelAppMenuItem, new Object[]{publishId});
        }
    }

    private String[] getAppMenuInfo(String publishId) throws AbstractQingIntegratedException, SQLException {
        String sql = "SELECT FAPPCENTERID, FMENUITEMID FROM T_QING_PUBLISH_APPMENU where FPUBLISHID = ?";
        return (String[])this.dbExcuter.query(sql, new Object[]{publishId}, (ResultHandler)new ResultHandler<String[]>(){

            public String[] handle(ResultSet rs) throws SQLException {
                if (rs.next()) {
                    String[] result = new String[]{rs.getString("FAPPCENTERID"), rs.getString("FMENUITEMID")};
                    return result;
                }
                return null;
            }
        });
    }

    private void updateMenuName(String[] appMenuInfo, PublishPO publishPO) throws AbstractQingIntegratedException, SQLException {
        String name = publishPO.getName();
        JSONObject displayName = new JSONObject();
        displayName.put("zh_TW", (Object)name);
        displayName.put("zh_CN", (Object)name);
        displayName.put("en", (Object)name);
        ArrayList<Object> paramsPortal = new ArrayList<Object>();
        StringBuilder sqlUpdatePortal = new StringBuilder("UPDATE T_JP_PAGE SET FLASTUPDATETIME=? , FDISPLAYNAME=? WHERE FID= ?");
        paramsPortal.add(publishPO.getUpdateTime());
        paramsPortal.add(displayName.toJSONString());
        paramsPortal.add(appMenuInfo[0]);
        this.dbExcuter.execute(sqlUpdatePortal.toString(), paramsPortal.toArray());
        this.dbExcuter.execute("UPDATE T_PM_MainMenuItem SET FNAME_L2 = ? WHERE FID=?", new Object[]{publishPO.getName(), appMenuInfo[1]});
    }

    private void updatePath(String[] appMenuInfo, PublishPO publishPO) throws AbstractQingIntegratedException, SQLException {
        ArrayList<Object> paramsPortal = new ArrayList<Object>();
        StringBuilder sqlUpdatePortal = new StringBuilder("UPDATE T_JP_PAGE SET FLASTUPDATETIME=? , FNODEPATH=?, FPARENTNODEID=?  WHERE FID= ?");
        paramsPortal.add(publishPO.getUpdateTime());
        String path = publishPO.getPath();
        paramsPortal.add("/2f9ef722-255b-4e4b-8d07-5277e353a321" + publishPO.getPath() + "/" + appMenuInfo[0]);
        String[] paths = path.split("/");
        paramsPortal.add(paths[paths.length - 1]);
        paramsPortal.add(appMenuInfo[0]);
        this.dbExcuter.execute(sqlUpdatePortal.toString(), paramsPortal.toArray());
    }

    public void updateAppMenu(int updateType, PublishPO publishPO) throws SQLException, AbstractQingIntegratedException {
        String[] appMenuInfo = this.getAppMenuInfo(publishPO.getId());
        if (appMenuInfo != null) {
            switch (updateType) {
                case 0: {
                    this.updateMenuName(appMenuInfo, publishPO);
                    break;
                }
                case 1: {
                    this.updatePath(appMenuInfo, publishPO);
                    break;
                }
                case 6: 
                case 7: {
                    this.updateMenuName(appMenuInfo, publishPO);
                    this.updatePath(appMenuInfo, publishPO);
                }
            }
        }
    }

    public List<PublishVO> loadAllPublishInfos(final String userId) throws SQLException, AbstractQingIntegratedException {
        StringBuilder sqlSelect = new StringBuilder();
        sqlSelect.append("select p.fid, p.ftype, p.fsource, p.fname, p.fpath,  p.fcreatetime, p.fupdatetime, p.fschemaid , p.fanalysis, p.ftagid, p.fcarrydata, theme.fname as themeName, TQTG.fname as themeGroupName");
        sqlSelect.append(" from T_QING_PUBLISH p left join T_QING_Theme theme on theme.fid = p.ftagid left join t_qing_theme_group tqtg on tqtg.fid = theme.fthemegroupid where p.ftype=? and p.fcreatorId=? order by p.fcreatetime desc");
        Object[] params = new Object[]{0, userId};
        return (List)this.dbExcuter.query(sqlSelect.toString(), params, (ResultHandler)new ResultHandler<List<PublishVO>>(){

            public List<PublishVO> handle(ResultSet rs) throws SQLException {
                ArrayList<PublishVO> listVO = new ArrayList<PublishVO>();
                PublishVO vo = null;
                while (rs.next()) {
                    String fid = rs.getString("fid");
                    if (vo != null && fid.equals(vo.getId())) continue;
                    vo = new PublishVO();
                    vo.setId(fid);
                    vo.setPublishTargetType(rs.getInt("ftype"));
                    vo.setName(rs.getString("fname"));
                    vo.setPath(rs.getString("fpath"));
                    vo.setSchemaId(rs.getString("fschemaid"));
                    vo.setCanAnalysis(rs.getBoolean("fanalysis"));
                    String publishSourceType = rs.getString("fsource");
                    vo.setPublishSourceType(publishSourceType);
                    if (PublishSourceEnum.bill.name().equals(publishSourceType) || PublishSourceEnum.control.name().equals(publishSourceType)) {
                        try {
                            vo.setPublishSourceName(IntegratedHelper.queryFormDisplayName((String)rs.getString("ftagid"), (String)publishSourceType, (QingContext)AppMenuDao.this.qingContext, (IDBExcuter)AppMenuDao.this.dbExcuter));
                            vo.setPublishSourceGroupName(IntegratedHelper.queryFormFullPath((String)rs.getString("FTAGID"), (String)publishSourceType, (QingContext)AppMenuDao.this.qingContext));
                        }
                        catch (IntegratedRuntimeException e) {
                            throw new SQLException(e);
                        }
                    } else {
                        vo.setPublishSourceName(rs.getString("themeName"));
                        vo.setPublishSourceGroupName(rs.getString("themeGroupName"));
                    }
                    vo.setTagId(rs.getString("ftagid"));
                    vo.setCarryData(rs.getBoolean("fcarrydata"));
                    vo.setCreateTime(Long.valueOf(rs.getTimestamp("fcreatetime").getTime()));
                    vo.setUpdateTime(Long.valueOf(rs.getTimestamp("fupdatetime").getTime()));
                    vo.setPreset(IntegratedHelper.getPresetUserId().equals(userId));
                    listVO.add(vo);
                }
                return listVO;
            }
        });
    }

    public List<PublishVO> loadPublishInfos(final String userId, String path) throws SQLException, AbstractQingIntegratedException {
        StringBuilder sqlSelect = new StringBuilder();
        sqlSelect.append("select p.fid, p.ftype, p.fsource, p.fname, p.fpath,  p.fcreatetime, p.fupdatetime, p.fschemaid , p.fanalysis, p.ftagid, p.fcarrydata, theme.fname as themeName, TQTG.fname as themeGroupName");
        sqlSelect.append(" from T_QING_PUBLISH p left join T_QING_Theme theme on theme.fid = p.ftagid left join t_qing_theme_group tqtg on tqtg.fid = theme.fthemegroupid where p.ftype=? and p.fcreatorId=? and p.fpath = ? order by p.fcreatetime");
        Object[] params = new Object[]{0, userId, path};
        return (List)this.dbExcuter.query(sqlSelect.toString(), params, (ResultHandler)new ResultHandler<List<PublishVO>>(){

            public List<PublishVO> handle(ResultSet rs) throws SQLException {
                ArrayList<PublishVO> listVO = new ArrayList<PublishVO>();
                PublishVO vo = null;
                while (rs.next()) {
                    String fid = rs.getString("fid");
                    if (vo != null && fid.equals(vo.getId())) continue;
                    vo = new PublishVO();
                    vo.setId(fid);
                    vo.setPublishTargetType(rs.getInt("ftype"));
                    vo.setName(rs.getString("fname"));
                    vo.setPath(rs.getString("fpath"));
                    vo.setSchemaId(rs.getString("fschemaid"));
                    vo.setCanAnalysis(rs.getBoolean("fanalysis"));
                    String publishSourceType = rs.getString("fsource");
                    vo.setPublishSourceType(publishSourceType);
                    if (PublishSourceEnum.bill.name().equals(publishSourceType) || PublishSourceEnum.control.name().equals(publishSourceType)) {
                        try {
                            vo.setPublishSourceName(IntegratedHelper.queryFormDisplayName((String)rs.getString("ftagid"), (String)publishSourceType, (QingContext)AppMenuDao.this.qingContext, (IDBExcuter)AppMenuDao.this.dbExcuter));
                            vo.setPublishSourceGroupName(IntegratedHelper.queryFormFullPath((String)rs.getString("ftagid"), (String)publishSourceType, (QingContext)AppMenuDao.this.qingContext));
                        }
                        catch (IntegratedRuntimeException e) {
                            throw new SQLException(e);
                        }
                    } else {
                        vo.setPublishSourceName(rs.getString("themeName"));
                        vo.setPublishSourceGroupName(rs.getString("themeGroupName"));
                    }
                    vo.setTagId(rs.getString("ftagid"));
                    vo.setCarryData(rs.getBoolean("fcarrydata"));
                    vo.setCreateTime(Long.valueOf(rs.getTimestamp("fcreatetime").getTime()));
                    vo.setUpdateTime(Long.valueOf(rs.getTimestamp("fupdatetime").getTime()));
                    vo.setPreset(IntegratedHelper.getPresetUserId().equals(userId));
                    listVO.add(vo);
                }
                return listVO;
            }
        });
    }

    public String getPageFolderByPageId(String pageId) throws BOSException, SQLException {
        QingIntegratedContext qingIntegratedContext = (QingIntegratedContext)this.qingContext;
        Context easCtx = qingIntegratedContext.getBosContext();
        return PortalFacade.getPageFolderByPageId(easCtx, pageId);
    }

    public List<PublishVO> loadPublishInfosForDsb(String path, String userId, Set<String> roleIds) throws SQLException, AbstractQingIntegratedException {
        String sqlInQuestion = "?";
        if (roleIds != null && roleIds.size() > 0) {
            for (int i = 1; i < roleIds.size(); ++i) {
                sqlInQuestion = sqlInQuestion + ",?";
            }
        } else {
            sqlInQuestion = "null";
        }
        String sql = "SELECT DISTINCT FID, FPATH, FNAME, FCREATORID, FSCHEMAID, FTYPE, FANALYSIS, FSOURCE, FTAGID, FCARRYDATA FROM ( SELECT p.FID, p.FNAME, p.FPATH, p.FSCHEMAID, p.FCREATORID, p.FTYPE, p.FANALYSIS, p.FSOURCE, p.FTAGID, p.FCARRYDATA FROM T_QING_PERMPUBLISH perm INNER JOIN T_QING_PUBLISH p ON perm.FPUBLISHID=p.FID WHERE p.FTYPE=? and p.FPATH=? AND ((perm.FVIEWERID=? AND perm.FTYPE='0') OR (perm.FVIEWERID IN (" + sqlInQuestion + ") AND perm.FTYPE='1')) AND (p.FSOURCE = '" + PublishSourceEnum.subject.name() + "' or p.FSOURCE = '" + PublishSourceEnum.bill.name() + "' or p.FSOURCE = '" + PublishSourceEnum.control.name() + "') UNION SELECT p.FID, p.FNAME, p.FPATH, p.FSCHEMAID, p.FCREATORID, p.FTYPE, p.FANALYSIS, p.FSOURCE, p.FTAGID, p.FCARRYDATA FROM T_QING_PUBLISH p\tWHERE p.FCREATORID=? and FPATH=? AND (p.FSOURCE = '" + PublishSourceEnum.subject.name() + "' or p.FSOURCE = '" + PublishSourceEnum.bill.name() + "' or p.FSOURCE = '" + PublishSourceEnum.control.name() + "') ) t WHERE t.FID IS NOT NULL ORDER BY t.FNAME ASC";
        ArrayList<Object> queryValue = new ArrayList<Object>();
        queryValue.add(0);
        queryValue.add(path);
        queryValue.add(userId);
        queryValue.addAll(roleIds);
        queryValue.add(userId);
        queryValue.add(path);
        return (List)this.dbExcuter.query(sql, queryValue.toArray(), (ResultHandler)new ResultHandler<List<PublishVO>>(){

            public List<PublishVO> handle(ResultSet rs) throws SQLException {
                ArrayList<PublishVO> list = new ArrayList<PublishVO>();
                while (rs.next()) {
                    PublishVO vo = new PublishVO();
                    vo.setId(rs.getString("FID"));
                    vo.setPublishTargetType(rs.getInt("FTYPE"));
                    vo.setName(rs.getString("FNAME"));
                    vo.setPath(rs.getString("FPATH"));
                    vo.setSchemaId(rs.getString("FSCHEMAID"));
                    vo.setCanAnalysis(rs.getBoolean("FANALYSIS"));
                    String publishSourceType = rs.getString("FSOURCE");
                    vo.setPublishSourceType(publishSourceType);
                    vo.setTagId(rs.getString("FTAGID"));
                    vo.setCarryData(rs.getBoolean("FCARRYDATA"));
                    vo.setCreatorId(rs.getString("FCREATORID"));
                    list.add(vo);
                }
                return list;
            }
        });
    }

    public List<PublishVO> loadPublishInfosForDsb(String userId, Set<String> roleIds) throws SQLException, AbstractQingIntegratedException {
        final String presetUserId = IntegratedHelper.getPresetUserId();
        String sqlInQuestion = "?";
        if (roleIds != null && roleIds.size() > 0) {
            for (int i = 1; i < roleIds.size(); ++i) {
                sqlInQuestion = sqlInQuestion + ",?";
            }
        } else {
            sqlInQuestion = "null";
        }
        String sql = "SELECT DISTINCT FID, FPATH, FNAME, FCREATORID, FSCHEMAID, FTYPE, FANALYSIS, FSOURCE, FTAGID, FCARRYDATA, FCREATETIME FROM ( SELECT p.FID, p.FNAME, p.FPATH, p.FSCHEMAID, p.FCREATORID, p.FTYPE, p.FANALYSIS, p.FSOURCE, p.FTAGID, p.FCARRYDATA, p.FCREATETIME FROM T_QING_PERMPUBLISH perm INNER JOIN T_QING_PUBLISH p ON perm.FPUBLISHID=p.FID WHERE p.FTYPE=? AND ((perm.FVIEWERID=? AND perm.FTYPE='0') OR (perm.FVIEWERID IN (" + sqlInQuestion + ") AND perm.FTYPE='1')) AND (p.FSOURCE = '" + PublishSourceEnum.subject.name() + "' or p.FSOURCE = '" + PublishSourceEnum.bill.name() + "' or p.FSOURCE = '" + PublishSourceEnum.control.name() + "') UNION SELECT p.FID, p.FNAME, p.FPATH, p.FSCHEMAID, p.FCREATORID, p.FTYPE, p.FANALYSIS, p.FSOURCE, p.FTAGID, p.FCARRYDATA, p.FCREATETIME FROM T_QING_PUBLISH p\tWHERE p.FCREATORID=? AND p.FTYPE=? AND (p.FSOURCE = '" + PublishSourceEnum.subject.name() + "' or p.FSOURCE = '" + PublishSourceEnum.bill.name() + "' or p.FSOURCE = '" + PublishSourceEnum.control.name() + "') ) t WHERE t.FID IS NOT NULL ORDER BY t.FNAME ASC";
        ArrayList<Object> queryValue = new ArrayList<Object>();
        queryValue.add(0);
        queryValue.add(userId);
        queryValue.addAll(roleIds);
        queryValue.add(userId);
        queryValue.add(0);
        return (List)this.dbExcuter.query(sql, queryValue.toArray(), (ResultHandler)new ResultHandler<List<PublishVO>>(){

            public List<PublishVO> handle(ResultSet rs) throws SQLException {
                ArrayList<PublishVO> list = new ArrayList<PublishVO>();
                while (rs.next()) {
                    PublishVO vo = new PublishVO();
                    vo.setId(rs.getString("FID"));
                    vo.setPublishTargetType(rs.getInt("FTYPE"));
                    vo.setName(rs.getString("FNAME"));
                    vo.setPath(rs.getString("FPATH"));
                    vo.setSchemaId(rs.getString("FSCHEMAID"));
                    vo.setCanAnalysis(rs.getBoolean("FANALYSIS"));
                    String publishSourceType = rs.getString("FSOURCE");
                    vo.setPublishSourceType(publishSourceType);
                    vo.setTagId(rs.getString("FTAGID"));
                    vo.setCarryData(rs.getBoolean("FCARRYDATA"));
                    vo.setCreatorId(rs.getString("FCREATORID"));
                    vo.setPreset(presetUserId.equals(rs.getString("FCREATORID")));
                    vo.setCreateTime(Long.valueOf(rs.getTimestamp("FCREATETIME").getTime()));
                    list.add(vo);
                }
                return list;
            }
        });
    }
}

