/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.publish.appmenu.refHandler;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.common.exception.IntegratedRuntimeException;
import com.kingdee.bos.qing.common.namespace.NameSpace;
import com.kingdee.bos.qing.common.ref.AbstractSwitchPathAndIdHandler;
import com.kingdee.bos.qing.common.ref.model.RefTypeEnum;
import com.kingdee.bos.qing.publish.appmenu.dao.AppMenuDao;
import com.kingdee.bos.qing.publish.dao.PublishInfoDao;
import com.kingdee.bos.qing.publish.domain.CommonPublishDomain;
import com.kingdee.bos.qing.publish.model.PublishPO;
import java.sql.SQLException;
import java.util.List;

public class AppMenuSwitchPathAndIdHandler
extends AbstractSwitchPathAndIdHandler {
    private AppMenuDao appMenuDao;
    private PublishInfoDao publishInfoDao;
    private CommonPublishDomain commonPublishDomain;

    private PublishInfoDao getPublishInfoDao() {
        if (this.publishInfoDao == null) {
            this.publishInfoDao = new PublishInfoDao(this.dbExcuter);
        }
        return this.publishInfoDao;
    }

    private CommonPublishDomain getCommonPublishDomain() {
        if (this.commonPublishDomain == null) {
            this.commonPublishDomain = new CommonPublishDomain(this.context, this.tx, this.dbExcuter);
        }
        return this.commonPublishDomain;
    }

    private AppMenuDao getAppMenuDao() {
        if (this.appMenuDao == null) {
            this.appMenuDao = new AppMenuDao(this.context, this.dbExcuter);
        }
        return this.appMenuDao;
    }

    public AppMenuSwitchPathAndIdHandler(QingContext context, ITransactionManagement tx, IDBExcuter dbExcuter) {
        super(context, tx, dbExcuter);
    }

    public String switchRefPathToId(String refPath, String name, String userId) throws AbstractQingIntegratedException, SQLException {
        List publishPOs = this.getPublishInfoDao().loadPublishInfoByTypeAndName(userId, 0, name);
        try {
            for (int i = 0; i < publishPOs.size(); ++i) {
                PublishPO publishPO = (PublishPO)publishPOs.get(i);
                String path = publishPO.getPath();
                String[] allPath = path.split("/");
                String publishFolderPathName = "";
                for (int j = 1; j < allPath.length; ++j) {
                    publishFolderPathName = publishFolderPathName + this.getAppMenuDao().getPageFolderByPageId(allPath[j]) + "-";
                }
                if (!refPath.equals(publishFolderPathName)) continue;
                return publishPO.getId();
            }
        }
        catch (BOSException e) {
            throw new SQLException(e);
        }
        return null;
    }

    public String switchRefIdToPath(String refToId, String userId) throws AbstractQingIntegratedException, SQLException {
        String fullPath = null;
        PublishPO publishPO = this.getCommonPublishDomain().loadPublishInfo(refToId);
        if (publishPO != null) {
            String nameSpace = publishPO.isPreset() ? NameSpace.system.toPersistance() : NameSpace.user.toPersistance();
            String[] allPath = publishPO.getPath().split("/");
            String publishFolderPathName = "";
            try {
                for (int i = 1; i < allPath.length; ++i) {
                    publishFolderPathName = publishFolderPathName + this.getAppMenuDao().getPageFolderByPageId(allPath[i]) + "-";
                }
            }
            catch (BOSException e) {
                throw new SQLException(e);
            }
            fullPath = nameSpace + "/" + publishFolderPathName + "/" + publishPO.getName();
        }
        return fullPath;
    }

    public void replacePersistentPathToId(String refPath, String refId, String userId) throws SQLException, AbstractQingIntegratedException {
        this.updateRefPathToId(RefTypeEnum.appmenu, refPath, refId, userId);
    }

    public void replacePersistentIdToPath(String refPath, String refToId, String userId) throws SQLException, AbstractQingIntegratedException {
        try {
            this.updateRefIdToPath(RefTypeEnum.appmenu, refPath, refToId, userId);
        }
        catch (SQLException e) {
            throw e;
        }
        catch (AbstractQingIntegratedException e) {
            throw e;
        }
    }

    public boolean RefIsPreset(String refToId) throws AbstractQingIntegratedException, SQLException {
        PublishPO publishInfo = this.getPublishInfoDao().getPublishInfoByInfoId(refToId);
        if (publishInfo != null) {
            return publishInfo.isPreset();
        }
        return false;
    }

    public String switchRefPathToId(String fullPath, String userId) throws AbstractQingIntegratedException, SQLException {
        try {
            String[] path = fullPath.split("/");
            if (path.length > 2) {
                String publishName = path[path.length - 1];
                List publishPOs = this.getPublishInfoDao().loadPublishInfoByTypeAndName(userId, 0, publishName);
                String refPath = path[path.length - 2];
                for (int i = 0; i < publishPOs.size(); ++i) {
                    PublishPO publishPO = (PublishPO)publishPOs.get(i);
                    String publishPath = publishPO.getPath();
                    String[] allPath = publishPath.split("/");
                    String publishFolderPathName = "";
                    for (int j = 1; j < allPath.length; ++j) {
                        publishFolderPathName = publishFolderPathName + this.getAppMenuDao().getPageFolderByPageId(allPath[j]) + "-";
                    }
                    if (!refPath.equals(publishFolderPathName)) continue;
                    return publishPO.getId();
                }
            }
            return null;
        }
        catch (BOSException e) {
            throw new IntegratedRuntimeException((Throwable)e);
        }
    }

    public String createEmptyPath() {
        return null;
    }
}

