/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.schedule;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.function.FunctionObjectInfo;
import com.kingdee.bos.metadata.function.OperationCollection;
import com.kingdee.bos.metadata.function.OperationInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.context.QingIntegratedContext;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.schedule.AbstractScheduleEngine;
import com.kingdee.bos.qing.schedule.app.IQingScheduleEntity;
import com.kingdee.bos.qing.schedule.app.QingScheduleEntityFactory;
import com.kingdee.bos.qing.schedule.app.QingScheduleEntityInfo;
import com.kingdee.bos.qing.schedule.exception.ScheduleEngineException;
import com.kingdee.bos.qing.schedule.exception.ScheduleModelParseException;
import com.kingdee.bos.qing.schedule.model.AbstractJobParam;
import com.kingdee.bos.qing.schedule.model.JobParam;
import com.kingdee.bos.qing.schedule.model.Schedule;
import com.kingdee.bos.qing.schedule.model.ScheduleMethodNameEnum;
import com.kingdee.bos.qing.util.JsonUtil;
import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.bos.qing.web.i18n.Messages;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.define.KpdlParser;
import com.kingdee.bos.workflow.define.ScheduleDef;
import com.kingdee.bos.workflow.define.ScheduleType;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.framework.CoreBaseCollection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class ScheduleEngine
extends AbstractScheduleEngine {
    public void saveJob(String scheduleTaskClassName, String appId, String userId, String orgId, String tenantId, String schedName, Schedule schedule, AbstractJobParam jobParams) throws AbstractQingIntegratedException, ScheduleEngineException, ScheduleModelParseException {
    }

    public void saveJob(QingContext qingContext, String userId, String orgId, String tenantId, String schedName, Schedule schedule, AbstractJobParam jobParms) throws AbstractQingIntegratedException, ScheduleEngineException, ScheduleModelParseException {
        if (schedule.getPeriod() == null) {
            return;
        }
        if (!(jobParms instanceof JobParam)) {
            return;
        }
        JobParam param = (JobParam)jobParms;
        String jobDefId = null;
        String prefixTitle = Messages.getLangMessage(qingContext.getIi18nContext(), "qingAnalysis", "?????-");
        String jobName = prefixTitle + param.getMethodName() + "-" + param.getPkId();
        String xmlString = this.convertToXml(schedule);
        Context ctx = ((QingIntegratedContext)qingContext).getBosContext();
        MetaDataPK functionPK = MetaDataPK.create((String)"com.kingdee.bos.qing.schedule.app.QingScheduleFunction");
        FunctionObjectInfo func = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getFunction((IMetaDataPK)functionPK);
        OperationCollection operCols = func.getOperation();
        OperationInfo operation = operCols.get(0);
        HashMap<String, String> jobContext = new HashMap<String, String>();
        jobContext.put("userId", userId);
        jobContext.put("params", param.getParams());
        jobContext.put("methodName", param.getMethodName());
        jobContext.put("orgId", orgId);
        jobContext.put("isRetainTime", "true");
        IEnactmentService service = null;
        try {
            service = EnactmentServiceFactory.createEnactService((Context)ctx);
            jobDefId = service.createJobProcessDef(jobName, func, operation, jobContext, xmlString, null);
        }
        catch (BOSException e) {
            String msg = "save job failed";
            throw new ScheduleEngineException(msg, (Throwable)e);
        }
        QingScheduleEntityInfo scheduleInfo = new QingScheduleEntityInfo();
        scheduleInfo.setJobDefId(jobDefId);
        scheduleInfo.setCreator(((JobParam)jobParms).getUserId());
        scheduleInfo.setCreateTime(new Date());
        scheduleInfo.setPkId(((JobParam)jobParms).getPkId());
        try {
            IQingScheduleEntity qingEntity = QingScheduleEntityFactory.getLocalInstance(ctx);
            qingEntity.addnew(scheduleInfo);
        }
        catch (Exception e) {
            try {
                service.removeJobProcessDef(jobDefId);
            }
            catch (WfException e1) {
                LogUtil.error((String)"rollback jobprocess failed", (Throwable)e);
            }
            String msg = "save job failed";
            throw new ScheduleEngineException(msg, (Throwable)e);
        }
    }

    public void deleteJob(QingContext qingContext, String schedName, String pkId) throws AbstractQingIntegratedException, ScheduleEngineException {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("pkid", (Object)pkId, CompareType.EQUALS));
        filterInfo.setMaskString("(#0)");
        SorterItemCollection sorterItem = new SorterItemCollection();
        SorterItemInfo sorterInfo = new SorterItemInfo();
        sorterInfo.setPropertyName("createTime");
        sorterInfo.setSortType(SortType.DESCEND);
        sorterItem.add(sorterInfo);
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.setFilter(filterInfo);
        entityViewInfo.setSorter(sorterItem);
        Context ctx = ((QingIntegratedContext)qingContext).getBosContext();
        CoreBaseCollection collection = null;
        IQingScheduleEntity qingEntity = null;
        try {
            qingEntity = QingScheduleEntityFactory.getLocalInstance(ctx);
            collection = qingEntity.getCollection(entityViewInfo);
        }
        catch (BOSException e) {
            String msg = "delete job failed";
            throw new ScheduleEngineException(msg, (Throwable)e);
        }
        if (collection == null || collection.isEmpty()) {
            return;
        }
        QingScheduleEntityInfo entityInfo = (QingScheduleEntityInfo)collection.get(0);
        String jobDefId = entityInfo.getJobDefId();
        try {
            IEnactmentService service = EnactmentServiceFactory.createEnactService((Context)ctx);
            service.removeJobProcessDef(jobDefId);
            qingEntity.delete(filterInfo);
        }
        catch (Exception e) {
            String msg = "delete job failed";
            throw new ScheduleEngineException(msg, (Throwable)e);
        }
    }

    private String convertToXml(Schedule schedule) {
        ScheduleDef sDef = new ScheduleDef(null);
        sDef.setInstructionType(0);
        Date date = new Date();
        sDef.setBeginTime(date);
        sDef.setEndTime(date);
        sDef.setDefine(ScheduleEngine.getExecuteCron((Schedule)schedule));
        switch (schedule.getPeriod()) {
            case Daily: {
                sDef.setType(ScheduleType.EVERYDAY);
                break;
            }
            case Monthly: {
                sDef.setType(ScheduleType.EVERYMONTH);
                break;
            }
            case Weekly: {
                sDef.setType(ScheduleType.EVERYWEEK);
                break;
            }
            case Custom: {
                sDef.setType(ScheduleType.USERDEFINE);
            }
        }
        return KpdlParser.scheduleToString((ScheduleDef)sDef);
    }

    public String getScheduleName() {
        return null;
    }

    public AbstractJobParam createJobParam(Map<String, Object> params) {
        JobParam jobParams = new JobParam();
        String jobTypeKey = params.get("JobType").toString();
        if (ScheduleMethodNameEnum.EXTRACT_THEME_DATA.getScheduleMethodName().equals(jobTypeKey)) {
            String themeId = params.get("themeId").toString();
            String pkId = params.get("pkId").toString();
            jobParams.setMethodName(jobTypeKey);
            jobParams.setPkId(pkId);
            jobParams.setParams(themeId);
        } else if (ScheduleMethodNameEnum.UPDATE_LAPP_THUMBNAIL.getScheduleMethodName().equals(jobTypeKey)) {
            String analysisId = params.get("analysisId").toString();
            jobParams.setMethodName(jobTypeKey);
            jobParams.setPkId(analysisId);
            jobParams.setParams(analysisId);
        } else if (ScheduleMethodNameEnum.EMAIL_PUBLISH_EXECUTE.getScheduleMethodName().equals(jobTypeKey)) {
            jobParams.setPkId(params.get("pkId").toString());
            jobParams.setMethodName(jobTypeKey);
            String json = JsonUtil.encodeToString(params);
            jobParams.setParams(json);
        } else if (ScheduleMethodNameEnum.PUSH_EXECUTE.getScheduleMethodName().equals(jobTypeKey)) {
            jobParams.setPkId(params.get("pkId").toString());
            jobParams.setMethodName(jobTypeKey);
            String json = JsonUtil.encodeToString(params);
            jobParams.setParams(json);
        } else {
            throw new RuntimeException("ScheduleEngine createJobParam error");
        }
        return jobParams;
    }
}

