/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.schedule.resource;

import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ResultHandler;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.publish.domain.PublishResInfoManagerDomain;
import com.kingdee.bos.qing.schedule.model.ScheduleExecuteVO;
import com.kingdee.bos.qing.util.StringUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class EASLappScheduleInfoGetter
implements PublishResInfoManagerDomain.IGetLappScheduleInfo {
    public List<ScheduleExecuteVO> getThumbnailScheduleInfo(IDBExcuter dbExcuter, String userId, Date dateMin, Date dateMax) throws AbstractQingIntegratedException, SQLException {
        String sql = "SELECT SE.FID, SE.FUSERID, SE.FSCHEDULENAME, SE.FSOURCEID, SE.FSOURCENAME, SE.FEXECUTESTATE, SE.FEXECUTETIME, SE.FMETHODNAME,SE.FENDTIME, P.FID AS PUBLISHID,  P.FNAME AS PUBLISHNAME,P.FPATH AS PUBLISHPATH,P.FTYPE AS PUBLISHTYPE, PG.FNAME AS PUBLISHGROUPNAME  FROM      (SELECT SE.FID, SE.FUSERID, SE.FSCHEDULENAME, SE.FSOURCEID, SE.FSOURCENAME, SE.FEXECUTESTATE, SE.FEXECUTETIME, SE.FMETHODNAME,SE.FENDTIME FROM T_QING_SCHEDULE_EXECUTE SE      WHERE SE.FUSERID=? AND SE.FMETHODNAME='updateLappThumbnail' AND SE.FEXECUTETIME>=? AND SE.FEXECUTETIME<=?) SE  LEFT JOIN T_QING_THUMBNAIL TH ON SE.FSOURCEID=TH.FANAID  LEFT JOIN T_QING_PUBLISH P ON TH.FPUBLISHID=P.FID  LEFT JOIN T_QING_PUBLISH_GROUP PG ON P.FPATH=PG.FID ";
        Object[] params = new Object[]{userId, dateMin, dateMax};
        return (List)dbExcuter.query(sql, params, (ResultHandler)new ResultHandler<List<ScheduleExecuteVO>>(){

            public List<ScheduleExecuteVO> handle(ResultSet rs) throws SQLException {
                ArrayList<ScheduleExecuteVO> voList = new ArrayList<ScheduleExecuteVO>(10);
                while (rs.next()) {
                    ScheduleExecuteVO scheduleExecute = new ScheduleExecuteVO();
                    scheduleExecute.setId(rs.getString("FID"));
                    scheduleExecute.setScheduleName(rs.getString("FSCHEDULENAME"));
                    String sourceId = StringUtils.isNotBlank((CharSequence)rs.getString("PUBLISHID")) ? rs.getString("PUBLISHID") : rs.getString("FSOURCEID");
                    scheduleExecute.setSourceId(sourceId);
                    scheduleExecute.setSourceName(rs.getString("FSOURCENAME"));
                    String publishName = rs.getString("PUBLISHNAME");
                    String publishPath = rs.getString("PUBLISHPATH");
                    String publishType = rs.getString("PUBLISHTYPE");
                    String methodName = rs.getString("FMETHODNAME");
                    scheduleExecute.setSourceName(publishName);
                    scheduleExecute.setSourcePath(publishPath);
                    scheduleExecute.setSourceTargetType(publishType);
                    scheduleExecute.setUserId(rs.getString("FUSERID"));
                    scheduleExecute.setMethodName(methodName);
                    scheduleExecute.setExecuteState(rs.getInt("FEXECUTESTATE"));
                    scheduleExecute.setExecuteTime(Long.valueOf(rs.getTimestamp("FEXECUTETIME").getTime()));
                    scheduleExecute.setSourceExist(StringUtils.isNotBlank((CharSequence)rs.getString("PUBLISHID")));
                    if (rs.getTimestamp("FENDTIME") != null) {
                        scheduleExecute.setEndTime(Long.valueOf(rs.getTimestamp("FENDTIME").getTime()));
                    }
                    voList.add(scheduleExecute);
                }
                return voList;
            }
        });
    }
}

