/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.util;

import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.qing.common.cache.LinkageFormInfo;
import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.context.QingIntegratedContext;
import com.kingdee.bos.qing.data.model.designtime.AbstractEntity;
import com.kingdee.bos.qing.data.model.designtime.Entity;
import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.bos.qing.util.StringUtils;
import com.kingdee.bos.webframework.dynamic.DynamicConfigureCollection;
import com.kingdee.bos.webframework.dynamic.DynamicConfigureFactory;
import com.kingdee.bos.webframework.dynamic.DynamicConfigureInfo;
import com.kingdee.bos.webframework.dynamic.IDynamicConfigure;
import com.kingdee.bos.webframework.dynamic.PageUserOrgUictFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;

public class LinkageFormInfoHelper {
    protected static final Logger logger = Logger.getLogger(LinkageFormInfoHelper.class);

    private Context getContext() {
        QingContext context = QingContext.getCurrent();
        QingIntegratedContext qingIntegratedContext = (QingIntegratedContext)context;
        return qingIntegratedContext.getBosContext();
    }

    public static LinkageFormInfo collectLinkageFormInfo(AbstractEntity entity, LinkageTypeEnum linkageType) {
        try {
            DynamicConfigureCollection collection = LinkageFormInfoHelper.getDynamicListConfigureCollectionByEntityPK(entity.getAssociateName());
            if (null != collection && collection.size() > 0) {
                LinkageFormInfo linkageFormInfo = new LinkageFormInfo();
                linkageFormInfo.setFormDisplayName(entity.getAlias());
                linkageFormInfo.setFormKey(entity.getAssociateName());
                ArrayList<LinkageFormInfo> layouts = new ArrayList<LinkageFormInfo>();
                for (int i = 0; i < collection.size(); ++i) {
                    DynamicConfigureInfo info = collection.get(i);
                    if (info.getIsEnable() != 1 && !LinkageFormInfoHelper.isStandardDynamicConfigureInfo(info) && !LinkageFormInfoHelper.isDefaultDynamicConfigureInfo(info)) continue;
                    boolean isStandOrDefault = LinkageFormInfoHelper.isStandardDynamicConfigureInfo(info) || LinkageFormInfoHelper.isDefaultDynamicConfigureInfo(info);
                    LinkageFormInfo subLinkageFormInfo = new LinkageFormInfo();
                    subLinkageFormInfo.setFormDisplayName(info.getDisplayName());
                    subLinkageFormInfo.setFormKey(info.getWebUIObjectName());
                    if (isStandOrDefault) {
                        subLinkageFormInfo.setExtend(false);
                    } else {
                        subLinkageFormInfo.setExtend(true);
                    }
                    String primaryKey = null;
                    switch (linkageType) {
                        case SUBJECT: {
                            primaryKey = entity.getName() + "." + info.getPKField();
                            break;
                        }
                        case EMBED: {
                            primaryKey = info.getPKField();
                            break;
                        }
                        case EMBED_EXT: {
                            primaryKey = entity.getName() + "_" + info.getPKField();
                        }
                    }
                    subLinkageFormInfo.setFormPrimaryKey(primaryKey);
                    if (layouts.contains(subLinkageFormInfo)) continue;
                    layouts.add(subLinkageFormInfo);
                }
                if (!layouts.isEmpty()) {
                    Collections.sort(layouts, new Comparator<LinkageFormInfo>(){

                        @Override
                        public int compare(LinkageFormInfo linkageFormInfo1, LinkageFormInfo linkageFormInfo2) {
                            if (linkageFormInfo1.isExtend() && !linkageFormInfo2.isExtend()) {
                                return 1;
                            }
                            if (linkageFormInfo2.isExtend() && !linkageFormInfo1.isExtend()) {
                                return -1;
                            }
                            return 0;
                        }
                    });
                    linkageFormInfo.setLayouts(layouts);
                    return linkageFormInfo;
                }
            }
        }
        catch (RuntimeException e) {
            LogUtil.error((String)e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public List<String> getDisplayNameByBizUiId(List<String> bizUiIdList) {
        LinkedList<String> bizUiDisplayNameList = new LinkedList<String>();
        if (null != bizUiIdList && !bizUiIdList.isEmpty()) {
            String bizUiDisplayName = "";
            int len = bizUiIdList.size();
            for (int i = 0; i < len; ++i) {
                DynamicConfigureInfo metapkByUipk = this.getMetapkByUipk(bizUiIdList.get(i));
                if (null != metapkByUipk) {
                    bizUiDisplayName = metapkByUipk.getWebUIObjectName();
                }
                bizUiDisplayNameList.add(bizUiDisplayName);
            }
        }
        return bizUiDisplayNameList;
    }

    public AbstractEntity getEntityByUipk(String uipk) {
        DynamicConfigureInfo metapkByUipk = this.getMetapkByUipk(uipk);
        String entityPK = "";
        if (null != metapkByUipk) {
            entityPK = metapkByUipk.getEntityObjectName();
        }
        Context bosContext = this.getContext();
        EntityObjectInfo entityInfo = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)bosContext).getEntity((IMetaDataPK)MetaDataPK.create((String)entityPK));
        Entity entity = new Entity();
        entity.setAssociateName(entityPK);
        entity.setName(entityInfo.getName());
        entity.setAlias(entityInfo.getAlias());
        return entity;
    }

    private DynamicConfigureInfo getMetapkByUipk(String uipk) {
        DynamicConfigureInfo configureInfo;
        block3: {
            configureInfo = null;
            try {
                IDynamicConfigure iDynamicConfigure = DynamicConfigureFactory.getRemoteInstance();
                EntityViewInfo entityViewInfo = new EntityViewInfo();
                entityViewInfo.getSelector().add(new SelectorItemInfo("entityObjectName"));
                entityViewInfo.getSelector().add(new SelectorItemInfo("isEnable"));
                entityViewInfo.getSelector().add(new SelectorItemInfo("isNew"));
                entityViewInfo.getSelector().add(new SelectorItemInfo("easSkin"));
                FilterInfo filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("webUIObjectName", (Object)uipk, CompareType.EQUALS, false, false));
                entityViewInfo.setFilter(filterInfo);
                DynamicConfigureCollection configureCollection = iDynamicConfigure.getDynamicConfigureCollection(entityViewInfo);
                if (configureCollection.size() <= 0) break block3;
                for (int i = 0; i < configureCollection.size(); ++i) {
                    if (!configureCollection.get(i).isIsNew()) continue;
                    configureInfo = configureCollection.get(i);
                    break;
                }
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage());
            }
        }
        return configureInfo;
    }

    private static DynamicConfigureCollection getDynamicListConfigureCollectionByEntityPK(String entryPK) {
        DynamicConfigureCollection result = new DynamicConfigureCollection();
        try {
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            entityViewInfo.getSelector().add(new SelectorItemInfo("*"));
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("entityObjectName", (Object)entryPK, CompareType.EQUALS, false, false));
            filterInfo.getFilterItems().add(new FilterItemInfo("version", (Object)"1", CompareType.GREATER_EQUALS, false, false));
            filterInfo.getFilterItems().add(new FilterItemInfo("pageType", (Object)"list", CompareType.EQUALS, false, false));
            filterInfo.setMaskString("#0 AND #1 AND #2");
            entityViewInfo.setFilter(filterInfo);
            IDynamicConfigure iDynamicConfigure = DynamicConfigureFactory.getRemoteInstance();
            result = iDynamicConfigure.getDynamicConfigureCollection(entityViewInfo);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
        return result;
    }

    private static final boolean isDefaultDynamicConfigureInfo(DynamicConfigureInfo info) {
        if (info.getIsEnable() == 1) {
            try {
                return PageUserOrgUictFactory.getRemoteInstance().exists(" where configure ='" + info.getId().toString() + "' and orgid='00000000-0000-0000-0000-000000000000CCE7AED4'");
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage());
            }
        }
        return false;
    }

    private static final boolean isStandardDynamicConfigureInfo(DynamicConfigureInfo info) {
        return info.isIsDefault() || StringUtils.isEmpty((CharSequence)info.getDependID());
    }

    public static enum LinkageTypeEnum {
        SUBJECT,
        EMBED,
        EMBED_EXT;

    }
}

