/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qingReport.demo.server;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.qingReport.common.utils.QingAnalysisFilterSynCacheUtil;
import com.kingdee.bos.qingReport.demo.server.DemoDataProviderListener;
import com.kingdee.bos.qingReport.demo.server.Province;
import com.kingdee.bos.qingReport.server.dataProvider.AbstractDataProviderWrapper;
import com.kingdee.bos.qingReport.server.dataProvider.modelWrapper.EntryEntity;
import com.kingdee.bos.qingReport.server.dataProvider.modelWrapper.Field;
import com.kingdee.bos.qingReport.server.dataProvider.modelWrapper.QingData;
import com.kingdee.bos.qingReport.server.dataProvider.modelWrapper.QingFieldType;
import com.kingdee.bos.qingReport.server.dataProvider.modelWrapper.QingMeta;
import com.kingdee.eas.common.EASBizException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;

public class DemoDataProviderWrapper
extends AbstractDataProviderWrapper {
    private Context ctx;
    private String[] keys = new String[]{"department", "name", "date", "sum", "payeeType", "province", "period", "organization"};
    private int maxRow = 500;

    public DemoDataProviderWrapper() {
    }

    public DemoDataProviderWrapper(Context ctx) {
        this.ctx = ctx;
        this.registerListener(new DemoDataProviderListener(ctx));
    }

    @Override
    public QingMeta getQingMeta(String tag) {
        QingMeta qingMeta = new QingMeta();
        Field field = new Field();
        field.setAlias(new String("\u90e8\u95e8"));
        field.setName(this.keys[0]);
        field.setFieldType(QingFieldType.String.toNumber());
        field.setEntity("");
        field.setRefEntity("");
        field.setFilter(true);
        qingMeta.addColumn(field);
        field = new Field();
        field.setAlias(new String("\u59d3\u540d"));
        field.setName(this.keys[1]);
        field.setFieldType(QingFieldType.String.toNumber());
        field.setEntity("");
        field.setRefEntity("");
        field.setFilter(true);
        qingMeta.addColumn(field);
        field = new Field();
        field.setAlias(new String("\u65e5\u671f"));
        field.setName(this.keys[2]);
        field.setFieldType(QingFieldType.Date.toNumber());
        field.setEntity("");
        field.setRefEntity("");
        field.setFilter(true);
        qingMeta.addColumn(field);
        field = new Field();
        field.setAlias(new String("\u91d1\u989d"));
        field.setName(this.keys[3]);
        field.setFieldType(QingFieldType.Number.toNumber());
        field.setEntity("");
        field.setRefEntity("");
        field.setFilter(true);
        qingMeta.addColumn(field);
        EntryEntity entityInfo = new EntryEntity();
        entityInfo.setAlias("");
        entityInfo.setName("");
        entityInfo.setParentName("");
        entityInfo.setPkFieldName("");
        qingMeta.addEntryEntity(entityInfo);
        field = new Field();
        field.setAlias(new String("\u5f80\u6765\u7c7b\u578b"));
        field.setName(this.keys[4]);
        field.setFieldType(QingFieldType.String.toNumber());
        field.setRealType(QingFieldType.Link.toNumber());
        field.setEntity("");
        field.setRefEntity("");
        field.setFilter(true);
        field.setDisplayFormat("number");
        field.setSubmitFormat("id");
        field.setPromptQuery("com.kingdee.eas.basedata.master.auxacct.app.F7AsstActTypeQuery");
        qingMeta.addColumn(field);
        field = new Field();
        field.setAlias(new String("\u7701\u4efd"));
        field.setName(this.keys[5]);
        field.setFieldType(QingFieldType.String.toNumber());
        field.setRealType(QingFieldType.Enum.toNumber());
        field.setEntity("");
        field.setRefEntity("");
        field.setFilter(true);
        ArrayList<Province> enumSource = new ArrayList<Province>();
        enumSource.add(new Province("\u5c71\u897f", 1, null, null));
        enumSource.add(new Province("\u5c71\u4e1c", 2, null, null));
        enumSource.add(new Province("\u6cb3\u5357", 3, null, null));
        enumSource.add(new Province("\u6cb3\u5317", 4, null, null));
        enumSource.add(new Province("\u6e56\u5357", 5, null, null));
        enumSource.add(new Province("\u6e56\u5317", 6, null, null));
        field.setEnumSource(enumSource);
        qingMeta.addColumn(field);
        field = new Field();
        field.setAlias(new String("\u4f1a\u8ba1\u671f\u95f4"));
        field.setName(this.keys[6]);
        field.setFieldType(QingFieldType.String.toNumber());
        field.setRealType(QingFieldType.Link.toNumber());
        field.setEntity("");
        field.setRefEntity("");
        field.setFilter(true);
        field.setDisplayFormat("number");
        field.setSearchItem("number");
        field.setSubmitFormat("id");
        field.setPromptQuery("com.kingdee.eas.basedata.assistant.app.F7PeriodQuery");
        field.setFilterName("period");
        qingMeta.addColumn(field);
        field = new Field();
        field.setAlias(new String("\u7ec4\u7ec7"));
        field.setName(this.keys[7]);
        field.setFieldType(QingFieldType.String.toNumber());
        field.setRealType(QingFieldType.Link.toNumber());
        field.setEntity("");
        field.setRefEntity("");
        field.setFilter(true);
        field.setOrgFiled(true);
        field.setDisplayFormat("name");
        field.setSearchItem("name+number");
        field.setSubmitFormat("id");
        field.setFilterName("company");
        qingMeta.addColumn(field);
        return qingMeta;
    }

    @Override
    public QingData getQingData(String tag, int startRow, int limit) {
        String filter = null;
        int topN = -1;
        try {
            filter = QingAnalysisFilterSynCacheUtil.getFilter(tag);
            if (!StringUtil.isEmptyString((String)filter) && filter.indexOf("top") != -1) {
                String filterIndex = filter.substring(filter.indexOf("top") + "top ".length(), filter.length() - 1);
                if (StringUtil.isEmptyString((String)filterIndex)) {
                    filterIndex = "-1";
                }
                topN = Integer.parseInt(filterIndex);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        QingData qingData = new QingData();
        HashMap<String, Integer> dataIndex = new HashMap<String, Integer>();
        ArrayList<Object[]> dataList = new ArrayList<Object[]>();
        for (int i = 0; i < limit && i + startRow < this.maxRow; ++i) {
            int index = startRow + i;
            String department = "\u90e8\u95e8" + index;
            String name = "\u59d3\u540d" + index;
            Date date = new Date();
            int sum = index;
            Object[] rowData = new Object[]{department, name, date.getTime(), sum, department, department, department, department};
            dataList.add(rowData);
            if (topN > 0 && i >= topN - 1) break;
        }
        dataIndex.put(this.keys[0], 0);
        dataIndex.put(this.keys[1], 1);
        dataIndex.put(this.keys[2], 2);
        dataIndex.put(this.keys[3], 3);
        dataIndex.put(this.keys[4], 4);
        dataIndex.put(this.keys[5], 5);
        dataIndex.put(this.keys[6], 6);
        dataIndex.put(this.keys[7], 7);
        qingData.setDataindex(dataIndex);
        qingData.setRows(dataList);
        return qingData;
    }

    @Override
    public void disposeProvider(String tag) {
    }

    @Override
    public String setQingFilter(String tag, String filter) {
        return null;
    }

    @Override
    public String getQingFilter(String tag) throws EASBizException, BOSException {
        return null;
    }
}

