/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.service.job.core;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.service.job.core.Configuration;
import com.kingdee.bos.service.job.core.IJobHandler;
import com.kingdee.bos.service.job.core.Job;
import com.kingdee.bos.service.job.core.JobDefCache;
import com.kingdee.bos.service.job.core.JobEvent;
import com.kingdee.bos.service.job.core.JobIsolationLevel;
import com.kingdee.bos.service.job.core.Wrapper;
import com.kingdee.bos.service.job.core.WrapperFactory;
import com.kingdee.bos.service.job.util.Ctx;
import com.kingdee.bos.service.job.util.ICacheElement;
import com.kingdee.bos.service.job.util.IListener;
import com.kingdee.bos.service.job.util.SQL;
import com.kingdee.bos.service.job.util.Xml;
import com.kingdee.util.StringUtils;
import com.kingdee.util.Uuid;
import java.io.Serializable;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class JobDef
implements ICacheElement,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final String BOSTYPE = "BGJOBDEF";
    String defId;
    int priority;
    boolean isSmallJob;
    boolean isPersistent;
    String serviceType;
    String mutex;
    String viewerUI;
    JobIsolationLevel jobIsolationlevel;
    private String title;
    private String packageName;
    private String description;
    private String proxyUserID;
    private String proxyOrgID;
    private String createUserID;
    private Date createTime;
    private String updateUserID;
    private Date updateTime;
    private int missedTimeout;
    private Wrapper handlerWrapper;
    private ArrayList listenerWrappers;
    private String categoryId;
    HashMap listeners;
    IJobHandler handler;
    private String datacenter;
    private int runTimeout;

    public JobDef(Context ctx, String packageName, String title, String description, String proxyUserID, String proxyOrgID, boolean isPersistent, Wrapper handler) throws BOSException {
        this(ctx, packageName, title, description, proxyUserID, proxyOrgID, isPersistent, handler, false, null, 500, -1, Configuration.defaultJobIsolationLevel(), null);
    }

    public JobDef(Context ctx, String packageName, String title, String description, String proxyUserID, String proxyOrgID, boolean isPersistent, Wrapper handler, boolean isSmallJob, String mutex, int priority, int missedTimeout, JobIsolationLevel isolationLevel, String viewerUI) throws BOSException {
        this(Uuid.randomUUID().toString() + BOSTYPE, ctx, packageName, title, description, proxyUserID, proxyOrgID, isPersistent, handler, isSmallJob, mutex, priority, missedTimeout, Configuration.defaultJobIsolationLevel(), viewerUI);
    }

    public JobDef(String jobdefid, Context ctx, String packageName, String title, String description, String proxyUserID, String proxyOrgID, boolean isPersistent, Wrapper handler, boolean isSmallJob, String mutex, int priority, int missedTimeout, JobIsolationLevel isolationLevel, String viewerUI) throws BOSException {
        this(jobdefid, packageName, title, description, proxyUserID, proxyOrgID, isPersistent, handler, isSmallJob, mutex, priority, missedTimeout, isolationLevel, viewerUI, ctx.getAIS(), ctx.getCaller().toString());
    }

    public JobDef(String jobdefid, String packageName, String title, String description, String proxyUserID, String proxyOrgID, boolean isPersistent, Wrapper handler, boolean isSmallJob, String mutex, int priority, int missedTimeout, JobIsolationLevel isolationLevel, String viewerUI, String datacenter, String creatUserId) throws BOSException {
        handler.toHandler();
        this.packageName = packageName;
        this.title = title;
        this.description = description;
        this.proxyUserID = proxyUserID;
        this.proxyOrgID = proxyOrgID;
        this.isPersistent = isPersistent;
        this.handlerWrapper = handler;
        this.priority = priority;
        this.mutex = mutex;
        this.isSmallJob = isSmallJob;
        this.missedTimeout = missedTimeout;
        this.jobIsolationlevel = isolationLevel;
        this.viewerUI = viewerUI;
        this.datacenter = datacenter;
        this.defId = jobdefid;
        this.updateUserID = this.createUserID = creatUserId;
        this.updateTime = this.createTime = new Timestamp(System.currentTimeMillis());
        this.listenerWrappers = new ArrayList();
    }

    public void addListener(JobEvent e, Wrapper w) throws BOSException {
        w.toListener();
        ListenerWrapper lw = new ListenerWrapper(e, w);
        this.listenerWrappers.add(lw);
    }

    void initListenersAndHandler() throws BOSException {
        this.handler = this.handlerWrapper.toHandler();
        this.listeners = new HashMap();
        if (this.listenerWrappers == null) {
            return;
        }
        for (int i = 0; i < this.listenerWrappers.size(); ++i) {
            ListenerWrapper lw = (ListenerWrapper)this.listenerWrappers.get(i);
            this.addListeners(lw.e, lw.w.toListener());
        }
    }

    private void addListeners(JobEvent e, IListener l) {
        ArrayList<IListener> list = (ArrayList<IListener>)this.listeners.get(e);
        if (list == null) {
            list = new ArrayList<IListener>();
            this.listeners.put(e, list);
        }
        list.add(l);
    }

    private JobDef() {
    }

    @Override
    public String getKey() {
        return JobDef.generateKey(this.defId, this.datacenter);
    }

    static String generateKey(String defid, String dc) {
        return defid + "@" + dc;
    }

    public String getDefId() {
        return this.defId;
    }

    public String getName() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public String getProxyUserID() {
        return this.proxyUserID;
    }

    public String getProxyOrgID() {
        return this.proxyOrgID;
    }

    public String getCreateUserID() {
        return this.createUserID;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public String getUpdateUserID() {
        return this.updateUserID;
    }

    public Date getUpdateTime() {
        return this.updateTime;
    }

    public Wrapper getHandlerWrapper() {
        return this.handlerWrapper;
    }

    public ArrayList getListenerWrappers() {
        return this.listenerWrappers;
    }

    public int getPriority() {
        return this.priority;
    }

    public boolean isSmallJob() {
        return this.isSmallJob;
    }

    public boolean isPersistent() {
        return this.isPersistent;
    }

    public String getMutex() {
        return this.mutex;
    }

    public String getViewerUI() {
        return this.viewerUI;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public int getMissedTimeout() {
        return this.missedTimeout;
    }

    public JobIsolationLevel getJobIsolationlevel() {
        return this.jobIsolationlevel;
    }

    public String getTitle() {
        return this.title;
    }

    public HashMap getListeners() {
        return this.listeners;
    }

    public IJobHandler getHandler() {
        return this.handler;
    }

    public String getDatacenter() {
        return this.datacenter;
    }

    public String getCategoryId() {
        return this.categoryId;
    }

    public void setCategoryId(String categoryId) {
        this.categoryId = categoryId;
    }

    public String getServiceType() {
        return this.serviceType;
    }

    public void setServiceType(String serviceType) {
        this.serviceType = serviceType;
    }

    public int getRunTimeout() {
        return this.runTimeout;
    }

    public void setRunTimeout(int runTimeout) {
        this.runTimeout = runTimeout;
    }

    void save() throws BOSException {
        String sql = "insert into T_JOB_DEF(fjobdefid, fpackage, ftitle, fdescription, fproxyUserID, fproxyOrgID, fispersistent,  fhandlerWrapper, fpriority, fissmallJob,  fmutex, fviewerUI, fmissedtimeout, fjobisolationlevel, fcreateUserID, fcreateTime, fupdateUserID, fupdateTime, flistenerWrappers, FCategoryID, Fcluster,fservicetype,fruntimeout)values(?,?,?,?,   ?,?,?,   ?,?,?,  ?,?,?,?,  ?,?,?,  ?,?,?, ?,?,?)";
        Object[] values = new Object[]{this.defId, this.packageName, this.title, this.description, this.proxyUserID, this.proxyOrgID, this.isPersistent ? "Y" : "N", this.handlerWrapper.toString(), new Integer(this.priority), this.isSmallJob ? "Y" : "N", this.mutex, this.viewerUI, new Integer(this.missedTimeout), this.jobIsolationlevel == null ? null : this.jobIsolationlevel.toString(), this.createUserID, this.createTime, this.updateUserID, this.updateTime, ListenerWrapper.toString(this.listenerWrappers), this.categoryId, Configuration.clusterIsolation(), this.serviceType, new Integer(this.runTimeout)};
        int[] types = new int[]{12, 12, 12, 12, 12, 12, 12, 12, 4, 12, 12, 12, 4, 12, 12, 93, 12, 93, 12, 12, 12, 12, 4};
        SQL.executeUpdate(this.datacenter, sql, types, values);
        JobDefCache.remove(this.datacenter, this.defId);
    }

    public Job createJobInstance(Context ctx, String title, Object param, Timestamp scheduledTime, Timestamp expiredTime, int hashCode, String isolationBoundary) throws BOSException {
        if (scheduledTime == null) {
            scheduledTime = new Timestamp(System.currentTimeMillis());
        }
        if (expiredTime == null) {
            int timeout = this.missedTimeout;
            int t = Configuration.persistantJobCheckInterval() * 10;
            if (timeout == 0 && (timeout = t) < 180) {
                timeout = 180;
            }
            if (timeout > 0) {
                if (timeout < t) {
                    timeout = t;
                }
                expiredTime = new Timestamp(scheduledTime.getTime() + (long)(timeout * 1000));
            }
        }
        SimpleDateFormat df = new SimpleDateFormat("yyMMddHHmmss");
        if (StringUtils.isEmpty((String)title)) {
            title = this.title + "_" + df.format(scheduledTime);
        }
        Job job = new Job(ctx, title, this, param, scheduledTime, expiredTime, hashCode, null, isolationBoundary);
        return job;
    }

    private Timestamp getTimestamp(Timestamp scheduledTime, Timestamp expiredTime) {
        if (expiredTime == null) {
            int timeout = this.missedTimeout;
            int t = Configuration.persistantJobCheckInterval() * 10;
            if (timeout == 0 && (timeout = t) < 3600) {
                timeout = 3600;
            }
            if (timeout > 0) {
                if (timeout < t) {
                    timeout = t;
                }
                expiredTime = new Timestamp(scheduledTime.getTime() + (long)(timeout * 1000));
            }
        }
        return expiredTime;
    }

    public Job newInstance(Context ctx, Object param, Timestamp scheduledTime, Timestamp expiredTime, int hashCode, String priorJobId, String isolationBoundary) throws BOSException {
        if (scheduledTime == null) {
            scheduledTime = new Timestamp(System.currentTimeMillis());
        }
        expiredTime = this.getTimestamp(scheduledTime, expiredTime);
        SimpleDateFormat df = new SimpleDateFormat("yyMMddHHmmss");
        String title = this.title + "_" + df.format(scheduledTime);
        Job job = new Job(ctx, title, this, param, scheduledTime, expiredTime, hashCode, priorJobId, isolationBoundary);
        return job;
    }

    public Job newInstance(Context ctx, Object param, Timestamp scheduledTime, Timestamp expiredTime, int hashCode, String priorJobId) throws BOSException {
        if (scheduledTime == null) {
            scheduledTime = new Timestamp(System.currentTimeMillis());
        }
        expiredTime = this.getTimestamp(scheduledTime, expiredTime);
        SimpleDateFormat df = new SimpleDateFormat("yyMMddHHmmss");
        String title = this.title + "_" + df.format(scheduledTime);
        Job job = new Job(ctx, title, this, param, scheduledTime, expiredTime, hashCode, priorJobId);
        return job;
    }

    public Job newInstance(Context ctx, Object param, Timestamp scheduledTime, Timestamp expiredTime, int hashCode) throws BOSException {
        return this.newInstance(ctx, param, scheduledTime, expiredTime, hashCode, null);
    }

    public Job newInstance(Object param, Timestamp scheduledTime, Timestamp expiredTime, int hashCode) throws BOSException {
        Context ctx = Ctx.newShadowContext(this.datacenter, this.proxyUserID);
        return this.newInstance(ctx, param, scheduledTime, expiredTime, hashCode);
    }

    public Job newInstance(Object param, Timestamp scheduledTime, Timestamp expiredTime, int hashCode, String selectedServer) throws BOSException {
        Context ctx = Ctx.newShadowContext(this.datacenter, this.proxyUserID);
        return this.newInstance(ctx, param, scheduledTime, expiredTime, hashCode, null, selectedServer);
    }

    public Job newInstance(Object param, Timestamp scheduledTime, Timestamp expiredTime) throws BOSException {
        return this.newInstance(param, scheduledTime, expiredTime, -1);
    }

    public Job newInstance(Object param, Timestamp scheduledTime) throws BOSException {
        return this.newInstance(param, scheduledTime, null);
    }

    public Job newInstance(Object param, Timestamp scheduledTime, Timestamp expiredTime, String selectedServer) throws BOSException {
        return this.newInstance(param, scheduledTime, expiredTime, -1, selectedServer);
    }

    public Job newInstance(Object param) throws BOSException {
        return this.newInstance(param, null);
    }

    public Job newInstance(Timestamp scheduledTime) throws BOSException {
        return this.newInstance((Object)null, scheduledTime);
    }

    public Job newInstance(Context ctx, Object param, Timestamp scheduledTime, Timestamp expiredTime) throws BOSException {
        return this.newInstance(ctx, param, scheduledTime, expiredTime, -1);
    }

    public Job newInstance(Context ctx, Object param, Timestamp scheduledTime) throws BOSException {
        return this.newInstance(ctx, param, scheduledTime, null);
    }

    public Job newInstance(Context ctx, Object param) throws BOSException {
        return this.newInstance(ctx, param, null);
    }

    public String toString() {
        return "{" + this.title + ", " + this.defId + "}";
    }

    static JobDef load(String datacenter, String defId) throws BOSException {
        ArrayList data = SQL.executeQuery(datacenter, "select fjobdefid,fpackage,ftitle,fpriority,fissmalljob,fispersistent,fmutex,fviewerui,fdescription,fproxyuserid,fproxyorgid,fcreateuserid,fcreatetime,fupdateuserid,fupdatetime,fhandlerwrapper,flistenerwrappers,fmissedtimeout,fjobisolationlevel,fservicetype,fruntimeout from t_job_def where fjobdefid=?", new int[]{12}, new Object[]{defId});
        if (data == null || data.size() == 0) {
            throw new BOSException("job def {" + defId + "} dosn't exist at {" + datacenter + "}.");
        }
        HashMap item = (HashMap)data.get(0);
        JobDef def = new JobDef();
        def.defId = (String)item.get("fjobdefid");
        def.packageName = (String)item.get("fpackage");
        def.title = (String)item.get("ftitle");
        def.priority = Integer.parseInt(item.get("fpriority").toString());
        def.isSmallJob = "Y".equals(item.get("fissmalljob"));
        def.isPersistent = "Y".equals(item.get("fispersistent"));
        def.mutex = (String)item.get("fmutex");
        def.viewerUI = (String)item.get("fviewerui");
        def.description = (String)item.get("fdescription");
        def.proxyUserID = (String)item.get("fproxyuserid");
        def.proxyOrgID = (String)item.get("fproxyorgid");
        def.createUserID = (String)item.get("fcreateuserid");
        def.createTime = (Date)item.get("fcreatetime");
        def.updateUserID = (String)item.get("fupdateuserid");
        def.updateTime = (Date)item.get("fupdatetime");
        def.handlerWrapper = WrapperFactory.getWrapper((String)item.get("fhandlerwrapper"));
        def.listenerWrappers = ListenerWrapper.parse((String)item.get("flistenerwrappers"));
        def.missedTimeout = Integer.parseInt(item.get("fmissedtimeout").toString());
        def.jobIsolationlevel = JobIsolationLevel.valueOf((String)item.get("fjobisolationlevel"));
        if (def.jobIsolationlevel == null) {
            def.jobIsolationlevel = Configuration.defaultJobIsolationLevel();
        }
        def.serviceType = (String)item.get("fservicetype");
        def.runTimeout = Integer.parseInt(item.get("fruntimeout").toString());
        def.datacenter = datacenter;
        def.initListenersAndHandler();
        return def;
    }

    private static class ListenerWrapper
    implements Serializable {
        private static final long serialVersionUID = 1L;
        JobEvent e;
        Wrapper w;

        ListenerWrapper(JobEvent e, Wrapper w) {
            this.e = e;
            this.w = w;
        }

        static ArrayList parse(String xml) throws BOSException {
            ArrayList<ListenerWrapper> wrappers = new ArrayList<ListenerWrapper>();
            if (xml == null || xml.length() == 0) {
                return wrappers;
            }
            Document doc = Xml.parse(xml);
            NodeList list = doc.getElementsByTagName("listener");
            for (int i = 0; i < list.getLength(); ++i) {
                Node node = list.item(i);
                NamedNodeMap attributes = node.getAttributes();
                String event = attributes.getNamedItem("event").getNodeValue();
                String config = attributes.getNamedItem("config").getNodeValue();
                JobEvent e = JobEvent.valueOf(event);
                Wrapper w = WrapperFactory.getWrapper(config);
                wrappers.add(new ListenerWrapper(e, w));
            }
            return wrappers;
        }

        static String toString(ArrayList wrappers) {
            if (wrappers == null || wrappers.size() == 0) {
                return null;
            }
            StringBuffer xml = new StringBuffer();
            xml.append("<listeners>");
            for (int i = 0; i < wrappers.size(); ++i) {
                ListenerWrapper lw = (ListenerWrapper)wrappers.get(i);
                xml.append("\r\n<listener ");
                xml.append(" event='").append(lw.e.toString()).append("'");
                xml.append(" config='").append(Xml.escape(lw.w.toString())).append("'");
                xml.append("/>");
            }
            xml.append("\r\n</listeners>");
            return xml.toString();
        }
    }
}

