/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.service.job.core;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.service.job.core.Configuration;
import com.kingdee.bos.service.job.core.JobDef;
import com.kingdee.bos.service.job.util.Cache;

public class JobDefCache {
    private static Cache cache = new Cache(Configuration.jobDefCacheSize());

    public static void clear() {
        cache.clear();
    }

    public static boolean remove(String datacenter, String defId) {
        String key = JobDef.generateKey(defId, datacenter);
        return cache.remove(key) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JobDef getJobDef(String datacenter, String defId) throws BOSException {
        String key = JobDef.generateKey(defId, datacenter);
        JobDef def = (JobDef)cache.get(key);
        if (def != null) {
            return def;
        }
        Cache cache = JobDefCache.cache;
        synchronized (cache) {
            def = (JobDef)JobDefCache.cache.get(key);
            if (def != null) {
                return def;
            }
            def = JobDef.load(datacenter, defId);
            if (def == null) {
                return null;
            }
            JobDefCache.cache.push(def);
        }
        return def;
    }

    public static int cacheSize() {
        return cache.size();
    }
}

