/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.service.job.core;

import com.kingdee.bos.service.job.core.Configuration;
import com.kingdee.bos.service.job.core.IWfJobHandler;
import com.kingdee.bos.service.job.core.Job;
import com.kingdee.bos.service.job.core.ReadyJobs;
import com.kingdee.bos.service.job.core.ThreadWorkerWrapper;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;

public class JobThreadPoolManager {
    private static Logger logger = Logger.getLogger(JobThreadPoolManager.class);
    private static JobThreadPoolManager instance = new JobThreadPoolManager();
    private Map<ReadyJobs.Queue, ThreadPoolExecutor> map = new ConcurrentHashMap<ReadyJobs.Queue, ThreadPoolExecutor>();
    private final long maxMemorySize = Runtime.getRuntime().maxMemory();
    private volatile long nextAdjustTime = System.currentTimeMillis();
    private ReadyJobs.Queue[] adjustQueues = new ReadyJobs.Queue[]{ReadyJobs.Queue.BigJobs, ReadyJobs.Queue.MajorJobs};

    private JobThreadPoolManager() {
    }

    public static JobThreadPoolManager getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initJobThreadPool(ReadyJobs.Queue q, int corePoolSize, int maximumPoolSize, long keepAliveTime, boolean allowCoreThreadTimeOut) {
        ThreadPoolExecutor pool = this.map.get((Object)q);
        if (pool == null) {
            Map<ReadyJobs.Queue, ThreadPoolExecutor> map = this.map;
            synchronized (map) {
                if (this.map.get((Object)q) == null) {
                    ThreadPoolExecutor es = this.createThreadPool(q, corePoolSize, maximumPoolSize, keepAliveTime, allowCoreThreadTimeOut);
                    this.map.put(q, es);
                }
            }
        } else {
            throw new IllegalStateException("ThreadPoolExecutor is inited! queue: " + (Object)((Object)q));
        }
    }

    void submitJob(ReadyJobs.Queue q, Job job) {
        this.adjustThreadPool();
        this.getThreadPool(q).execute(this.getTask(q, job));
    }

    private void adjustThreadPool() {
        if (System.currentTimeMillis() < this.nextAdjustTime) {
            return;
        }
        this.nextAdjustTime = System.currentTimeMillis() + 30000L;
        long totalMemorySize = Runtime.getRuntime().totalMemory();
        long freeMemorySize = Runtime.getRuntime().freeMemory();
        if (totalMemorySize == this.maxMemorySize && (double)freeMemorySize > (double)this.maxMemorySize * 0.15 || (double)(totalMemorySize - freeMemorySize) < (double)this.maxMemorySize * 0.85) {
            for (int i = 0; i < this.adjustQueues.length; ++i) {
                ThreadPoolExecutor threadPool = this.getThreadPool(this.adjustQueues[i]);
                if (threadPool.getMaximumPoolSize() != threadPool.getActiveCount()) continue;
                int ncpu = 2 * Runtime.getRuntime().availableProcessors();
                int maxSize = Configuration.maximalConcurrency();
                int curSize = threadPool.getMaximumPoolSize();
                if (curSize >= (ncpu > maxSize ? ncpu : maxSize) || curSize >= 30) continue;
                JobThreadPoolManager.setPoolSize(this.adjustQueues[i], curSize + 1);
            }
        } else {
            for (int i = 0; i < this.adjustQueues.length; ++i) {
                ThreadPoolExecutor threadPool = this.getThreadPool(this.adjustQueues[i]);
                int minSize = Configuration.minimalConcurrency();
                int curSize = threadPool.getMaximumPoolSize();
                if (curSize <= minSize) continue;
                JobThreadPoolManager.setPoolSize(this.adjustQueues[i], curSize - 1);
            }
        }
    }

    public static void setPoolSize(ReadyJobs.Queue q, int i) {
        ThreadPoolExecutor threadPool = JobThreadPoolManager.getInstance().getThreadPool(q);
        threadPool.setCorePoolSize(i);
        threadPool.setMaximumPoolSize(i);
    }

    public static void setNextAdjustTime(long nextAdjustTime) {
        JobThreadPoolManager.getInstance().nextAdjustTime = nextAdjustTime;
    }

    public static long getNextAdjustTime() {
        return JobThreadPoolManager.getInstance().nextAdjustTime;
    }

    void submitJob(Job job) {
        ReadyJobs.Queue q = null;
        q = job.isSmallJob() ? ReadyJobs.Queue.SmallJobs : (job.getHandler() instanceof IWfJobHandler ? ReadyJobs.Queue.WfJobs : (job.getStaticPriority() < 0 && this.getThreadPool(ReadyJobs.Queue.BigJobs).getActiveCount() >= this.getThreadPool(ReadyJobs.Queue.BigJobs).getMaximumPoolSize() ? ReadyJobs.Queue.MajorJobs : ReadyJobs.Queue.BigJobs));
        this.submitJob(q, job);
    }

    private Runnable getTask(ReadyJobs.Queue q, Job job) {
        return new ThreadWorkerWrapper(q, job);
    }

    BlockingQueue<Runnable> getQueue(ReadyJobs.Queue q) {
        return this.getThreadPool(q).getQueue();
    }

    synchronized Job[] getQueueAsObjects(ReadyJobs.Queue q) {
        BlockingQueue<Runnable> queue = this.getQueue(q);
        ThreadWorkerWrapper[] wrappers = queue.toArray(new ThreadWorkerWrapper[queue.size()]);
        Job[] jobs = new Job[wrappers.length];
        for (int i = 0; i < wrappers.length; ++i) {
            jobs[i] = wrappers[i].getJob();
        }
        return jobs;
    }

    ThreadPoolExecutor getThreadPool(ReadyJobs.Queue q) {
        ThreadPoolExecutor es = this.map.get((Object)q);
        if (es == null) {
            throw new IllegalStateException();
        }
        return es;
    }

    public ThreadPoolExecutor getThreadPool(String queue) {
        ReadyJobs.Queue q = ReadyJobs.Queue.valueOf(queue);
        return this.getThreadPool(q);
    }

    private ThreadPoolExecutor createThreadPool(ReadyJobs.Queue q, int corePoolSize, int maximumPoolSize, long keepAliveTime, boolean allowCoreThreadTimeOut) {
        final ReadyJobs.Queue final_q = q;
        if (keepAliveTime < 60L) {
            keepAliveTime = 60L;
        }
        PriorityBlockingQueue<Runnable> queue = new PriorityBlockingQueue<Runnable>();
        ThreadPoolExecutor es = new ThreadPoolExecutor(corePoolSize, maximumPoolSize, keepAliveTime, TimeUnit.SECONDS, queue, new ThreadFactory(){
            AtomicInteger i = new AtomicInteger(0);

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setName("BGJOB_" + final_q.name().toUpperCase() + "_" + this.i.incrementAndGet());
                return t;
            }
        });
        es.allowCoreThreadTimeOut(allowCoreThreadTimeOut);
        logger.error((Object)("queue\uff1a " + (Object)((Object)q) + " corePoolSize: " + corePoolSize + " maximumPoolSize: " + maximumPoolSize + " keepAliveTime: " + keepAliveTime + " allowCoreThreadTimeOut: " + allowCoreThreadTimeOut));
        return es;
    }
}

