/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.service.job.core;

import com.kingdee.bos.service.job.core.Job;
import com.kingdee.bos.service.job.core.JobEvent;
import com.kingdee.bos.service.job.core.JobLoader;
import com.kingdee.bos.service.job.core.JobLog;
import com.kingdee.bos.service.job.core.JobManager;
import com.kingdee.bos.service.job.core.JobState;
import com.kingdee.bos.service.job.core.WaitingJobs;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public abstract class Returns {
    private static Logger log = Logger.getLogger((String)Returns.class.getName());
    private ArrayList messages;
    protected Object result;
    protected Throwable throwable;
    protected Object parameters;

    protected Returns(Object parameters, Object result, Throwable throwable) {
        this.result = result;
        this.parameters = parameters;
        this.throwable = throwable;
    }

    public final void pushMessage(JobLog msg) {
        if (this.messages == null) {
            this.messages = new ArrayList();
        }
        this.messages.add(msg);
    }

    public final void pushMessage(ArrayList messages) {
        if (this.messages == null) {
            this.messages = new ArrayList();
        }
        this.messages.addAll(messages);
    }

    protected boolean handleReturns(Job job) {
        if (this.messages != null && this.messages.size() > 0) {
            if (job.isPersistent()) {
                Returns.saveMessage(job, this.messages);
            } else {
                log.warn((Object)("job " + job + " is not a persistent, and it returned messages are ignored"));
            }
        }
        if (this.parameters != null) {
            job.setParameters(this.parameters);
        }
        job.setException(this.throwable);
        job.setResult(this.result);
        if (!job.setState(this.getTargetState())) {
            return false;
        }
        JobManager.instance().raiseEvent(this.getRaisedEvent(), job);
        return true;
    }

    protected abstract JobState getTargetState();

    protected abstract JobEvent getRaisedEvent();

    private static void saveMessage(Job job, ArrayList messages) {
        if (messages == null) {
            return;
        }
        String dc = job.getContext().getAIS();
        String ownerId = job.getId();
        for (int i = 0; i < messages.size(); ++i) {
            JobLog msg = (JobLog)messages.get(i);
            msg.save(dc, ownerId);
        }
    }

    protected static void send2WaitingJobsQueue(Job job) {
        if (job.isPersistent()) {
            JobLoader.newJobEnqueued(job.getContext());
        } else {
            WaitingJobs.in(job);
        }
    }

    protected static void send2SuspendedJobsCache(Job job) {
        if (job.isPersistent()) {
            return;
        }
        JobManager.instance().send2SuspendedJobCache(job);
    }
}

