/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.service.job.core;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.invokecounter.InvokeKSQLCounter;
import com.kingdee.bos.invokecounter.WorkflowSqlCounter;
import com.kingdee.bos.rpc.healthdegree.HealthDegree;
import com.kingdee.bos.rpc.healthdegree.IHealthDegree;
import com.kingdee.bos.rpc.io.server.IServer;
import com.kingdee.bos.rpc.io.server.NIOServer;
import com.kingdee.bos.rpc.io.server.ServerManager;
import com.kingdee.bos.rpc.io.server.TCPServer;
import com.kingdee.bos.service.job.core.BOSSchedulerService;
import com.kingdee.bos.service.job.core.Configuration;
import com.kingdee.bos.service.job.core.ICoreJobHandler;
import com.kingdee.bos.service.job.core.IDaemonJobHandler;
import com.kingdee.bos.service.job.core.IJobHandler;
import com.kingdee.bos.service.job.core.IWfJobHandler;
import com.kingdee.bos.service.job.core.Job;
import com.kingdee.bos.service.job.core.JobDefCache;
import com.kingdee.bos.service.job.core.JobEvent;
import com.kingdee.bos.service.job.core.JobManager;
import com.kingdee.bos.service.job.core.JobService;
import com.kingdee.bos.service.job.core.JobState;
import com.kingdee.bos.service.job.core.JobUtils;
import com.kingdee.bos.service.job.core.ReadyJobs;
import com.kingdee.bos.service.job.core.Returns;
import com.kingdee.bos.service.job.core.RunningJobs;
import com.kingdee.bos.service.job.core.SchedulerEvent;
import com.kingdee.bos.service.job.util.IListener;
import com.kingdee.bos.service.job.util.SQL;
import java.util.Date;
import org.apache.log4j.Logger;

class ThreadWorker
implements Runnable {
    private static Logger log = Logger.getLogger((String)ThreadWorker.class.getName());
    static long startTime;
    static int threadCount;
    static long processedJobCount;
    static long coreJobCount;
    static long coreTimeUsed;
    static long usedTime;
    private ReadyJobs.Queue q;
    static boolean jobLogValid;

    public static long availableTime() {
        return (System.currentTimeMillis() - startTime) * (long)threadCount;
    }

    public static long processedJobCount() {
        return processedJobCount;
    }

    public static long coreJobCount() {
        return coreJobCount;
    }

    public static long coreTimeUsed() {
        return coreTimeUsed;
    }

    public static long usedTime() {
        return usedTime;
    }

    ThreadWorker(ReadyJobs.Queue q) {
        ++threadCount;
        this.q = q;
    }

    public static boolean setJobLogValid(boolean isValid) {
        InvokeKSQLCounter.setValid((boolean)isValid);
        InvokeKSQLCounter.setFilterTime((!isValid ? 1 : 0) != 0);
        InvokeKSQLCounter.setPreOutput((boolean)isValid);
        WorkflowSqlCounter.setValid((boolean)isValid);
        WorkflowSqlCounter.setFilterTime((!isValid ? 1 : 0) != 0);
        WorkflowSqlCounter.setPreOutput((boolean)isValid);
        jobLogValid = isValid;
        return jobLogValid;
    }

    @Override
    public void run() {
        Thread thread = Thread.currentThread();
        while (true) {
            Job job = ReadyJobs.out(this.q);
            if (!BOSSchedulerService.isRunning()) break;
            ThreadWorker._execute(job, thread);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void _execute(Job job, Thread thread) {
        if (job == null) {
            return;
        }
        boolean executed = false;
        try {
            if (!RunningJobs.put(job)) {
                job = null;
                return;
            }
            Date e = job.getExpiredTime();
            if (e != null && System.currentTimeMillis() > e.getTime()) {
                job.setState(JobState.Missed);
                executed = true;
            } else {
                executed = ThreadWorker.execute(job, thread);
            }
        }
        catch (Throwable t) {
            log.error((Object)("job failed: " + job), t);
            if (t instanceof OutOfMemoryError) {
                IServer[] s = ServerManager.listServers();
                for (int i = 0; i < s.length; ++i) {
                    IHealthDegree ihd;
                    IServer is = s[i];
                    if (is instanceof TCPServer) {
                        ihd = ((TCPServer)is).getIHealthDegree();
                        if (!(ihd instanceof HealthDegree)) continue;
                        ((HealthDegree)ihd).setOom(true);
                        continue;
                    }
                    if (!(is instanceof NIOServer) || !((ihd = ((NIOServer)is).getIHealthDegree()) instanceof HealthDegree)) continue;
                    ((HealthDegree)ihd).setOom(true);
                }
            }
        }
        finally {
            RunningJobs.dispose(job);
        }
        if (executed) {
            try {
                ThreadWorker.adjustJobDef(job);
                ThreadWorker.handleReturns(job);
            }
            catch (Throwable t) {
                log.error((Object)("handler job " + job + "'s returns failed!"), t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean execute(Job job, Thread thread) {
        IJobHandler handler = job.getHandler();
        if (handler == null) {
            throw new IllegalArgumentException("has no handler!");
        }
        if (!job.resetForRun()) {
            return false;
        }
        try {
            Object result;
            block22: {
                long start;
                block21: {
                    block20: {
                        block19: {
                            job.setThread(thread);
                            SchedulerEvent.OnJobStart.raise(job);
                            JobManager.instance().raiseEvent(JobEvent.OnStarted, job);
                            start = System.currentTimeMillis();
                            if (jobLogValid) break block19;
                            if (!WorkflowSqlCounter.monitor.isValid() || !ThreadWorker.shouldLog(handler)) break block20;
                        }
                        WorkflowSqlCounter.startInvokeCount((String)(job.getHandler().toString() + job.getId()));
                    }
                    result = handler.execute(job);
                    if (jobLogValid) break block21;
                    if (!WorkflowSqlCounter.monitor.isValid() || !ThreadWorker.shouldLog(handler)) break block22;
                }
                long timespan = System.currentTimeMillis() - start;
                WorkflowSqlCounter.endInvokeCount((String)(job.getHandler().toString() + job.getId()), (long)timespan, (String)"bgjob", (String)"bgjobinstance");
            }
            job.setResult(result);
            if (!(handler instanceof ICoreJobHandler)) {
                JobService.incCompletedJobCounter();
            }
        }
        catch (Throwable t) {
            if (!(handler instanceof ICoreJobHandler)) {
                JobService.incFailedJobCounter();
            }
            job.setException(t);
            if (!job.isPersistent()) {
                log.error((Object)("execute job " + job + " failed!"), t);
            }
        }
        finally {
            job.setThread(null);
        }
        job.setFinishTime();
        JobManager.instance().raiseEvent(JobEvent.OnEnd, job);
        SchedulerEvent.OnJobEnd.raise(job);
        return true;
    }

    private static boolean shouldLog(IJobHandler handler) {
        return !(handler instanceof ICoreJobHandler) && !(handler instanceof IWfJobHandler) && !(handler instanceof IDaemonJobHandler) && (!handler.getClass().getName().contains("CleanUpInactiveNode") || handler.getClass().getName().startsWith("com.kingdee.bos.workflow"));
    }

    private static void adjustJobDef(Job job) {
        if (job.getJobDef() == null) {
            return;
        }
        if (!job.getState().equals(JobState.Complete)) {
            return;
        }
        try {
            long duration = job.getFinishTime().getTime() - job.getStartedTime().getTime();
            String sql = null;
            boolean isSmall = false;
            if (job.isSmallJob() && duration > (long)Configuration.smallJobUpBound()) {
                isSmall = false;
                sql = "update t_job_def set fissmalljob='N' where fjobdefid='" + job.getJobDefID() + "'";
            }
            if (sql != null) {
                SQL.executeUpdate(job.getContext(), sql);
                job.getJobDef().isSmallJob = isSmall;
                JobDefCache.remove(job.getContext().getAIS(), job.getJobDefID());
            }
        }
        catch (Throwable t) {
            log.warn((Object)("adjust job " + job + "'s property {isSmall} failed!"), t);
        }
    }

    static boolean handleReturns(Job job) {
        Object returns = job.getResult();
        if (returns instanceof Returns) {
            return ((Returns)returns).handleReturns(job);
        }
        if (job.getState().equals(JobState.Missed)) {
            JobManager.instance().raiseEvent(JobEvent.OnMissed, job);
            return true;
        }
        if (job.getException() != null) {
            if (job.getException().contains("OutOfMemoryError")) {
                try {
                    JobUtils.reSchedule(job.getContext(), job.getId(), 1200000);
                    return true;
                }
                catch (BOSException e) {
                    e.printStackTrace();
                }
            }
            if (!job.setState(JobState.Failed)) {
                return false;
            }
            JobManager.instance().raiseEvent(JobEvent.OnFailed, job);
            return true;
        }
        if (!job.setState(JobState.Complete)) {
            return false;
        }
        JobManager.instance().raiseEvent(JobEvent.OnComplete, job);
        return true;
    }

    static {
        SchedulerEvent.OnJobEnd.add(new JobMonitor());
        startTime = System.currentTimeMillis();
        threadCount = 0;
        coreJobCount = 0L;
        coreTimeUsed = 0L;
        jobLogValid = false;
    }

    private static class JobMonitor
    implements IListener {
        private static final long serialVersionUID = -5393662489818576104L;

        private JobMonitor() {
        }

        @Override
        public synchronized void handle(Object param) throws Exception {
            Job job = (Job)param;
            long l = job.getFinishTime().getTime() - job.getStartedTime().getTime();
            if (job.getHandler() instanceof ICoreJobHandler) {
                ++coreJobCount;
                coreTimeUsed += l;
            } else {
                ++processedJobCount;
                usedTime += l;
            }
        }
    }
}

