/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.service.job.ext;

import com.kingdee.bos.Context;
import com.kingdee.bos.service.job.core.IJobHandler;
import com.kingdee.bos.service.job.core.Job;
import com.kingdee.bos.service.job.util.SQL;
import com.kingdee.eas.util.app.DbUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;

public class BackgroundJobInstCostTime
implements IJobHandler {
    private static final long serialVersionUID = 4243167634773128161L;
    private static final int BATCH = 5000;
    private Context ctx;

    public BackgroundJobInstCostTime() {
    }

    public BackgroundJobInstCostTime(Context ctx) {
        this.ctx = ctx;
    }

    @Override
    public Object execute(Job job) throws Exception {
        this.ctx = job.getContext();
        String sql = "select top 5000 FJOBINSTID ,FSTARTEDTIME ,ffinishtime from t_job_inst where fcosttime is null and FSTATE in ('Complete','Failed') and FSTARTEDTIME is not null and ffinishtime is not null";
        String sqlHst = "select top 5000 FJOBINSTID ,FSTARTEDTIME ,ffinishtime from t_job_insthst where fcosttime is null and FSTATE in ('Complete','Failed') and FSTARTEDTIME is not null and ffinishtime is not null";
        while (this.updateCostTime(job, sql).booleanValue()) {
        }
        while (this.updateCostHstTime(job, sqlHst).booleanValue()) {
        }
        return "ok";
    }

    private Boolean updateCostTime(Job job, String sql) throws Exception {
        ArrayList list = SQL.executeQuery(job.getContext(), sql);
        if (list.size() > 0) {
            String updateSqlString = "update t_job_inst set fcosttime = ? where fjobinstid = ?";
            ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
            for (int i = 0; i < list.size(); ++i) {
                String fjobinstid = (String)((HashMap)list.get(i)).get("fjobinstid");
                Date fstartedtime = (Date)((HashMap)list.get(i)).get("fstartedtime");
                Date ffinishtime = (Date)((HashMap)list.get(i)).get("ffinishtime");
                long costTime = ffinishtime.getTime() - fstartedtime.getTime();
                Object[] o = new Object[]{costTime, fjobinstid};
                arrayList.add(o);
            }
            DbUtil.executeBatch((Context)this.ctx, (String)updateSqlString, arrayList);
        }
        return list.size() == 5000;
    }

    private Boolean updateCostHstTime(Job job, String sql) throws Exception {
        ArrayList list = SQL.executeQuery(job.getContext(), sql);
        if (list.size() > 0) {
            String updateSqlString = "update t_job_instHST set fcosttime = ? where fjobinstid = ?";
            ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
            for (int i = 0; i < list.size(); ++i) {
                String fjobinstid = (String)((HashMap)list.get(i)).get("fjobinstid");
                Date fstartedtime = (Date)((HashMap)list.get(i)).get("fstartedtime");
                Date ffinishtime = (Date)((HashMap)list.get(i)).get("ffinishtime");
                long costTime = ffinishtime.getTime() - fstartedtime.getTime();
                Object[] o = new Object[]{costTime, fjobinstid};
                arrayList.add(o);
            }
            DbUtil.executeBatch((Context)this.ctx, (String)updateSqlString, arrayList);
        }
        return list.size() == 5000;
    }
}

