/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.service.job.pulse;

import com.kingdee.bos.service.job.core.ClusterStateManager;
import com.kingdee.bos.service.job.core.ICoreJobHandler;
import com.kingdee.bos.service.job.core.IJobHandler;
import com.kingdee.bos.service.job.core.Job;
import com.kingdee.bos.service.job.pulse.TimerPulse;
import com.kingdee.bos.service.job.pulse.TimerPulseSource;
import com.kingdee.bos.service.job.returns.Delay;
import java.sql.Timestamp;
import java.util.Date;
import org.apache.log4j.Logger;

public class TimerHandler
implements IJobHandler,
ICoreJobHandler {
    private static final long serialVersionUID = 1451932426456960149L;
    private static Logger log = Logger.getLogger((String)TimerHandler.class.getName());
    private TimerPulseSource pulseSource;

    TimerHandler(TimerPulseSource pulseSource) {
        this.pulseSource = pulseSource;
    }

    @Override
    public Object execute(Job job) {
        int i = 10;
        try {
            i = this.schedule();
        }
        catch (Throwable t) {
            log.error((Object)"process timer scheduling job failed!", t);
        }
        if (this.pulseSource.getTimerJob() != job) {
            return null;
        }
        if (i < 1) {
            i = 1;
        }
        if (i > 60) {
            i = 60;
        }
        return new Delay(i);
    }

    private int schedule() {
        TimerPulse pulse;
        while ((pulse = this.pulseSource.top()) != null) {
            String dc = pulse.getDataCenter();
            ClusterStateManager cm = ClusterStateManager.get(dc);
            int scope = cm.getJobLoadingInterval() * 2;
            Timestamp now = new Timestamp(System.currentTimeMillis() + (long)(scope * 1000));
            Timestamp next = pulse.nextFireTime();
            if (next.after((Date)now)) {
                int delay = (int)(((Date)next).getTime() - ((Date)now).getTime()) / 1000 - scope;
                return delay;
            }
            pulse = this.pulseSource.pop();
            if (!pulse.fire()) continue;
            this.pulseSource.add(pulse);
        }
        return 10;
    }
}

