/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.service.job.wrapper;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.DataAccessException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.IORMappingDAO;
import com.kingdee.bos.dao.ormapping.ORMappingDAO;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.IDynamicObject;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.function.FunctionInvoke;
import com.kingdee.bos.metadata.function.FunctionObjectInfo;
import com.kingdee.bos.metadata.function.OperationCollection;
import com.kingdee.bos.metadata.function.OperationInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.util.MetaDataLoader;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class FunctionHelper {
    private static Logger log = Logger.getLogger((String)"com.kingdee.bos.workflow.biz.FunctionHelper");

    public static Object invokeAutomatic(Context ctx, String packageName, String function, String operation, Object[] parameters) throws BOSException {
        int trys = 0;
        BOSException error = null;
        while (trys++ < 10) {
            if (trys > 1) {
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            try {
                return FunctionInvoke.localInvokeNoProxy((Context)ctx, (IMetaDataPK)new MetaDataPK(packageName, function), (String)operation, (Object[])parameters);
            }
            catch (BOSException e) {
                boolean locked = false;
                for (Throwable e2 = e; e2 != null; e2 = e2.getCause()) {
                    String message = e2.getMessage();
                    if (message.contains("\u6b7b\u9501") || message.toLowerCase().contains("dead lock")) {
                        locked = true;
                        break;
                    }
                    if (e2.getCause() == e2) break;
                }
                if (!locked) {
                    throw e;
                }
                error = e;
            }
        }
        if (error != null) {
            throw error;
        }
        return null;
    }

    public static FunctionObjectInfo getFunctionObjectInfo(Context ctx, String functionFullName) throws BOSException {
        return MetaDataLoader.getFunction((Context)ctx, (IMetaDataPK)new MetaDataPK(functionFullName));
    }

    public static String getFunctionAlias(FunctionObjectInfo info) throws BOSException {
        if (info == null) {
            return null;
        }
        if (info.getAlias() == null || info.getAlias().trim().equals("")) {
            return null;
        }
        return info.getAlias();
    }

    public static String getFunctionOperationAlias(FunctionObjectInfo info, String operationName) {
        if (info == null || operationName == null || operationName.trim().equals("")) {
            return null;
        }
        OperationCollection col = info.getOperation();
        for (int i = 0; i < col.size(); ++i) {
            OperationInfo operationInfo = col.get(i);
            if (!operationInfo.getName().trim().equalsIgnoreCase(operationName.trim())) continue;
            return operationInfo.getAlias().trim();
        }
        return null;
    }

    public static void invkeManpowerUI(String packageName, String function, String operation, Object[] parameters) {
    }

    public static ObjectUuidPK createPKbyBoId(String boid) {
        if (boid == null || boid.length() == 0) {
            return null;
        }
        return new ObjectUuidPK(boid);
    }

    public static IObjectValue createObjectValueByBoId(String boid, Context ctx) throws BOSException {
        String bosType = BOSUuid.read((String)boid).getType().toString();
        if ("63D30103".equals(bosType)) {
            return FunctionHelper.createObjectValueByBoId_Dynamic(boid, ctx);
        }
        ObjectUuidPK pk = FunctionHelper.createPKbyBoId(boid);
        IORMappingDAO dao = null;
        IObjectValue model = null;
        Connection cn = null;
        try {
            cn = EJBFactory.getConnection((Context)ctx);
            dao = ORMappingDAO.getInstance((BOSObjectType)pk.getObjectType(), (Context)ctx, (Connection)cn);
            model = dao.getValue((IObjectPK)pk);
        }
        catch (DataAccessException e) {
            log.error((Object)"createObjectValueByBoId throw DataAccessException error", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        catch (SQLException e) {
            log.error((Object)"createObjectValueByBoId throw SQLException error", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
        }
        return model;
    }

    public static IObjectValue createObjectValueByBoId_Dynamic(String boid, Context ctx) throws BOSException {
        ObjectUuidPK pk = FunctionHelper.createPKbyBoId(boid);
        IObjectValue model = null;
        try {
            IDynamicObject dynamicObject = DynamicObjectFactory.getLocalInstance((Context)ctx);
            model = dynamicObject.getValue(pk.getObjectType(), (IObjectPK)pk);
        }
        catch (DataAccessException e) {
            String msg = "createObjectValueByBoId throw DataAccessException error";
            log.error((Object)msg, (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        catch (BOSException e) {
            throw new BOSException((Throwable)e);
        }
        return model;
    }

    public static IObjectValue createObjectValueByBoId(String boid, Context ctx, SelectorItemCollection selectors) throws BOSException {
        String bosType = BOSUuid.read((String)boid).getType().toString();
        if ("63D30103".equals(bosType)) {
            return FunctionHelper.createObjectValueByBoId_Dynamic(boid, ctx, selectors);
        }
        ObjectUuidPK pk = FunctionHelper.createPKbyBoId(boid);
        IORMappingDAO dao = null;
        IObjectValue model = null;
        Connection cn = null;
        try {
            cn = EJBFactory.getConnection((Context)ctx);
            dao = ORMappingDAO.getInstance((BOSObjectType)pk.getObjectType(), (Context)ctx, (Connection)cn);
            model = dao.getValue((IObjectPK)pk, selectors, true);
        }
        catch (DataAccessException e) {
            log.error((Object)"createObjectValueByBoId throw DataAccessException error", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        catch (SQLException e) {
            log.error((Object)"createObjectValueByBoId throw SQLException error", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
        }
        return model;
    }

    public static IObjectValue createObjectValueByBoId_Dynamic(String boid, Context ctx, SelectorItemCollection selectors) throws BOSException {
        ObjectUuidPK pk = FunctionHelper.createPKbyBoId(boid);
        IObjectValue model = null;
        try {
            IDynamicObject dynamicObject = DynamicObjectFactory.getLocalInstance((Context)ctx);
            model = dynamicObject.getValue(pk.getObjectType(), (IObjectPK)pk, selectors);
        }
        catch (DataAccessException e) {
            String msg = "createObjectValueByBoId throw DataAccessException error";
            log.error((Object)msg, (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return model;
    }

    public static IObjectCollection createObjectCollectionByBoIds(String ids, Context ctx) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)ids, CompareType.INCLUDE));
        view.setFilter(filterInfo);
        IORMappingDAO dao = null;
        IObjectCollection model = null;
        Connection cn = null;
        String boId = null;
        boId = ids.indexOf(",") > 0 ? ids.substring(0, ids.indexOf(",")) : ids;
        ObjectUuidPK pk = FunctionHelper.createPKbyBoId(boId);
        try {
            cn = EJBFactory.getConnection((Context)ctx);
            dao = ORMappingDAO.getInstance((BOSObjectType)pk.getObjectType(), (Context)ctx, (Connection)cn);
            model = dao.getCollection(view);
        }
        catch (SQLException e) {
            log.error((Object)"createORMappingDAOByBosType throw SQLException error", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
        }
        return model;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IObjectValue createObjectValueByEntityTypeAndBoid(String entityType, String boid, Context ctx) throws BOSException {
        String bosType = BOSUuid.read((String)boid).getType().toString();
        if ("63D30103".equals(bosType)) {
            return FunctionHelper.createObjectValueByBoId_Dynamic(boid, ctx);
        }
        ObjectUuidPK pk = FunctionHelper.createPKbyBoId(boid);
        IORMappingDAO dao = null;
        IObjectValue model = null;
        Connection cn = null;
        try {
            EntityObjectInfo e = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity((IMetaDataPK)new MetaDataPK(entityType));
            cn = EJBFactory.getConnection((Context)ctx);
            dao = ORMappingDAO.getInstance((BOSObjectType)e.getType(), (Context)ctx, (Connection)cn);
            model = dao.getValue((IObjectPK)pk);
        }
        catch (DataAccessException e) {
            try {
                log.error((Object)"createObjectValueByBoId throw DataAccessException error", (Throwable)e);
                throw new BOSException((Throwable)e);
                catch (SQLException e2) {
                    log.error((Object)"createObjectValueByBoId throw SQLException error", (Throwable)e2);
                    throw new BOSException((Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Connection)cn);
        return model;
    }

    public static IObjectCollection createObjectCollectionByEntityTypeAndBoids(String entityType, String ids, Context ctx) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)ids, CompareType.INCLUDE));
        view.setFilter(filterInfo);
        IORMappingDAO dao = null;
        IObjectCollection model = null;
        Connection cn = null;
        try {
            EntityObjectInfo e = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity((IMetaDataPK)new MetaDataPK(entityType));
            cn = EJBFactory.getConnection((Context)ctx);
            dao = ORMappingDAO.getInstance((BOSObjectType)e.getType(), (Context)ctx, (Connection)cn);
            model = dao.getCollection(view);
        }
        catch (SQLException e) {
            try {
                log.error((Object)"createORMappingDAOByBosType throw SQLException error", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Connection)cn);
        return model;
    }
}

