/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.service.scheduler;

import com.kingdee.bos.service.scheduler.BOSMSSQLDelegate;
import java.util.Collection;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SchedulerFactory;
import org.quartz.core.JobRunShellFactory;
import org.quartz.core.QuartzScheduler;
import org.quartz.core.QuartzSchedulerResources;
import org.quartz.impl.SchedulerRepository;
import org.quartz.impl.StdJobRunShellFactory;
import org.quartz.impl.StdScheduler;
import org.quartz.impl.jdbcjobstore.InvalidConfigurationException;
import org.quartz.impl.jdbcjobstore.JobStoreCMT;
import org.quartz.simpl.CascadingClassLoadHelper;
import org.quartz.simpl.SimpleThreadPool;
import org.quartz.spi.ClassLoadHelper;
import org.quartz.spi.JobStore;
import org.quartz.spi.ThreadPool;
import org.quartz.utils.ConnectionProvider;
import org.quartz.utils.DBConnectionManager;
import org.quartz.utils.JNDIConnectionProvider;

public class MultiSchedulerFactory
implements SchedulerFactory {
    public static final String DEFAULT_INSTANCE_ID = "SIMPLE_NON_CLUSTERED";
    public static final String DEFAULT_SCHEDULER_NAME = "SimpleQuartzScheduler";
    public static final String DEFAULT_AIS_INSTANCE_ID = "BOS_INSTANCE";
    public static final String SCHEDULER_NAME_BOS_PREFIX = "BOSScheduler_";
    public static final String DATASOURCE_PREFIX = "BOSDatasource_";
    private static int IDEL_WAITE_TIME = -1;
    private static int WORK_THREAD_POOL_SIZE = 5;
    public static final String JDBC_DELEGATE_CLASSNAME_MSSQL = BOSMSSQLDelegate.class.getName();
    private boolean initialized = false;
    private static MultiSchedulerFactory instance = new MultiSchedulerFactory();
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.bos.service.scheduler.MultiSchedulerFactory");

    public static int IDEL_WAITE_TIME() {
        return IDEL_WAITE_TIME;
    }

    public static void IDEL_WAITE_TIME(int i) {
        IDEL_WAITE_TIME = i;
    }

    public static int WORK_THREAD_POOL_SIZE() {
        return WORK_THREAD_POOL_SIZE;
    }

    public static void WORK_THREAD_POOL_SIZE(int i) {
        WORK_THREAD_POOL_SIZE = i;
    }

    private static Logger getLog() {
        return logger;
    }

    protected MultiSchedulerFactory() {
    }

    public void createScheduler(String aisName, String dataSource, String jndiUrl, String contextFactory, String securityCredential, String securityPrincipal) throws SchedulerException {
        String jndiName = null;
        jndiName = dataSource == null ? "jdbc/" + aisName : dataSource;
        String datasourceName = DATASOURCE_PREFIX + aisName;
        Properties jndiProps = new Properties();
        if (jndiUrl != null) {
            jndiProps.setProperty("java.naming.provider.url", jndiUrl);
        }
        if (contextFactory != null) {
            jndiProps.setProperty("java.naming.factory.initial", contextFactory);
        }
        if (securityCredential != null) {
            jndiProps.setProperty("java.naming.security.credentials", securityCredential);
        }
        if (securityPrincipal != null) {
            jndiProps.setProperty("java.naming.security.principal", securityPrincipal);
        }
        JNDIConnectionProvider jndiConnectionProvider = new JNDIConnectionProvider(jndiName, jndiProps, false);
        DBConnectionManager.getInstance().addConnectionProvider(datasourceName, (ConnectionProvider)jndiConnectionProvider);
        JobStoreCMT jdbcJobStore = new JobStoreCMT();
        jdbcJobStore.setDontSetAutoCommitFalse(true);
        jdbcJobStore.setDataSource(datasourceName);
        jdbcJobStore.setNonManagedTXDataSource(datasourceName);
        jdbcJobStore.setDontSetNonManagedTXConnectionAutoCommitFalse(true);
        jdbcJobStore.setUseDBLocks(true);
        jdbcJobStore.setTablePrefix("T_QRTZ_");
        jdbcJobStore.setInstanceId(DEFAULT_AIS_INSTANCE_ID);
        try {
            jdbcJobStore.setDriverDelegateClass(JDBC_DELEGATE_CLASSNAME_MSSQL);
        }
        catch (InvalidConfigurationException e) {
            throw new SchedulerException("cannot load DriverDelegateClass while create scheduler for AIS " + aisName, (Throwable)e);
        }
        SimpleThreadPool threadPool = new SimpleThreadPool();
        threadPool.setThreadCount(WORK_THREAD_POOL_SIZE);
        threadPool.initialize();
        this.createScheduler(SCHEDULER_NAME_BOS_PREFIX + aisName, DEFAULT_AIS_INSTANCE_ID, (ThreadPool)threadPool, (JobStore)jdbcJobStore, IDEL_WAITE_TIME);
    }

    private void createScheduler(String schedulerName, String schedulerInstanceId, ThreadPool threadPool, JobStore jobStore, int idleWaitTime) throws SchedulerException {
        StdJobRunShellFactory jrsf = new StdJobRunShellFactory();
        QuartzSchedulerResources qrs = new QuartzSchedulerResources();
        qrs.setName(schedulerName);
        qrs.setInstanceId(schedulerInstanceId);
        qrs.setJobRunShellFactory((JobRunShellFactory)jrsf);
        qrs.setThreadPool(threadPool);
        qrs.setJobStore(jobStore);
        QuartzScheduler qs = new QuartzScheduler(qrs, (long)idleWaitTime, 0L);
        CascadingClassLoadHelper cch = new CascadingClassLoadHelper();
        cch.initialize();
        jobStore.initialize((ClassLoadHelper)cch, qs.getSchedulerSignaler());
        StdScheduler scheduler = new StdScheduler(qs);
        jrsf.initialize((Scheduler)scheduler);
        MultiSchedulerFactory.getLog().debug((Object)("Quartz scheduler '" + scheduler.getSchedulerName() + "'"));
        MultiSchedulerFactory.getLog().debug((Object)("Quartz scheduler version: " + qs.getVersion()));
        SchedulerRepository schedRep = SchedulerRepository.getInstance();
        qs.addNoGCObject((Object)schedRep);
        schedRep.bind((Scheduler)scheduler);
    }

    public Scheduler getScheduler() throws SchedulerException {
        if (!this.initialized) {
            throw new SchedulerException("you must call createRemoteScheduler or createScheduler methods before calling getScheduler()");
        }
        SchedulerRepository schedRep = SchedulerRepository.getInstance();
        Scheduler sched = schedRep.lookup(DEFAULT_SCHEDULER_NAME);
        return sched;
    }

    public Scheduler getScheduler(String aisName) {
        SchedulerRepository schedRep = SchedulerRepository.getInstance();
        Scheduler sched = schedRep.lookup(SCHEDULER_NAME_BOS_PREFIX + aisName);
        if (sched == null) {
            MultiSchedulerFactory.getLog().warn((Object)("Scheduler instance not found with AIS name '" + aisName + "'"));
        }
        return sched;
    }

    public Collection getAllSchedulers() throws SchedulerException {
        return SchedulerRepository.getInstance().lookupAll();
    }

    public static MultiSchedulerFactory getInstance() {
        return instance;
    }

    public static void main(String[] args) throws Exception {
        MultiSchedulerFactory.getInstance().createScheduler("Demo", "jdbc/Demo", "iiop://localhost:6888", "com.apusic.naming.jndi.CNContextFactory", "admin", "admin");
        MultiSchedulerFactory.getInstance().getScheduler("Demo").start();
    }
}

