/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.support.quartz;

import com.kingdee.bos.support.quartz.JDBCConnector;
import com.kingdee.bos.support.quartz.JDBCJobStore;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import org.apache.log4j.Logger;
import org.quartz.Calendar;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.JobPersistenceException;
import org.quartz.ObjectAlreadyExistsException;
import org.quartz.Trigger;
import org.quartz.TriggerKey;
import org.quartz.impl.matchers.GroupMatcher;
import org.quartz.spi.OperableTrigger;
import org.quartz.spi.TriggerFiredResult;

public class JNDIJobStore
extends JDBCJobStore {
    private static final Logger logger = Logger.getLogger(JNDIJobStore.class);
    private static Map dataSourceCache = new HashMap();
    private String innerJndiURL;
    private String innerUrl;
    private String innerInitial;
    private String innerCredentials;
    private String innerPrincipal;

    private void debugConnection(Connection cn) {
        try {
            if (!cn.getAutoCommit()) {
                logger.error((Object)("The connection autoCommit state : " + cn.getAutoCommit()));
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    @Override
    protected JDBCConnector createJDBCConnector() throws Exception {
        this.validate();
        return new Connector();
    }

    public String getCredentials() {
        return this.innerCredentials;
    }

    public void setCredentials(String credentials) {
        this.innerCredentials = credentials;
    }

    public String getInitial() {
        return this.innerInitial;
    }

    public void setInitial(String initial) {
        this.innerInitial = initial;
    }

    public String getJndiURL() {
        return this.innerJndiURL;
    }

    public void setJndiURL(String jndiURL) {
        this.innerJndiURL = jndiURL;
    }

    public String getPrincipal() {
        return this.innerPrincipal;
    }

    public void setPrincipal(String principal) {
        this.innerPrincipal = principal;
    }

    public String getUrl() {
        return this.innerUrl;
    }

    public void setUrl(String url) {
        this.innerUrl = url;
    }

    private boolean validate() {
        logger.debug((Object)("innerJndiURL=" + this.innerJndiURL));
        logger.debug((Object)("innerUrl=" + this.innerUrl));
        logger.debug((Object)("innerInitial=" + this.innerInitial));
        logger.debug((Object)("innerCredentials=" + this.innerCredentials));
        logger.debug((Object)("innerPrincipal=" + this.innerPrincipal));
        if (this.isNull(this.innerJndiURL)) {
            throw new IllegalArgumentException("\"innerJndiURL\" is null!");
        }
        if (this.isNull(this.innerInitial)) {
            throw new IllegalArgumentException("\"innerInitial\" is null!");
        }
        if (this.isNull(this.innerCredentials)) {
            throw new IllegalArgumentException("\"innerCredentials\" is null!");
        }
        if (this.isNull(this.innerPrincipal)) {
            throw new IllegalArgumentException("\"innerPrincipal\" is null!");
        }
        return true;
    }

    private boolean isNull(String value) {
        if (value == null) {
            return true;
        }
        return value.trim().length() == 0;
    }

    public List<OperableTrigger> acquireNextTriggers(long paramLong1, int paramInt, long paramLong2) throws JobPersistenceException {
        return null;
    }

    public boolean checkExists(JobKey paramJobKey) throws JobPersistenceException {
        return false;
    }

    public boolean checkExists(TriggerKey paramTriggerKey) throws JobPersistenceException {
        return false;
    }

    public void clearAllSchedulingData() throws JobPersistenceException {
    }

    public long getAcquireRetryDelay(int paramInt) {
        return 0L;
    }

    @Override
    public List<String> getCalendarNames() throws JobPersistenceException {
        return null;
    }

    public long getEstimatedTimeToReleaseAndAcquireTrigger() {
        return 0L;
    }

    @Override
    public List<String> getJobGroupNames() throws JobPersistenceException {
        return null;
    }

    public Set<JobKey> getJobKeys(GroupMatcher<JobKey> paramGroupMatcher) throws JobPersistenceException {
        return null;
    }

    @Override
    public int getNumberOfCalendars() throws JobPersistenceException {
        return 0;
    }

    @Override
    public int getNumberOfJobs() throws JobPersistenceException {
        return 0;
    }

    @Override
    public int getNumberOfTriggers() throws JobPersistenceException {
        return 0;
    }

    @Override
    public Set<String> getPausedTriggerGroups() throws JobPersistenceException {
        return null;
    }

    @Override
    public List<String> getTriggerGroupNames() throws JobPersistenceException {
        return null;
    }

    public Set<TriggerKey> getTriggerKeys(GroupMatcher<TriggerKey> paramGroupMatcher) throws JobPersistenceException {
        return null;
    }

    public Trigger.TriggerState getTriggerState(TriggerKey paramTriggerKey) throws JobPersistenceException {
        return null;
    }

    public List<OperableTrigger> getTriggersForJob(JobKey paramJobKey) throws JobPersistenceException {
        return null;
    }

    public boolean isClustered() {
        return false;
    }

    @Override
    public void pauseAll() throws JobPersistenceException {
    }

    public void pauseJob(JobKey paramJobKey) throws JobPersistenceException {
    }

    public Collection<String> pauseJobs(GroupMatcher<JobKey> paramGroupMatcher) throws JobPersistenceException {
        return null;
    }

    public void pauseTrigger(TriggerKey paramTriggerKey) throws JobPersistenceException {
    }

    public Collection<String> pauseTriggers(GroupMatcher<TriggerKey> paramGroupMatcher) throws JobPersistenceException {
        return null;
    }

    public void releaseAcquiredTrigger(OperableTrigger paramOperableTrigger) {
    }

    public boolean removeJob(JobKey paramJobKey) throws JobPersistenceException {
        return false;
    }

    public boolean removeJobs(List<JobKey> paramList) throws JobPersistenceException {
        return false;
    }

    public boolean removeTrigger(TriggerKey paramTriggerKey) throws JobPersistenceException {
        return false;
    }

    public boolean removeTriggers(List<TriggerKey> paramList) throws JobPersistenceException {
        return false;
    }

    public boolean replaceTrigger(TriggerKey paramTriggerKey, OperableTrigger paramOperableTrigger) throws JobPersistenceException {
        return false;
    }

    public void resetTriggerFromErrorState(TriggerKey paramTriggerKey) throws JobPersistenceException {
    }

    @Override
    public void resumeAll() throws JobPersistenceException {
    }

    public void resumeJob(JobKey paramJobKey) throws JobPersistenceException {
    }

    public Collection<String> resumeJobs(GroupMatcher<JobKey> paramGroupMatcher) throws JobPersistenceException {
        return null;
    }

    public void resumeTrigger(TriggerKey paramTriggerKey) throws JobPersistenceException {
    }

    public Collection<String> resumeTriggers(GroupMatcher<TriggerKey> paramGroupMatcher) throws JobPersistenceException {
        return null;
    }

    @Override
    public Calendar retrieveCalendar(String paramString) throws JobPersistenceException {
        return null;
    }

    public JobDetail retrieveJob(JobKey paramJobKey) throws JobPersistenceException {
        return null;
    }

    public OperableTrigger retrieveTrigger(TriggerKey paramTriggerKey) throws JobPersistenceException {
        return null;
    }

    public void schedulerPaused() {
    }

    public void schedulerResumed() {
    }

    public void setInstanceId(String paramString) {
    }

    public void setInstanceName(String paramString) {
    }

    public void setThreadPoolSize(int paramInt) {
    }

    @Override
    public void storeCalendar(String paramString, Calendar paramCalendar, boolean paramBoolean1, boolean paramBoolean2) throws ObjectAlreadyExistsException, JobPersistenceException {
    }

    @Override
    public void storeJob(JobDetail paramJobDetail, boolean paramBoolean) throws ObjectAlreadyExistsException, JobPersistenceException {
    }

    public void storeJobAndTrigger(JobDetail paramJobDetail, OperableTrigger paramOperableTrigger) throws ObjectAlreadyExistsException, JobPersistenceException {
    }

    public void storeJobsAndTriggers(Map<JobDetail, Set<? extends Trigger>> paramMap, boolean paramBoolean) throws ObjectAlreadyExistsException, JobPersistenceException {
    }

    public void storeTrigger(OperableTrigger paramOperableTrigger, boolean paramBoolean) throws ObjectAlreadyExistsException, JobPersistenceException {
    }

    public void triggeredJobComplete(OperableTrigger paramOperableTrigger, JobDetail paramJobDetail, Trigger.CompletedExecutionInstruction paramCompletedExecutionInstruction) {
    }

    public List<TriggerFiredResult> triggersFired(List<OperableTrigger> paramList) throws JobPersistenceException {
        return null;
    }

    private class Connector
    implements JDBCConnector {
        private Connection cn = null;

        private Connector() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Connection getConnection() throws Exception {
            boolean isClosed;
            if (this.cn != null && !(isClosed = this.cn.isClosed())) {
                JNDIJobStore.this.debugConnection(this.cn);
                return this.cn;
            }
            String jndiUrl = JNDIJobStore.this.getJndiURL();
            DataSource datasource = null;
            Map map = dataSourceCache;
            synchronized (map) {
                datasource = (DataSource)dataSourceCache.get(jndiUrl);
                if (datasource == null) {
                    datasource = this.getDataSource(jndiUrl);
                    dataSourceCache.put(jndiUrl, datasource);
                }
            }
            try {
                this.cn = datasource.getConnection();
            }
            catch (SQLException sqle) {
                this.cn = this.ensureDataSource(jndiUrl).getConnection();
            }
            JNDIJobStore.this.debugConnection(this.cn);
            return this.cn;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Connection getNewConnection() throws Exception {
            Connection cn;
            String jndiUrl = JNDIJobStore.this.getJndiURL();
            DataSource datasource = null;
            Map map = dataSourceCache;
            synchronized (map) {
                datasource = (DataSource)dataSourceCache.get(jndiUrl);
                if (datasource == null) {
                    datasource = this.getDataSource(jndiUrl);
                    dataSourceCache.put(jndiUrl, datasource);
                }
            }
            try {
                cn = datasource.getConnection();
            }
            catch (SQLException sqle) {
                cn = this.ensureDataSource(jndiUrl).getConnection();
            }
            JNDIJobStore.this.debugConnection(cn);
            return cn;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private DataSource ensureDataSource(String jndiUrl) throws Exception {
            Map map = dataSourceCache;
            synchronized (map) {
                DataSource datasource = this.getDataSource(jndiUrl);
                dataSourceCache.put(jndiUrl, datasource);
                return datasource;
            }
        }

        private DataSource getDataSource(String jndiUrl) throws Exception {
            Hashtable<String, String> env = new Hashtable<String, String>();
            env.put("java.naming.factory.initial", JNDIJobStore.this.getInitial());
            if (JNDIJobStore.this.getUrl() != null) {
                env.put("java.naming.provider.url", JNDIJobStore.this.getUrl());
            }
            env.put("java.naming.security.credentials", JNDIJobStore.this.getCredentials());
            env.put("java.naming.security.principal", JNDIJobStore.this.getPrincipal());
            InitialContext initCtx = new InitialContext(env);
            return (DataSource)initCtx.lookup(jndiUrl);
        }

        @Override
        public void commit() throws Exception {
            if (this.cn != null) {
                this.cn.close();
                this.cn = null;
            }
        }

        @Override
        public void rollback() throws Exception {
            if (this.cn != null) {
                this.cn.close();
                this.cn = null;
            }
        }

        @Override
        public void close() throws Exception {
            if (this.cn != null) {
                this.cn.close();
                this.cn = null;
            }
        }
    }
}

