/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.support.quartz.impl;

import com.kingdee.bos.support.quartz.JDBCConnector;
import com.kingdee.bos.support.quartz.impl.BatchUpdater;
import com.kingdee.bos.support.quartz.impl.JobWrapper;
import com.kingdee.bos.support.quartz.impl.QuartzObjectInputStream;
import com.kingdee.bos.support.quartz.impl.TriggerAndJobs;
import com.kingdee.bos.support.quartz.impl.TriggerWrapper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;
import org.quartz.Calendar;
import org.quartz.JobDetail;
import org.quartz.Trigger;
import org.quartz.spi.ClassLoadHelper;

public class JDBCJobStoreHelper
extends BatchUpdater {
    private static Logger logger = Logger.getLogger(JDBCJobStoreHelper.class);
    protected final JDBCConnector connector;
    protected ClassLoadHelper loadHelper = null;

    public JDBCJobStoreHelper(JDBCConnector connector) {
        this.connector = connector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void finalDeleteCalendar(String name) throws Exception {
        Connection cn = this.connector.getConnection();
        String sql = "delete from T_QTZ_Calendars where FName=?";
        PreparedStatement stm = cn.prepareStatement(sql);
        try {
            stm.setString(1, name);
            stm.executeUpdate();
        }
        finally {
            this.closeStatement(stm);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void finalDeleteJob(String group, String name) throws Exception {
        Connection cn = this.connector.getConnection();
        String sql = "delete from T_QTZ_Jobs where FJobGroup=? and FJobName=?";
        PreparedStatement stm = cn.prepareStatement(sql);
        try {
            stm.setString(1, group);
            stm.setString(2, name);
            stm.executeUpdate();
        }
        finally {
            this.closeStatement(stm);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void finalDeleteTrigger(String group, String name) throws Exception {
        Connection cn = this.connector.getConnection();
        String sql = "delete from T_QTZ_Triggers where FTriggerGroup=? and FTriggerName=?";
        PreparedStatement stm = cn.prepareStatement(sql);
        try {
            stm.setString(1, group);
            stm.setString(2, name);
            stm.executeUpdate();
        }
        finally {
            this.closeStatement(stm);
        }
    }

    private void setObjectData(int index, Object x, PreparedStatement stm) throws Exception {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(bout);
        out.writeObject(x);
        out.close();
        byte[] data = bout.toByteArray();
        stm.setBinaryStream(index, (InputStream)new ByteArrayInputStream(data), data.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void finalUpdateCalendar(String name, Calendar cal) throws Exception {
        Connection cn = this.connector.getConnection();
        String sql = null;
        PreparedStatement stm = null;
        String[] parameters = new String[]{"FName"};
        String[] values = new String[]{name};
        try {
            if (this.isSaved("T_QTZ_Calendars", parameters, values)) {
                sql = "update T_QTZ_Calendars set FData=? where FName=?";
                stm = cn.prepareStatement(sql);
                this.setObjectData(1, cal, stm);
                stm.setString(2, name);
                stm.executeUpdate();
            } else {
                sql = "insert into T_QTZ_Calendars(FName, FData) values(?,?)";
                stm = cn.prepareStatement(sql);
                stm.setString(1, name);
                this.setObjectData(2, cal, stm);
                stm.executeUpdate();
            }
            this.closeStatement(stm);
        }
        catch (Throwable throwable) {
            this.closeStatement(stm);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void finalUpdateJob(JobDetail job) throws Exception {
        Connection cn = this.connector.getConnection();
        String sql = null;
        PreparedStatement stm = null;
        String[] parameters = new String[]{"FJobGroup", "FJobName"};
        String[] values = new String[]{job.getKey().getGroup(), job.getKey().getName()};
        try {
            if (this.isSaved("T_QTZ_Jobs", parameters, values)) {
                sql = "update T_QTZ_Jobs set FData=? where FJobGroup=? and FJobName=?";
                stm = cn.prepareStatement(sql);
                this.setObjectData(1, job, stm);
                stm.setString(2, job.getKey().getGroup());
                stm.setString(3, job.getKey().getName());
                stm.executeUpdate();
            } else {
                sql = "insert into T_QTZ_Jobs(FJobGroup, FJobName, FData) values(?,?,?)";
                stm = cn.prepareStatement(sql);
                stm.setString(1, job.getKey().getGroup());
                stm.setString(2, job.getKey().getName());
                this.setObjectData(3, job, stm);
                stm.executeUpdate();
            }
            this.closeStatement(stm);
        }
        catch (Throwable throwable) {
            this.closeStatement(stm);
            throw throwable;
        }
    }

    @Override
    protected void finalUpdateTrigger(Trigger trigger, int state) throws Exception {
        Connection cn = this.connector.getConnection();
        Statement stm = null;
        String sql = null;
        String[] parameters = new String[]{"FTriggerGroup", "FTriggerName"};
        String[] values = new String[]{trigger.getKey().getGroup(), trigger.getKey().getName()};
        try {
            if (this.isSaved("T_QTZ_Triggers", parameters, values)) {
                sql = "update T_QTZ_Triggers set FState=?,FData=? where FTriggerGroup=? and FTriggerName=?";
                stm = cn.prepareStatement(sql);
                stm.setInt(1, state);
                this.setObjectData(2, trigger, (PreparedStatement)stm);
                stm.setString(3, trigger.getKey().getGroup());
                stm.setString(4, trigger.getKey().getName());
                stm.executeUpdate();
            } else {
                sql = "insert into T_QTZ_Triggers(FTriggerGroup, FTriggerName, FState, FData) values(?,?,?,?)";
                stm = cn.prepareStatement(sql);
                stm.setString(1, trigger.getKey().getGroup());
                stm.setString(2, trigger.getKey().getName());
                stm.setInt(3, state);
                this.setObjectData(4, trigger, (PreparedStatement)stm);
                stm.executeUpdate();
            }
        }
        catch (SQLException e) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("TriggerGroup:" + trigger.getKey().getGroup());
            buffer.append(";");
            buffer.append("TriggerName:" + trigger.getKey().getName());
            String message = buffer.toString();
            logger.error((Object)message, (Throwable)e);
            throw e;
        }
        finally {
            if (stm != null) {
                stm.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void finalUpdateTriggerState(String group, String name, int state) throws Exception {
        Connection cn = this.connector.getConnection();
        String sql = "update T_QTZ_Triggers set FState=? where FTriggerGroup=? and FTriggerName=?";
        try (PreparedStatement stm = cn.prepareStatement(sql);){
            stm.setInt(1, state);
            stm.setString(2, group);
            stm.setString(3, name);
            stm.executeUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TriggerAndJobs initialize(ClassLoadHelper loadHelper) throws Exception {
        this.loadHelper = loadHelper;
        Connection cn = this.connector.getConnection();
        boolean succeeded = false;
        try {
            TriggerAndJobs r = this.loadAll(cn);
            this.connector.commit();
            succeeded = true;
            TriggerAndJobs triggerAndJobs = r;
            return triggerAndJobs;
        }
        catch (InvalidClassException e) {
            TriggerAndJobs r = new TriggerAndJobs();
            this.connector.commit();
            succeeded = true;
            TriggerAndJobs triggerAndJobs = r;
            return triggerAndJobs;
        }
        finally {
            if (!succeeded) {
                this.connector.rollback();
            }
        }
    }

    private void closeStatement(Statement stm) {
        try {
            stm.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void closeResultSet(ResultSet rs) {
        try {
            rs.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    protected void commitTrans() throws Exception {
        this.connector.commit();
    }

    @Override
    protected void rollbackTrans() throws Exception {
        this.connector.rollback();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TriggerAndJobs loadAll(Connection cn) throws Exception {
        TriggerAndJobs store = new TriggerAndJobs();
        Statement stm = cn.createStatement();
        try {
            String sql = "select FName, FData from T_QTZ_Calendars";
            ResultSet rs = stm.executeQuery(sql);
            try {
                this.loadCalendars(rs, store);
            }
            finally {
                this.closeResultSet(rs);
            }
            sql = "select FData from T_QTZ_Jobs";
            rs = stm.executeQuery(sql);
            try {
                this.loadJobs(rs, store);
            }
            finally {
                this.closeResultSet(rs);
            }
            sql = "select FState, FData from T_QTZ_Triggers";
            rs = stm.executeQuery(sql);
            try {
                this.loadTriggers(rs, store);
            }
            finally {
                this.closeResultSet(rs);
            }
        }
        finally {
            this.closeStatement(stm);
        }
        return store;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadCalendars(ResultSet rs, TriggerAndJobs store) throws Exception {
        ObjectInputStream in = null;
        while (rs.next()) {
            try {
                String name = rs.getString("FName");
                in = new QuartzObjectInputStream(rs.getBinaryStream("FData"), this.loadHelper);
                Calendar cal = (Calendar)in.readObject();
                store.calendars.put(name, cal);
            }
            finally {
                try {
                    if (in == null) continue;
                    in.close();
                }
                catch (IOException e) {
                    logger.error((Object)"ObjectInputStream close error!", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadJobs(ResultSet rs, TriggerAndJobs store) throws Exception {
        ObjectInputStream in = null;
        while (rs.next()) {
            try {
                in = new QuartzObjectInputStream(rs.getBinaryStream("FData"), this.loadHelper);
                JobDetail jd = (JobDetail)in.readObject();
                store.addJob(new JobWrapper(jd));
            }
            finally {
                try {
                    if (in == null) continue;
                    in.close();
                }
                catch (IOException e) {
                    logger.error((Object)"ObjectInputStream close error!", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadTriggers(ResultSet rs, TriggerAndJobs store) throws Exception {
        ObjectInputStream in = null;
        while (rs.next()) {
            try {
                int state = rs.getInt("FState");
                in = new QuartzObjectInputStream(rs.getBinaryStream("FData"), this.loadHelper);
                Trigger trigger = (Trigger)in.readObject();
                TriggerWrapper tw = new TriggerWrapper(trigger);
                tw.state = state;
                store.addTrigger(tw);
            }
            finally {
                try {
                    if (in == null) continue;
                    in.close();
                }
                catch (IOException e) {
                    logger.error((Object)"ObjectInputStream close error!", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isSaved(String tableName, String[] parameters, String[] values) throws Exception {
        Connection cn = this.connector.getConnection();
        StringBuffer sql = new StringBuffer();
        sql.append("select " + parameters[0] + " from " + tableName + " where ");
        int size = parameters.length - 1;
        for (int i = 0; i <= size; ++i) {
            sql.append(parameters[i]);
            sql.append("=?");
            if (i == size) continue;
            sql.append(" and ");
        }
        try (PreparedStatement stm = cn.prepareStatement(sql.toString());){
            boolean bl;
            int size2 = values.length;
            for (int i = 1; i <= size2; ++i) {
                stm.setString(i, values[i - 1]);
            }
            ResultSet rs = stm.executeQuery();
            if (rs.next()) {
                bl = true;
                return bl;
            }
            bl = false;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void deleteAllJobsAndTriggers() {
        String[] tables = new String[]{"T_QRTZ_BLOB_TRIGGERS", "T_QRTZ_CALENDARS", "T_QRTZ_FIRED_TRIGGERS", "T_QRTZ_PAUSED_TRIGGER_GRPS", "T_QRTZ_SCHEDULER_STATE", "T_QRTZ_CRON_TRIGGERS", "T_QRTZ_SIMPLE_TRIGGERS", "T_QRTZ_TRIGGER_LISTENERS", "T_QRTZ_TRIGGERS", "T_QRTZ_JOB_LISTENERS", "T_QRTZ_JOB_DETAILS", "T_QTZ_JOBS", "T_QTZ_TRIGGERS"};
        StringBuffer sql = new StringBuffer();
        int size = tables.length;
        for (int i = 0; i < size; ++i) {
            sql.append(" delete from ");
            sql.append(tables[i]);
            sql.append("; ");
        }
        PreparedStatement stmt = null;
        try {
            Connection cn = this.connector.getConnection();
            stmt = cn.prepareStatement(sql.toString());
            stmt.executeUpdate();
            cn.commit();
            this.closeStatement(stmt);
            return;
        }
        catch (Exception exception) {
            return;
        }
        finally {
            this.closeStatement(stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void finalCheckTrigger(String group, String name) throws Exception {
        Connection cn = this.connector.getNewConnection();
        String sql = "select 1 from T_QTZ_Triggers where FTriggerGroup=? and FTriggerName=?";
        PreparedStatement stm = cn.prepareStatement(sql);
        try {
            stm.setString(1, group);
            stm.setString(2, name);
            stm.executeQuery();
        }
        finally {
            this.closeStatementAndConnection(stm, cn);
        }
    }

    private void closeStatementAndConnection(Statement stm, Connection cn) {
        try {
            stm.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            cn.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

