/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.support.quartz.impl;

import com.kingdee.bos.support.quartz.impl.JobStoreHelper;
import com.kingdee.bos.support.quartz.impl.JobWrapper;
import com.kingdee.bos.support.quartz.impl.TriggerAndJobs;
import com.kingdee.bos.support.quartz.impl.TriggerWrapper;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.quartz.Calendar;
import org.quartz.JobDetail;
import org.quartz.JobPersistenceException;
import org.quartz.ObjectAlreadyExistsException;
import org.quartz.ScheduleBuilder;
import org.quartz.SchedulerConfigException;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.impl.triggers.AbstractTrigger;
import org.quartz.spi.ClassLoadHelper;
import org.quartz.spi.SchedulerSignaler;

public abstract class PersistenceJobStoreBase {
    private static final Logger logger = Logger.getLogger(PersistenceJobStoreBase.class);
    protected long misfireThreshold = 5000L;
    protected JobStoreHelper helper;
    protected SchedulerSignaler signaler;
    protected ClassLoadHelper loadHelper;
    protected TriggerAndJobs store;
    protected HashSet pausedTriggerGroups = new HashSet();
    protected HashSet blockedJobs = new HashSet();
    protected static final int NEW = 1;
    protected static final int UPDATE = 2;
    protected static final int DELETE = 3;
    private static long ftrCtr = System.currentTimeMillis();
    private boolean closed = false;
    protected ShutdownHook shutdownHook = new ShutdownHook();

    protected abstract void initialize() throws Exception;

    protected void addCalendar(String name, Calendar calendar, boolean replaceExisting, boolean updateTriggers) throws Exception {
        boolean exists = this.store.calendars.containsKey(name);
        if (exists && !replaceExisting) {
            throw new ObjectAlreadyExistsException("Canendar(" + name + ")");
        }
        int method = exists ? 2 : 1;
        this.store.calendars.put(name, calendar);
        this.helper.updateCalendar(name, calendar, method);
    }

    public boolean removeCalendar(String calName) throws JobPersistenceException {
        if (!this.store.calendars.containsKey(calName)) {
            return false;
        }
        for (TriggerWrapper tw : this.store.allTriggers.values()) {
            if (tw.trigger.getCalendarName() == null || !calName.equals(tw.trigger.getCalendarName())) continue;
            throw new JobPersistenceException("Calender cannot be removed if it referenced by a Trigger!");
        }
        try {
            this.helper.updateCalendar(calName, null, 3);
        }
        catch (Exception e) {
            if (e instanceof JobPersistenceException) {
                throw (JobPersistenceException)((Object)e);
            }
            throw new JobPersistenceException(e.getMessage(), (Throwable)e);
        }
        return true;
    }

    protected void setTriggerState(TriggerWrapper tw, int state) throws Exception {
        if (tw.state != state) {
            this.helper.updateTriggerState(tw, state);
            tw.state = state;
        }
    }

    protected boolean removeTrigger(TriggerWrapper tw) throws Exception {
        if (!this.store.existsTrigger(tw.trigger)) {
            return false;
        }
        this.helper.updateTrigger(tw, 3);
        this.store.removeTrigger(tw);
        JobWrapper jw = (JobWrapper)this.store.allJobs.get(tw.jobKey);
        if (jw != null && jw.jobDetail != null && !jw.jobDetail.isDurable() && this.store.getTriggersForJob(tw.jobKey, false).size() == 0) {
            this.removeJob(jw.jobDetail.getKey().getGroup(), jw.jobDetail.getKey().getName());
        }
        if (this.store.getTriggerGroup(tw.trigger.getKey().getGroup(), false).size() == 0) {
            this.store.groupTriggers.remove(tw.trigger.getKey().getGroup());
        }
        return true;
    }

    protected boolean removeTrigger(String group, String name) throws Exception {
        TriggerWrapper tw = this.store.getTrigger(group, name);
        if (tw == null) {
            return false;
        }
        return this.removeTrigger(tw);
    }

    protected boolean replaceTrigger(String group, String name, Trigger newTrigger) throws Exception {
        TriggerWrapper tw = this.store.getTrigger(group, name);
        if (tw == null) {
            return false;
        }
        if (!tw.getTrigger().getJobKey().getName().equals(newTrigger.getJobKey().getName()) || !tw.getTrigger().getJobKey().getGroup().equals(newTrigger.getJobKey().getGroup())) {
            throw new JobPersistenceException("New trigger is not related to the same job as the old trigger.");
        }
        TriggerWrapper newTw = new TriggerWrapper(newTrigger);
        if (newTw.equals(tw)) {
            this.addTrigger(newTrigger, true);
        } else {
            this.removeTrigger(tw);
            this.addTrigger(newTrigger, false);
        }
        return true;
    }

    protected void addTrigger(Trigger newTrigger, boolean replace) throws Exception {
        TriggerWrapper tw = this.store.getTrigger(TriggerWrapper.getTriggerNameKey(newTrigger));
        if (tw != null && !replace) {
            throw new ObjectAlreadyExistsException(newTrigger);
        }
        if (!this.store.existsJob(newTrigger.getJobKey().getGroup(), newTrigger.getJobKey().getName())) {
            throw new JobPersistenceException("The job (" + newTrigger.getJobKey().toString() + ") referenced by the trigger does not exist.");
        }
        if (tw != null) {
            this.removeTrigger(tw);
        }
        tw = new TriggerWrapper(newTrigger);
        if (this.pausedTriggerGroups.contains(newTrigger.getKey().getGroup())) {
            tw.state = 4;
        } else if (this.blockedJobs.contains(tw.jobKey)) {
            tw.state = 5;
        }
        this.helper.updateTrigger(tw, 1);
        this.store.addTrigger(tw);
        if (tw.state == 0) {
            this.store.timeTriggers.add(tw);
        }
    }

    protected void addJob(JobDetail newJob, boolean replace) throws Exception {
        JobWrapper jw = this.store.getJob(newJob);
        if (jw != null && !replace) {
            throw new ObjectAlreadyExistsException(newJob);
        }
        if (jw != null) {
            this.removeJob(jw.jobDetail.getKey().getGroup(), jw.jobDetail.getKey().getName());
        }
        jw = new JobWrapper(newJob);
        this.helper.updateJob(jw, 1);
        this.store.addJob(jw);
    }

    protected boolean removeJob(String group, String name) throws Exception {
        JobWrapper jw = this.store.getJob(group, name);
        if (jw == null) {
            return false;
        }
        this.helper.updateJob(jw, 3);
        this.store.removeJob(jw);
        Iterator it = this.store.getTriggersForJob(jw.key, false).iterator();
        while (it.hasNext()) {
            this.removeTrigger((TriggerWrapper)it.next());
        }
        return true;
    }

    protected void updateTrigger(TriggerWrapper tw) throws Exception {
        this.helper.updateTrigger(tw, 2);
    }

    protected void updateJob(JobWrapper jw) throws Exception {
        this.helper.updateJob(jw, 2);
    }

    public synchronized void initialize(ClassLoadHelper loadHelper, SchedulerSignaler signaler) throws SchedulerConfigException {
        this.loadHelper = loadHelper;
        this.signaler = signaler;
        try {
            this.initialize();
            assert (this.helper != null);
            this.store = this.helper.initialize(loadHelper);
            ArrayList<TriggerWrapper> timeTriggers = new ArrayList<TriggerWrapper>();
            Object[] tws = this.store.allTriggers.values().toArray();
            for (int i = 0; i < tws.length; ++i) {
                TriggerWrapper tw = (TriggerWrapper)tws[i];
                if (this.store.getTriggerJob(tw) == null) {
                    this.store.removeTrigger(tw);
                    continue;
                }
                if (tw.state == 2 | tw.state == 4 | tw.state == 5) {
                    JobWrapper jw = this.store.getTriggerJob(tw);
                    if (jw == null) {
                        this.removeTrigger(tw);
                        tw = null;
                    } else if (jw.jobDetail.requestsRecovery()) {
                        SimpleTrigger t = (SimpleTrigger)TriggerBuilder.newTrigger().withIdentity("recover_" + tw.key + "_" + tw.jobKey, "RECOVERING_JOBS").forJob(tw.trigger.getJobKey().getName(), tw.trigger.getJobKey().getGroup()).withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withMisfireHandlingInstructionFireNow()).startAt(tw.trigger.getStartTime()).build();
                        this.addTrigger((Trigger)t, false);
                    }
                }
                if (tw == null) continue;
                if (tw.trigger.getNextFireTime() != null) {
                    this.setTriggerState(tw, 0);
                    timeTriggers.add(tw);
                    continue;
                }
                this.removeTrigger(tw);
            }
            this.store.timeTriggers.addAll(timeTriggers);
            this.helper.commit();
            Runtime.getRuntime().addShutdownHook(this.shutdownHook);
        }
        catch (Exception e) {
            this.closed = true;
            if (this.helper != null) {
                this.helper.rollback();
                this.helper.shutdown();
            }
            if (e instanceof SchedulerConfigException) {
                throw (SchedulerConfigException)e;
            }
            throw new SchedulerConfigException("PersistenceJobStore initialize failed", (Throwable)e);
        }
    }

    public long getMisfireThreshold() {
        return this.misfireThreshold;
    }

    public void setMisfireThreshold(long misfireThreshold) {
        if (misfireThreshold < 1L) {
            throw new IllegalArgumentException("Misfirethreashold must be larger than 0");
        }
        this.misfireThreshold = misfireThreshold;
    }

    protected boolean applyMisfire(TriggerWrapper tw) throws Exception {
        Date tnft;
        long misfireTime = System.currentTimeMillis();
        if (this.getMisfireThreshold() > 0L) {
            misfireTime -= this.getMisfireThreshold();
        }
        if ((tnft = tw.trigger.getNextFireTime()).getTime() > misfireTime) {
            return false;
        }
        Calendar cal = null;
        if (tw.trigger.getCalendarName() != null) {
            cal = (Calendar)this.store.calendars.get(tw.trigger.getCalendarName());
        }
        this.signaler.notifyTriggerListenersMisfired(tw.trigger);
        ((AbstractTrigger)tw.trigger).updateAfterMisfire(cal);
        if (tw.trigger.getNextFireTime() == null) {
            this.setTriggerState(tw, 3);
            this.store.timeTriggers.remove(tw);
        } else if (tnft.before(tw.trigger.getNextFireTime())) {
            return false;
        }
        return true;
    }

    protected static synchronized String getFiredTriggerRecordId() {
        return String.valueOf(ftrCtr++);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        PersistenceJobStoreBase persistenceJobStoreBase = this;
        synchronized (persistenceJobStoreBase) {
            if (this.closed) {
                return;
            }
            this.closed = true;
            if (!Thread.currentThread().equals(this.shutdownHook)) {
                Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
            }
        }
        this.helper.shutdown();
        logger.info((Object)(this.getClass().getName() + " has been shutdown."));
    }

    protected synchronized void checkClosed() throws JobPersistenceException {
        if (this.closed) {
            throw new JobPersistenceException("JobStore has been shutdown.");
        }
    }

    public synchronized boolean supportsPersistence() {
        return true;
    }

    private class ShutdownHook
    extends Thread {
        private ShutdownHook() {
        }

        @Override
        public void run() {
            PersistenceJobStoreBase.this.shutdown();
        }
    }
}

