/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.support.quartz.impl;

import com.kingdee.bos.support.quartz.impl.JobWrapper;
import org.quartz.Trigger;

public class TriggerWrapper {
    public String key;
    public String jobKey;
    public Trigger trigger;
    public int state = 0;
    public static final int STATE_WAITING = 0;
    public static final String WAITING = "waiting";
    public static final int STATE_ACQUIRED = 1;
    public static final String ACQUIRED = "acquired";
    public static final int STATE_EXECUTING = 2;
    public static final String EXECUTING = "executing";
    public static final int STATE_COMPLETE = 3;
    public static final String COMPLETE = "complete";
    public static final int STATE_PAUSED = 4;
    public static final String PAUSED = "paused";
    public static final int STATE_BLOCKED = 5;
    public static final String BLOCKED = "blocked";

    public static String stateName(int state) {
        switch (state) {
            case 0: {
                return WAITING;
            }
            case 1: {
                return ACQUIRED;
            }
            case 2: {
                return EXECUTING;
            }
            case 3: {
                return COMPLETE;
            }
            case 4: {
                return PAUSED;
            }
            case 5: {
                return BLOCKED;
            }
        }
        assert (false);
        return null;
    }

    public static int stateFromState(String name) {
        if (name == null) {
            return 0;
        }
        if (name.equalsIgnoreCase(ACQUIRED)) {
            return 1;
        }
        if (name.equalsIgnoreCase(EXECUTING)) {
            return 2;
        }
        if (name.equalsIgnoreCase(COMPLETE)) {
            return 3;
        }
        if (name.equalsIgnoreCase(PAUSED)) {
            return 4;
        }
        if (name.equalsIgnoreCase(BLOCKED)) {
            return 5;
        }
        return 0;
    }

    public static int getTriggerState(int wrapperState) {
        if (wrapperState == 3) {
            return Trigger.TriggerState.COMPLETE.ordinal();
        }
        if (wrapperState == 4) {
            return Trigger.TriggerState.PAUSED.ordinal();
        }
        return Trigger.TriggerState.NORMAL.ordinal();
    }

    public TriggerWrapper(Trigger trigger) {
        this.trigger = trigger;
        this.key = TriggerWrapper.getTriggerNameKey(trigger);
        this.jobKey = JobWrapper.getJobNameKey(trigger.getJobKey().getGroup(), trigger.getJobKey().getName());
    }

    public TriggerWrapper(Trigger trigger, String key) {
        this.trigger = trigger;
        this.key = key;
        this.jobKey = JobWrapper.getJobNameKey(trigger.getJobKey().getGroup(), trigger.getJobKey().getName());
    }

    static String getTriggerNameKey(Trigger trigger) {
        return TriggerWrapper.getTriggerNameKey(trigger.getKey().getName(), trigger.getKey().getGroup());
    }

    static String getTriggerNameKey(String triggerName, String groupName) {
        return groupName + "_$x$x$_" + triggerName;
    }

    public boolean equals(Object obj) {
        if (obj instanceof TriggerWrapper) {
            TriggerWrapper tw = (TriggerWrapper)obj;
            if (tw.key.equals(this.key)) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public Trigger getTrigger() {
        return this.trigger;
    }
}

