/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool.celleditors;

import java.util.List;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.widgets.Composite;

public class EnumerateCellEditor
extends ComboBoxCellEditor {
    private List values = null;
    private ILabelProvider lp = null;
    private boolean sorted = false;

    public EnumerateCellEditor(Composite parent, List values, ILabelProvider labelProvider) {
        this(parent, values, labelProvider, false, 8);
    }

    public EnumerateCellEditor(Composite parent, List values, ILabelProvider labelProvider, boolean sorted) {
        this(parent, values, labelProvider, sorted, 8);
    }

    public EnumerateCellEditor(Composite parent, List values, ILabelProvider labelProvider, int style) {
        this(parent, values, labelProvider, false, style);
    }

    public EnumerateCellEditor(Composite parent, List values, ILabelProvider labelProvider, boolean sorted, int style) {
        super(parent, EnumerateCellEditor.createItems(values, labelProvider, sorted), style);
        this.values = values;
        this.lp = labelProvider;
        this.sorted = sorted;
    }

    private static String[] createItems(List list, ILabelProvider labelProvider, boolean sorted) {
        String[] result;
        if (list != null && list.size() > 0) {
            result = new String[list.size()];
            int i = 0;
            for (Object object : list) {
                result[i] = labelProvider != null ? labelProvider.getText(object) : object.toString();
                ++i;
            }
        } else {
            result = new String[]{};
        }
        return result;
    }

    public Object doGetValue() {
        int index = (Integer)super.doGetValue();
        return index < this.values.size() && index >= 0 ? this.values.get(index) : null;
    }

    public void doSetValue(Object value) {
        int index = this.values.indexOf(value);
        if (index != -1) {
            super.doSetValue((Object)new Integer(index));
        }
    }

    public void setItemValues(List values) {
        this.values = values;
        super.setItems(EnumerateCellEditor.createItems(values, this.lp, this.sorted));
    }
}

