/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool.console;

import com.kingdee.bos.tool.ToolBasePlugin;
import com.kingdee.bos.tool.console.IHyperLink;
import com.kingdee.bos.tool.console.UserStreamManager;
import org.eclipse.jface.text.AbstractDocument;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultLineTracker;
import org.eclipse.jface.text.GapTextStore;
import org.eclipse.jface.text.ILineTracker;
import org.eclipse.jface.text.ITextStore;
import org.eclipse.swt.graphics.Color;

public class ConsoleDocument
extends AbstractDocument {
    private IHyperLink[] fLineLinks;
    private Color[] fLineColors;
    private int fCurrentLine = 0;

    public ConsoleDocument(String streamId) {
        this.setTextStore((ITextStore)new GapTextStore(512, 1024));
        this.setLineTracker((ILineTracker)new DefaultLineTracker());
        this.completeInitialization();
    }

    public String getStreamId() {
        return null;
    }

    public boolean isReadOnly() {
        return true;
    }

    public Color getLineColor(int offset) {
        try {
            int line = this.getLineOfOffset(offset);
            if (line < this.fCurrentLine) {
                return this.fLineColors[line];
            }
        }
        catch (BadLocationException e) {
            ToolBasePlugin.log(e);
        }
        return UserStreamManager.NORMAL_COLOR;
    }

    public IHyperLink getLineLink(int offset) {
        try {
            int line = this.getLineOfOffset(offset);
            if (line < this.fCurrentLine) {
                return this.fLineLinks[line];
            }
        }
        catch (BadLocationException e) {
            ToolBasePlugin.log(e);
        }
        return null;
    }

    public void addLine(String text, Color color, IHyperLink link) {
        try {
            if (this.fLineColors == null) {
                this.fLineColors = new Color[32];
                this.fLineLinks = new IHyperLink[32];
            } else if (this.fCurrentLine >= this.fLineColors.length) {
                Color[] oldLineColors = this.fLineColors;
                IHyperLink[] oldLineLinks = this.fLineLinks;
                this.fLineColors = new Color[oldLineColors.length * 2];
                this.fLineLinks = new IHyperLink[oldLineLinks.length * 2];
                System.arraycopy(oldLineColors, 0, this.fLineColors, 0, oldLineColors.length);
                System.arraycopy(oldLineLinks, 0, this.fLineLinks, 0, oldLineLinks.length);
            }
            this.fLineColors[this.fCurrentLine] = color;
            this.fLineLinks[this.fCurrentLine] = link;
            ++this.fCurrentLine;
            this.replace(this.getLength(), 0, text + "\n");
        }
        catch (BadLocationException e) {
            ToolBasePlugin.log(e);
        }
    }

    public void clear() {
        this.fLineColors = null;
        this.fLineLinks = null;
        this.fCurrentLine = 0;
        this.set("");
    }

    public int getLineOfLink(IHyperLink fCurrentLink) {
        if (this.fLineLinks == null) {
            return -1;
        }
        for (int i = 0; i < this.fLineLinks.length; ++i) {
            if (fCurrentLink != this.fLineLinks[i]) continue;
            return i;
        }
        return -1;
    }
}

