/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool.utils;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;

public class IDEImages {
    private static HashMap tools = new HashMap(10);
    private URL fgIconBaseURL;
    private HashMap fImageDescriptors = new HashMap();
    private ImageRegistry fImageRegistry = new ImageRegistry();

    private IDEImages(URL url) {
        this.fgIconBaseURL = url;
    }

    public Image getImage(String key) {
        Image image = this.fImageRegistry.get(key);
        if (image != null) {
            return image;
        }
        ImageDescriptor desc = (ImageDescriptor)this.fImageDescriptors.get(key);
        if (desc == null) {
            desc = this.create(key);
        }
        this.fImageRegistry.put(key, desc);
        return this.fImageRegistry.get(key);
    }

    public ImageDescriptor getImageDescriptor(String key) {
        ImageDescriptor desc = (ImageDescriptor)this.fImageDescriptors.get(key);
        if (desc != null) {
            return desc;
        }
        desc = this.create(key);
        this.fImageDescriptors.put(key, desc);
        return desc;
    }

    public static IDEImages getInstance(URL url) {
        IDEImages images = (IDEImages)tools.get(url);
        if (images == null) {
            images = new IDEImages(url);
            tools.put(url, images);
        }
        return images;
    }

    private ImageDescriptor create(String name) {
        try {
            return ImageDescriptor.createFromURL((URL)this.makeIconFileURL(name));
        }
        catch (MalformedURLException e) {
            return ImageDescriptor.getMissingImageDescriptor();
        }
    }

    private URL makeIconFileURL(String key) throws MalformedURLException {
        if (this.fgIconBaseURL == null) {
            throw new MalformedURLException();
        }
        return new URL(this.fgIconBaseURL, key);
    }
}

