/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool.validators;

import com.kingdee.bos.tool.validators.CommonValidator;
import org.eclipse.jface.viewers.ICellEditorValidator;

public class FloatValidator
implements ICellEditorValidator {
    private boolean nullable;
    private boolean isRangeSet;
    private float minValidValue = Float.MIN_VALUE;
    private float maxValidValue = Float.MAX_VALUE;

    public FloatValidator() {
        this(true);
    }

    public FloatValidator(boolean isNullable) {
        this.nullable = isNullable;
    }

    public String isValid(Object value) {
        Float[] ranges = null;
        if (this.isRangeSet) {
            ranges = new Float[]{new Float(this.minValidValue), new Float(this.maxValidValue)};
        }
        return CommonValidator.isValid(value, this.nullable, 3, ranges);
    }

    public void setNullable(boolean isNullable) {
        this.nullable = isNullable;
    }

    public void setMinValidValue(float minValidValue) {
        this.isRangeSet = true;
        this.minValidValue = minValidValue;
    }

    public void setMaxValidValue(float maxValidValue) {
        this.isRangeSet = true;
        this.maxValidValue = maxValidValue;
    }
}

