/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.md.cache;

import com.kingdee.bos.md.mdfs.IMDFile;
import com.kingdee.bos.md.mdfs.IMDFolder;
import com.kingdee.bos.md.mdfs.IMDObject;
import com.kingdee.bos.md.mdfs.IMDProject;
import com.kingdee.bos.md.mdfs.IMDResource;
import com.kingdee.bos.tool.FileUtils;
import com.kingdee.bos.tool.LogTool;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.swt.widgets.Shell;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.input.SAXBuilder;

public class AliasUtil {
    private static Map<IMDProject, AliasUtil> managers = new HashMap<IMDProject, AliasUtil>();
    private IMDProject project;
    private Thread thread;
    private File cacheFile = null;
    private Properties props = new Properties();
    private boolean[] needStore = new boolean[]{false};
    private boolean stop = false;
    private static final String RELOAD_FLAG_STRING = "com.kingdee.bos.md.cache.AliasUtil.RELOAD_FLAG_STRING";
    private static SAXBuilder builder = new SAXBuilder();

    private static AliasUtil getInstance(IMDProject project) {
        if (project == null) {
            return null;
        }
        AliasUtil m = managers.get(project);
        if (m == null) {
            m = new AliasUtil(project);
            managers.put(project, m);
        }
        return m;
    }

    public static void removeInstance(IMDProject project) {
        AliasUtil instance = managers.remove(project);
        if (instance != null) {
            instance.stop();
            instance = null;
        }
    }

    public void stop() {
        this.stop = true;
        this.thread.interrupt();
        this.project = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AliasUtil(IMDProject project) {
        this.project = project;
        this.cacheFile = new File(project.toFile(), "cache/mdnacache.properties");
        if (this.cacheFile.exists()) {
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(this.cacheFile);
                this.props.load(fileInputStream);
            }
            catch (IOException e) {
                try {
                    LogTool.logError("\u52a0\u8f7d\u7f13\u5b58\u65f6\u53d1\u751f\u9519\u8bef", e);
                }
                catch (Throwable throwable) {
                    FileUtils.close(fileInputStream);
                    throw throwable;
                }
                FileUtils.close(fileInputStream);
            }
            FileUtils.close(fileInputStream);
        }
        this.thread = new Thread("\u540e\u53f0\u4fdd\u5b58\u7ebf\u7a0b[" + project.getName() + "]"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (!AliasUtil.this.stop) {
                    boolean store = false;
                    boolean[] blArray = AliasUtil.this.needStore;
                    synchronized (blArray) {
                        if (AliasUtil.this.needStore[0]) {
                            store = true;
                            ((AliasUtil)AliasUtil.this).needStore[0] = false;
                        }
                    }
                    if (store) {
                        if (!AliasUtil.this.cacheFile.exists()) {
                            AliasUtil.this.cacheFile.getParentFile().mkdirs();
                        }
                        FileOutputStream fileOutputStream = null;
                        try {
                            fileOutputStream = new FileOutputStream(AliasUtil.this.cacheFile);
                            AliasUtil.this.props.store(fileOutputStream, "ToolCommon store at:" + System.currentTimeMillis());
                        }
                        catch (IOException iOException) {
                            FileUtils.close(fileOutputStream);
                        }
                        catch (Throwable throwable) {
                            FileUtils.close(fileOutputStream);
                            throw throwable;
                        }
                        FileUtils.close(fileOutputStream);
                    }
                    try {
                        Thread.sleep(100000L);
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                }
            }
        };
        this.thread.setDaemon(true);
        this.thread.start();
    }

    public static String getAlias(IMDObject element) {
        if (element instanceof IMDResource) {
            return AliasUtil.getAlias((IMDResource)element);
        }
        return element.getName();
    }

    public static String getAlias(IMDResource resource) {
        if (resource.isRoot()) {
            return resource.getMDProject().getName();
        }
        if (resource.getMDProject().isDisposed()) {
            return resource.getName();
        }
        AliasUtil util = AliasUtil.getInstance(resource.getMDProject());
        if (resource instanceof IMDFile) {
            IMDFile file = (IMDFile)resource;
            String alias = util.getAlias_inner(file);
            if (StringUtils.isEmpty((String)alias) || "null".equals(alias)) {
                alias = file.getName();
                if (alias.indexOf(46) != -1) {
                    alias = alias.substring(0, alias.lastIndexOf(46));
                }
                return alias;
            }
            return alias;
        }
        if (resource instanceof IMDFolder) {
            IMDFolder folder = (IMDFolder)resource;
            IMDFile file = folder.getChildFile(folder.getName() + ".package");
            if (!file.exists()) {
                return folder.getName();
            }
            String alias = util.getAlias_inner(file);
            if (StringUtils.isEmpty((String)alias) || "null".equals(alias)) {
                return folder.getName();
            }
            return alias;
        }
        return resource.getName();
    }

    private String getAlias_inner(String key, long modified) {
        String value = this.props.getProperty(key);
        if (StringUtils.isEmpty((String)value)) {
            return RELOAD_FLAG_STRING;
        }
        long t = -1L;
        try {
            t = Long.parseLong(value.substring(value.lastIndexOf(58) + 1));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (t != modified) {
            return RELOAD_FLAG_STRING;
        }
        return value.substring(0, value.lastIndexOf(58));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String reload(InputStream input, String key, long modified) {
        String alias = this.getAlias(input);
        if (alias == null) {
            return null;
        }
        String value = alias + ":" + modified;
        this.props.put(key, value);
        boolean[] blArray = this.needStore;
        synchronized (this.needStore) {
            this.needStore[0] = true;
            // ** MonitorExit[var7_6] (shouldn't be in output)
            return alias;
        }
    }

    private String getAlias_inner(IMDFile file) {
        String value = this.getAlias_inner(file.getPath(), file.lastModified());
        if (value != RELOAD_FLAG_STRING) {
            return value;
        }
        try {
            InputStream input = file.getLocalContent();
            if (input != null) {
                value = this.reload(input, file.getPath(), file.lastModified());
            }
            if (!(value != null && value != RELOAD_FLAG_STRING || value != null && value != RELOAD_FLAG_STRING || (input = file.getLibContent()) == null)) {
                value = this.reload(input, file.getPath(), file.lastModified());
            }
            if (value == RELOAD_FLAG_STRING) {
                return null;
            }
            return value;
        }
        catch (IOException e) {
            return null;
        }
    }

    public static void indexCache(Shell shell, IMDProject project, String suffixes) throws Exception {
        AliasUtil.getInstance(project).indexCache(shell, suffixes.split(";"));
    }

    private void startIndexThread(IMDFile[] part) {
        for (int i = 0; i < part.length; ++i) {
            try {
                String alias = this.getAlias(part[i].getContent());
                this.props.put(part[i].getPath(), alias + ":" + part[i].lastModified());
                continue;
            }
            catch (Exception e) {
                LogTool.logError("", e);
            }
        }
    }

    private void indexCache(Shell shell, String[] suffixes) {
        IMDFile[] mdFiles;
        int i;
        if (suffixes == null || suffixes.length == 0) {
            return;
        }
        int totalSize = 0;
        ArrayList<IMDFile[]> allFiles = new ArrayList<IMDFile[]>();
        for (i = 0; i < suffixes.length; ++i) {
            mdFiles = this.project.getRoot().listAllFile(suffixes[i]);
            allFiles.add(mdFiles);
            totalSize += mdFiles.length;
        }
        for (i = 0; i < allFiles.size(); ++i) {
            mdFiles = (IMDFile[])allFiles.get(i);
            this.startIndexThread(mdFiles);
        }
        this.store();
    }

    private void store() {
        if (!this.cacheFile.exists()) {
            this.cacheFile.getParentFile().mkdirs();
        }
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(this.cacheFile);
            this.props.store(fileOutputStream, "By ToolCommon:" + System.currentTimeMillis());
        }
        catch (IOException e) {
            try {
                LogTool.logError("", e);
            }
            catch (Throwable throwable) {
                FileUtils.close(fileOutputStream);
                throw throwable;
            }
            FileUtils.close(fileOutputStream);
        }
        FileUtils.close(fileOutputStream);
    }

    private String getAlias(InputStream input) {
        Document jdoc;
        try {
            jdoc = builder.build(input);
            input.close();
        }
        catch (Exception ex) {
            return null;
        }
        Element root = jdoc.getRootElement();
        Namespace ns = root.getNamespace();
        Element aliasEl = root.getChild("alias", ns);
        if (aliasEl == null) {
            return null;
        }
        String key = aliasEl.getText();
        Element rs = root.getChild("resource", root.getNamespace());
        if (rs == null) {
            return null;
        }
        List ls = rs.getChildren();
        for (int i = 0; i < ls.size(); ++i) {
            Element el = (Element)ls.get(i);
            if (!key.equalsIgnoreCase(el.getAttributeValue("key"))) continue;
            List lsRs = el.getChildren();
            for (int j = 0; j < lsRs.size(); ++j) {
                el = (Element)lsRs.get(j);
                String lang = el.getAttributeValue("locale");
                if (!lang.equalsIgnoreCase("zh_CN") && !"l2".equals(lang)) continue;
                return el.getAttributeValue("value");
            }
        }
        return null;
    }
}

