/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.md.command;

import com.kingdee.bos.engine.IDevMetadataLoader;
import com.kingdee.bos.md.mdfs.IMDFile;
import com.kingdee.bos.md.mdfs.MDResourceUtil;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.tool.LogTool;
import com.kingdee.bos.tool.dao.ICommand;
import com.kingdee.bos.util.BOSObjectType;
import org.eclipse.core.runtime.IProgressMonitor;

public class MDDeleteFileCommand
implements ICommand {
    private IMDFile file;

    public MDDeleteFileCommand(IMDFile file) {
        this.file = file;
    }

    @Override
    public void exec(IProgressMonitor monitor) {
        if (this.file != null && this.file.exists() && this.file.toFile().exists()) {
            BOSObjectType type = this.file.getBOSType();
            MetaDataPK pk = this.file.getMetaDataPK();
            IDevMetadataLoader loader = this.file.getMDProject().getMetadataLoader();
            if (type != null && pk != null && loader.exist(type, (IMetaDataPK)pk)) {
                try {
                    loader.deleteMetadata(this.file.getBOSType(), (IMetaDataPK)this.file.getMetaDataPK());
                }
                catch (Exception e) {
                    LogTool.logError("\u5220\u9664\u5143\u6570\u636e\u65f6\u51fa\u9519", e);
                }
            } else {
                this.file.toFile().delete();
            }
            MDResourceUtil.fireResourceDeleted(this.file);
        }
    }
}

